/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.geom.spacial.SpacialIndex2D;
import cytoscape.graph.fixed.FixedGraph;
import cytoscape.render.export.ImageImposter;
import cytoscape.render.immed.EdgeAnchors;
import cytoscape.render.immed.GraphGraphics;
import cytoscape.render.stateful.EdgeDetails;
import cytoscape.render.stateful.GraphLOD;
import cytoscape.render.stateful.GraphRenderer;
import cytoscape.render.stateful.NodeDetails;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import cytoscape.util.intr.IntStack;
import ding.view.DEdgeView;
import ding.view.DGraphView;
import ding.view.DNodeView;
import ding.view.GraphViewEdgesSelectedEvent;
import ding.view.GraphViewEdgesUnselectedEvent;
import ding.view.GraphViewNodesSelectedEvent;
import ding.view.GraphViewNodesUnselectedEvent;
import ding.view.NodeContextMenuListener;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import phoebe.PhoebeCanvasDropEvent;
import phoebe.PhoebeCanvasDropListener;
import phoebe.PhoebeCanvasDroppable;

public class InnerCanvas
extends JComponent
implements MouseListener,
MouseMotionListener,
DropTargetListener,
PhoebeCanvasDroppable {
    final double[] m_ptBuff = new double[2];
    final float[] m_extentsBuff2 = new float[4];
    final float[] m_floatBuff1 = new float[2];
    final float[] m_floatBuff2 = new float[2];
    final Line2D.Float m_line = new Line2D.Float();
    final GeneralPath m_path = new GeneralPath();
    final GeneralPath m_path2 = new GeneralPath();
    final IntStack m_stack = new IntStack();
    final IntStack m_stack2 = new IntStack();
    final Object m_lock;
    DGraphView m_view;
    GraphLOD m_lod;
    final IntHash m_hash;
    Image m_img;
    GraphGraphics m_grafx;
    Paint m_bgPaint;
    double m_xCenter;
    double m_yCenter;
    double m_scaleFactor;
    private int m_lastRenderDetail = 0;
    private Rectangle m_selectionRect = null;
    private DropTarget dropTarget;
    private String CANVAS_DROP = "CanvasDrop";
    public Vector listeners = new Vector();
    public Vector nodeContextMenuListeners = new Vector();
    private int m_currMouseButton = 0;
    private int m_lastXMousePos = 0;
    private int m_lastYMousePos = 0;
    private boolean m_button1NodeDrag = false;

    InnerCanvas(Object lock, DGraphView view) {
        this.m_lock = lock;
        this.m_view = view;
        this.m_lod = new GraphLOD();
        this.m_hash = new IntHash();
        this.m_bgPaint = Color.white;
        this.m_xCenter = 0.0;
        this.m_yCenter = 0.0;
        this.m_scaleFactor = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.dropTarget = new DropTarget(this, 1, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (width > 0 && height > 0) {
            BufferedImage img = new BufferedImage(width, height, 2);
            GraphGraphics grafx = new GraphGraphics((Image)img, false);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_img = img;
                this.m_grafx = grafx;
                this.m_view.m_viewportChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g) {
        Object lis;
        if (this.m_grafx == null) {
            return;
        }
        boolean contentChanged = false;
        boolean viewportChanged = false;
        double xCenter = 0.0;
        double yCenter = 0.0;
        double scaleFactor = 1.0;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_view.m_contentChanged || this.m_view.m_viewportChanged) {
                this.m_lastRenderDetail = GraphRenderer.renderGraph((FixedGraph)((FixedGraph)this.m_view.m_drawPersp), (SpacialIndex2D)this.m_view.m_spacial, (GraphLOD)this.m_lod, (NodeDetails)this.m_view.m_nodeDetails, (EdgeDetails)this.m_view.m_edgeDetails, (IntHash)this.m_hash, (GraphGraphics)this.m_grafx, (Paint)this.m_bgPaint, (double)this.m_xCenter, (double)this.m_yCenter, (double)this.m_scaleFactor);
                contentChanged = this.m_view.m_contentChanged;
                this.m_view.m_contentChanged = false;
                viewportChanged = this.m_view.m_viewportChanged;
                xCenter = this.m_xCenter;
                yCenter = this.m_yCenter;
                scaleFactor = this.m_scaleFactor;
                this.m_view.m_viewportChanged = false;
            }
        }
        g.drawImage(this.m_img, 0, 0, null);
        if (this.m_selectionRect != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.red);
            g2.draw(this.m_selectionRect);
        }
        if (contentChanged && (lis = this.m_view.m_cLis[0]) != null) {
            lis.contentChanged();
        }
        if (viewportChanged && (lis = this.m_view.m_vLis[0]) != null) {
            lis.viewportChanged(this.getWidth(), this.getHeight(), xCenter, yCenter, scaleFactor);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics g) {
        ImageImposter img = new ImageImposter(g, this.getWidth(), this.getHeight());
        Object object = this.m_lock;
        synchronized (object) {
            GraphRenderer.renderGraph((FixedGraph)((FixedGraph)this.m_view.m_drawPersp), (SpacialIndex2D)this.m_view.m_spacial, (GraphLOD)this.m_lod, (NodeDetails)this.m_view.m_nodeDetails, (EdgeDetails)this.m_view.m_edgeDetails, (IntHash)this.m_hash, (GraphGraphics)new GraphGraphics((Image)img, false), (Paint)this.m_bgPaint, (double)this.m_xCenter, (double)this.m_yCenter, (double)this.m_scaleFactor);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.m_currMouseButton = 1;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
            int[] unselectedNodes = null;
            int[] unselectedEdges = null;
            int chosenNode = 0;
            int chosenEdge = 0;
            int chosenNodeSelected = 0;
            int chosenEdgeSelected = 0;
            Object object = this.m_lock;
            synchronized (object) {
                boolean wasSelected;
                if (this.m_view.m_nodeSelection) {
                    this.m_ptBuff[0] = this.m_lastXMousePos;
                    this.m_ptBuff[1] = this.m_lastYMousePos;
                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                    this.m_stack.empty();
                    this.m_view.getNodesIntersectingRectangle((float)this.m_ptBuff[0], (float)this.m_ptBuff[1], (float)this.m_ptBuff[0], (float)this.m_ptBuff[1], (this.m_lastRenderDetail & 1) == 0, this.m_stack);
                    int n = chosenNode = this.m_stack.size() > 0 ? this.m_stack.peek() : 0;
                }
                if (this.m_view.m_edgeSelection && chosenNode == 0) {
                    this.computeEdgesIntersecting(this.m_lastXMousePos - 1, this.m_lastYMousePos - 1, this.m_lastXMousePos + 1, this.m_lastYMousePos + 1);
                    int n = chosenEdge = this.m_stack2.size() > 0 ? this.m_stack2.peek() : 0;
                }
                if (!(e.isShiftDown() || (chosenNode != 0 || chosenEdge != 0) && (chosenNode != 0 && this.m_view.getNodeView(chosenNode).isSelected() || chosenEdge != 0 && this.m_view.getEdgeView(chosenEdge).isSelected()))) {
                    int i;
                    if (this.m_view.m_nodeSelection) {
                        unselectedNodes = this.m_view.getSelectedNodeIndices();
                        this.m_view.m_selectedNodes.empty();
                        for (i = 0; i < unselectedNodes.length; ++i) {
                            ((DNodeView)this.m_view.getNodeView(unselectedNodes[i])).unselectInternal();
                        }
                    } else {
                        unselectedNodes = new int[]{};
                    }
                    if (this.m_view.m_edgeSelection) {
                        unselectedEdges = this.m_view.getSelectedEdgeIndices();
                        this.m_view.m_selectedEdges.empty();
                        for (i = 0; i < unselectedEdges.length; ++i) {
                            ((DEdgeView)this.m_view.getEdgeView(unselectedEdges[i])).unselectInternal();
                        }
                    } else {
                        unselectedEdges = new int[]{};
                    }
                    if (unselectedNodes.length > 0 || unselectedEdges.length > 0) {
                        this.m_view.m_contentChanged = true;
                    }
                }
                if (chosenNode != 0) {
                    wasSelected = this.m_view.getNodeView(chosenNode).isSelected();
                    if (wasSelected && e.isShiftDown()) {
                        ((DNodeView)this.m_view.getNodeView(chosenNode)).unselectInternal();
                        chosenNodeSelected = -1;
                    } else if (!wasSelected) {
                        ((DNodeView)this.m_view.getNodeView(chosenNode)).selectInternal();
                        chosenNodeSelected = 1;
                    }
                    this.m_button1NodeDrag = true;
                    this.m_view.m_contentChanged = true;
                }
                if (chosenEdge != 0) {
                    wasSelected = this.m_view.getEdgeView(chosenEdge).isSelected();
                    if (wasSelected && e.isShiftDown()) {
                        ((DEdgeView)this.m_view.getEdgeView(chosenEdge)).unselectInternal();
                        chosenEdgeSelected = -1;
                    } else if (!wasSelected) {
                        ((DEdgeView)this.m_view.getEdgeView(chosenEdge)).selectInternal();
                        chosenEdgeSelected = 1;
                    }
                    this.m_button1NodeDrag = true;
                    this.m_view.m_contentChanged = true;
                }
                if (chosenNode == 0 && chosenEdge == 0) {
                    this.m_selectionRect = new Rectangle(this.m_lastXMousePos, this.m_lastYMousePos, 0, 0);
                    this.m_button1NodeDrag = false;
                }
            }
            GraphViewChangeListener listener = this.m_view.m_lis[0];
            if (listener != null) {
                if (unselectedNodes != null && unselectedNodes.length > 0) {
                    listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesUnselectedEvent(this.m_view, unselectedNodes));
                }
                if (unselectedEdges != null && unselectedEdges.length > 0) {
                    listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesUnselectedEvent(this.m_view, unselectedEdges));
                }
                if (chosenNode != 0) {
                    if (chosenNodeSelected > 0) {
                        listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesSelectedEvent(this.m_view, new int[]{chosenNode}));
                    } else if (chosenNodeSelected < 0) {
                        listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesUnselectedEvent(this.m_view, new int[]{chosenNode}));
                    }
                }
                if (chosenEdge != 0) {
                    if (chosenEdgeSelected > 0) {
                        listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesSelectedEvent(this.m_view, new int[]{chosenEdge}));
                    } else if (chosenEdgeSelected < 0) {
                        listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesUnselectedEvent(this.m_view, new int[]{chosenEdge}));
                    }
                }
            }
            this.repaint();
        } else if (e.getButton() == 2) {
            this.m_currMouseButton = 2;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
        } else if (e.getButton() == 3) {
            this.m_currMouseButton = 3;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
            this.processNodeContextMenuEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.m_currMouseButton == 1) {
                this.m_currMouseButton = 0;
                if (this.m_selectionRect != null) {
                    int[] selectedNodes = null;
                    int[] selectedEdges = null;
                    Object object = this.m_lock;
                    synchronized (object) {
                        if (this.m_view.m_nodeSelection || this.m_view.m_edgeSelection) {
                            if (this.m_view.m_nodeSelection) {
                                int i;
                                this.m_ptBuff[0] = this.m_selectionRect.x;
                                this.m_ptBuff[1] = this.m_selectionRect.y + this.m_selectionRect.height;
                                this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                                double xMin = this.m_ptBuff[0];
                                double yMin = this.m_ptBuff[1];
                                this.m_ptBuff[0] = this.m_selectionRect.x + this.m_selectionRect.width;
                                this.m_ptBuff[1] = this.m_selectionRect.y;
                                this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                                double xMax = this.m_ptBuff[0];
                                double yMax = this.m_ptBuff[1];
                                this.m_stack.empty();
                                this.m_view.getNodesIntersectingRectangle((float)xMin, (float)yMin, (float)xMax, (float)yMax, (this.m_lastRenderDetail & 1) == 0, this.m_stack);
                                selectedNodes = new int[this.m_stack.size()];
                                IntEnumerator nodes = this.m_stack.elements();
                                for (i = 0; i < selectedNodes.length; ++i) {
                                    selectedNodes[i] = nodes.nextInt();
                                }
                                for (i = 0; i < selectedNodes.length; ++i) {
                                    ((DNodeView)this.m_view.getNodeView(selectedNodes[i])).selectInternal();
                                }
                                if (selectedNodes.length > 0) {
                                    this.m_view.m_contentChanged = true;
                                }
                            }
                            if (this.m_view.m_edgeSelection) {
                                int i;
                                this.computeEdgesIntersecting(this.m_selectionRect.x, this.m_selectionRect.y, this.m_selectionRect.x + this.m_selectionRect.width, this.m_selectionRect.y + this.m_selectionRect.height);
                                selectedEdges = new int[this.m_stack2.size()];
                                IntEnumerator edges = this.m_stack2.elements();
                                for (i = 0; i < selectedEdges.length; ++i) {
                                    selectedEdges[i] = edges.nextInt();
                                }
                                for (i = 0; i < selectedEdges.length; ++i) {
                                    ((DEdgeView)this.m_view.getEdgeView(selectedEdges[i])).selectInternal();
                                }
                                if (selectedEdges.length > 0) {
                                    this.m_view.m_contentChanged = true;
                                }
                            }
                        }
                    }
                    this.m_selectionRect = null;
                    GraphViewChangeListener listener = this.m_view.m_lis[0];
                    if (listener != null) {
                        if (selectedNodes != null && selectedNodes.length > 0) {
                            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesSelectedEvent(this.m_view, selectedNodes));
                        }
                        if (selectedEdges != null && selectedEdges.length > 0) {
                            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesSelectedEvent(this.m_view, selectedEdges));
                        }
                    }
                    this.repaint();
                }
            }
        } else if (e.getButton() == 2) {
            if (this.m_currMouseButton == 2) {
                this.m_currMouseButton = 0;
            }
        } else if (e.getButton() == 3 && this.m_currMouseButton == 3) {
            this.m_currMouseButton = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e) {
        if (this.m_currMouseButton == 1) {
            if (this.m_button1NodeDrag) {
                Object object = this.m_lock;
                synchronized (object) {
                    this.m_ptBuff[0] = this.m_lastXMousePos;
                    this.m_ptBuff[1] = this.m_lastYMousePos;
                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                    double oldX = this.m_ptBuff[0];
                    double oldY = this.m_ptBuff[1];
                    this.m_lastXMousePos = e.getX();
                    this.m_lastYMousePos = e.getY();
                    this.m_ptBuff[0] = this.m_lastXMousePos;
                    this.m_ptBuff[1] = this.m_lastYMousePos;
                    this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
                    double newX = this.m_ptBuff[0];
                    double newY = this.m_ptBuff[1];
                    double deltaX = newX - oldX;
                    double deltaY = newY - oldY;
                    int[] selectedNodes = this.m_view.getSelectedNodeIndices();
                    for (int i = 0; i < selectedNodes.length; ++i) {
                        NodeView nv = this.m_view.getNodeView(selectedNodes[i]);
                        double oldXPos = nv.getXPosition();
                        double oldYPos = nv.getYPosition();
                        nv.setOffset(oldXPos + deltaX, oldYPos + deltaY);
                    }
                    if (selectedNodes.length > 0) {
                        this.m_view.m_contentChanged = true;
                    }
                }
            }
            if (this.m_selectionRect != null) {
                int x = Math.min(this.m_lastXMousePos, e.getX());
                int y = Math.min(this.m_lastYMousePos, e.getY());
                int w = Math.abs(this.m_lastXMousePos - e.getX());
                int h = Math.abs(this.m_lastYMousePos - e.getY());
                this.m_selectionRect.setBounds(x, y, w, h);
            }
            this.repaint();
        } else if (this.m_currMouseButton == 2) {
            double deltaX = e.getX() - this.m_lastXMousePos;
            double deltaY = e.getY() - this.m_lastYMousePos;
            this.m_lastXMousePos = e.getX();
            this.m_lastYMousePos = e.getY();
            Object object = this.m_lock;
            synchronized (object) {
                this.m_xCenter -= deltaX / this.m_scaleFactor;
                this.m_yCenter += deltaY / this.m_scaleFactor;
            }
            this.m_view.m_viewportChanged = true;
            this.repaint();
        } else if (this.m_currMouseButton == 3) {
            double deltaY = e.getY() - this.m_lastYMousePos;
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lastXMousePos = e.getX();
                this.m_lastYMousePos = e.getY();
                this.m_scaleFactor *= Math.pow(2.0, -deltaY / 300.0);
            }
            this.m_view.m_viewportChanged = true;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        NodeView nv = this.m_view.getPickedNodeView(e.getPoint());
        if (nv != null) {
            this.setToolTipText(((DNodeView)nv).getToolTip());
            this.getToolTipText(e);
        }
    }

    private final void computeEdgesIntersecting(int xMini, int yMini, int xMaxi, int yMaxi) {
        this.m_ptBuff[0] = xMini;
        this.m_ptBuff[1] = yMaxi;
        this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
        double xMin = this.m_ptBuff[0];
        double yMin = this.m_ptBuff[1];
        this.m_ptBuff[0] = xMaxi;
        this.m_ptBuff[1] = yMini;
        this.m_view.xformComponentToNodeCoords(this.m_ptBuff);
        double xMax = this.m_ptBuff[0];
        double yMax = this.m_ptBuff[1];
        IntEnumerator edgeNodesEnum = this.m_hash.elements();
        this.m_stack.empty();
        int edgeNodesCount = edgeNodesEnum.numRemaining();
        for (int i = 0; i < edgeNodesCount; ++i) {
            this.m_stack.push(edgeNodesEnum.nextInt());
        }
        this.m_hash.empty();
        edgeNodesEnum = this.m_stack.elements();
        this.m_stack2.empty();
        FixedGraph graph = (FixedGraph)this.m_view.m_drawPersp;
        if ((this.m_lastRenderDetail & 1) == 0) {
            for (int i = 0; i < edgeNodesCount; ++i) {
                int node = edgeNodesEnum.nextInt();
                this.m_view.m_spacial.exists(node, this.m_view.m_extentsBuff, 0);
                float nodeX = (this.m_view.m_extentsBuff[0] + this.m_view.m_extentsBuff[2]) / 2.0f;
                float nodeY = (this.m_view.m_extentsBuff[1] + this.m_view.m_extentsBuff[3]) / 2.0f;
                IntEnumerator touchingEdges = graph.edgesAdjacent(node, true, true, true);
                while (touchingEdges.numRemaining() > 0) {
                    int edge = touchingEdges.nextInt();
                    int otherNode = node ^ graph.edgeSource(edge) ^ graph.edgeTarget(edge);
                    if (this.m_hash.get(otherNode) >= 0) continue;
                    this.m_view.m_spacial.exists(otherNode, this.m_view.m_extentsBuff, 0);
                    float otherNodeX = (this.m_view.m_extentsBuff[0] + this.m_view.m_extentsBuff[2]) / 2.0f;
                    float otherNodeY = (this.m_view.m_extentsBuff[1] + this.m_view.m_extentsBuff[3]) / 2.0f;
                    this.m_line.setLine(nodeX, nodeY, otherNodeX, otherNodeY);
                    if (!this.m_line.intersects(xMin, yMin, xMax - xMin, yMax - yMin)) continue;
                    this.m_stack2.push(~edge);
                }
                this.m_hash.put(node);
            }
        } else {
            for (int i = 0; i < edgeNodesCount; ++i) {
                int node = edgeNodesEnum.nextInt();
                this.m_view.m_spacial.exists(node, this.m_view.m_extentsBuff, 0);
                byte nodeShape = this.m_view.m_nodeDetails.shape(node);
                IntEnumerator touchingEdges = graph.edgesAdjacent(node, true, true, true);
                while (touchingEdges.numRemaining() > 0) {
                    EdgeAnchors anchors;
                    float srcArrowSize;
                    float trgArrowSize;
                    byte srcArrow;
                    byte trgArrow;
                    float[] trgExtents;
                    float[] srcExtents;
                    byte trgShape;
                    byte srcShape;
                    int edge = touchingEdges.nextInt();
                    double segThicknessDiv2 = (double)this.m_view.m_edgeDetails.segmentThickness(edge) / 2.0;
                    int otherNode = node ^ graph.edgeSource(edge) ^ graph.edgeTarget(edge);
                    if (this.m_hash.get(otherNode) >= 0) continue;
                    this.m_view.m_spacial.exists(otherNode, this.m_extentsBuff2, 0);
                    byte otherNodeShape = this.m_view.m_nodeDetails.shape(otherNode);
                    if (node == graph.edgeSource(edge)) {
                        srcShape = nodeShape;
                        trgShape = otherNodeShape;
                        srcExtents = this.m_view.m_extentsBuff;
                        trgExtents = this.m_extentsBuff2;
                    } else {
                        srcShape = otherNodeShape;
                        trgShape = nodeShape;
                        srcExtents = this.m_extentsBuff2;
                        trgExtents = this.m_view.m_extentsBuff;
                    }
                    if ((this.m_lastRenderDetail & 8) == 0) {
                        trgArrow = -1;
                        srcArrow = -1;
                        trgArrowSize = 0.0f;
                        srcArrowSize = 0.0f;
                    } else {
                        srcArrow = this.m_view.m_edgeDetails.sourceArrow(edge);
                        trgArrow = this.m_view.m_edgeDetails.targetArrow(edge);
                        srcArrowSize = srcArrow == -1 ? 0.0f : this.m_view.m_edgeDetails.sourceArrowSize(edge);
                        trgArrowSize = trgArrow == -1 || trgArrow == -7 ? 0.0f : this.m_view.m_edgeDetails.targetArrowSize(edge);
                    }
                    EdgeAnchors edgeAnchors = anchors = (this.m_lastRenderDetail & 0x20) == 0 ? null : this.m_view.m_edgeDetails.anchors(edge);
                    if (!GraphRenderer.computeEdgeEndpoints((GraphGraphics)this.m_grafx, (float[])srcExtents, (byte)srcShape, (byte)srcArrow, (float)srcArrowSize, (EdgeAnchors)anchors, (float[])trgExtents, (byte)trgShape, (byte)trgArrow, (float)trgArrowSize, (float[])this.m_floatBuff1, (float[])this.m_floatBuff2)) continue;
                    this.m_grafx.getEdgePath(srcArrow, srcArrowSize, trgArrow, trgArrowSize, this.m_floatBuff1[0], this.m_floatBuff1[1], anchors, this.m_floatBuff2[0], this.m_floatBuff2[1], this.m_path);
                    GraphRenderer.computeClosedPath((PathIterator)this.m_path.getPathIterator(null), (GeneralPath)this.m_path2);
                    if (!this.m_path2.intersects(xMin - segThicknessDiv2, yMin - segThicknessDiv2, xMax - xMin + segThicknessDiv2 * 2.0, yMax - yMin + segThicknessDiv2 * 2.0)) continue;
                    this.m_stack2.push(~edge);
                }
                this.m_hash.put(node);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dte) {
        dte.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dropActionChanged(DropTargetDragEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dte) {
    }

    public void drop(DropTargetDropEvent dte) {
        dte.acceptDrop(1);
        Transferable t = dte.getTransferable();
        Point pt = dte.getLocation();
        PhoebeCanvasDropEvent event = new PhoebeCanvasDropEvent((PhoebeCanvasDroppable)this, t, pt);
        this.processPhoebeCanvasDropEvent(event);
        dte.dropComplete(true);
    }

    public void addPhoebeCanvasDropListener(PhoebeCanvasDropListener l) {
        this.listeners.addElement(l);
    }

    public void removePhoebeCanvasDropListener(PhoebeCanvasDropListener l) {
        this.listeners.removeElement(l);
    }

    protected synchronized void processPhoebeCanvasDropEvent(PhoebeCanvasDropEvent event) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            PhoebeCanvasDropListener l = (PhoebeCanvasDropListener)e.nextElement();
            l.itemDropped(event);
        }
    }

    public void addNodeContextMenuListener(NodeContextMenuListener l) {
        this.nodeContextMenuListeners.addElement(l);
    }

    public void removeNodeContextMenuListener(NodeContextMenuListener l) {
        this.nodeContextMenuListeners.removeElement(l);
    }

    protected synchronized void processNodeContextMenuEvent(MouseEvent event) {
        NodeView nv = this.m_view.getPickedNodeView(event.getPoint());
        if (nv != null) {
            String nodeLabel = nv.getNode().getIdentifier();
            JPopupMenu menu = new JPopupMenu(nodeLabel);
            menu.setLabel(nodeLabel);
            Enumeration e = this.nodeContextMenuListeners.elements();
            while (e.hasMoreElements()) {
                NodeContextMenuListener l = (NodeContextMenuListener)e.nextElement();
                System.out.println("Adding context menu items for NodeContextMenuListener: " + l);
                l.addNodeContextMenuItems(event.getPoint(), nv, menu);
            }
            menu.show(this, event.getX(), event.getY());
        }
    }

    public int getLastRenderDetail() {
        return this.m_lastRenderDetail;
    }
}

