/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import ding.view.DGraphView;
import ding.view.GraphViewNodesSelectedEvent;
import ding.view.GraphViewNodesUnselectedEvent;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.List;

public class DNodeView
implements NodeView,
Label {
    static final float DEFAULT_WIDTH = 20.0f;
    static final float DEFAULT_HEIGHT = 20.0f;
    static final byte DEFAULT_SHAPE = 2;
    static final Paint DEFAULT_BORDER_PAINT = Color.black;
    static final String DEFAULT_LABEL_TEXT = "";
    static final Font DEFAULT_LABEL_FONT = new Font(null, 0, 1);
    static final Paint DEFAULT_LABEL_PAINT = Color.black;
    DGraphView m_view;
    final int m_inx;
    boolean m_selected;
    Paint m_unselectedPaint;
    Paint m_selectedPaint;
    float m_hiddenXMin;
    float m_hiddenYMin;
    float m_hiddenXMax;
    float m_hiddenYMax;
    String m_toolTipText = null;

    DNodeView(DGraphView view, int inx) {
        this.m_view = view;
        this.m_inx = ~inx;
        this.m_selected = false;
        this.m_unselectedPaint = this.m_view.m_nodeDetails.fillPaint(this.m_inx);
        this.m_selectedPaint = Color.yellow;
    }

    public GraphView getGraphView() {
        return this.m_view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_structPersp.getNode(~this.m_inx);
        }
    }

    public int getGraphPerspectiveIndex() {
        return ~this.m_inx;
    }

    public int getRootGraphIndex() {
        return ~this.m_inx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEdgeViewsList(NodeView otherNodeView) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.getEdgeViewsList(this.getNode(), otherNodeView.getNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShape() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            byte nativeShape = this.m_view.m_nodeDetails.shape(this.m_inx);
            switch (nativeShape) {
                case 0: {
                    return 6;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 7;
                }
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_selectedPaint = paint;
            if (this.isSelected()) {
                this.m_view.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_selectedPaint);
                if (this.m_selectedPaint instanceof Color) {
                    this.m_view.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
                }
                this.m_view.m_contentChanged = true;
            }
        }
    }

    public Paint getSelectedPaint() {
        return this.m_selectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnselectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_unselectedPaint = paint;
            if (!this.isSelected()) {
                this.m_view.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_unselectedPaint);
                if (this.m_unselectedPaint instanceof Color) {
                    this.m_view.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
                }
                this.m_view.m_contentChanged = true;
            }
        }
    }

    public Paint getUnselectedPaint() {
        return this.m_unselectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBorderPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_nodeDetails.overrideBorderPaint(this.m_inx, paint);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paint getBorderPaint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_nodeDetails.borderPaint(this.m_inx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBorderWidth(float width) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_nodeDetails.overrideBorderWidth(this.m_inx, width);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getBorderWidth() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_nodeDetails.borderWidth(this.m_inx);
        }
    }

    public void setBorder(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            this.setBorderWidth(((BasicStroke)stroke).getLineWidth());
        }
    }

    public Stroke getBorder() {
        return new BasicStroke(this.getBorderWidth());
    }

    public void setTransparency(float trans) {
    }

    public float getTransparency() {
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setWidth(double width) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return false;
            }
            double xCenter = ((double)this.m_view.m_extentsBuff[0] + (double)this.m_view.m_extentsBuff[2]) / 2.0;
            double wDiv2 = width / 2.0;
            float xMax = (float)(xCenter + wDiv2);
            float xMin = (float)(xCenter - wDiv2);
            if (!(xMax > xMin)) {
                throw new IllegalArgumentException("width is too small");
            }
            this.m_view.m_spacial.delete(this.m_inx);
            this.m_view.m_spacial.insert(this.m_inx, xMin, this.m_view.m_extentsBuff[1], xMax, this.m_view.m_extentsBuff[3]);
            this.m_view.m_contentChanged = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getWidth() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return -1.0;
            }
            return (double)this.m_view.m_extentsBuff[2] - (double)this.m_view.m_extentsBuff[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHeight(double height) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return false;
            }
            double yCenter = ((double)this.m_view.m_extentsBuff[1] + (double)this.m_view.m_extentsBuff[3]) / 2.0;
            double hDiv2 = height / 2.0;
            float yMax = (float)(yCenter + hDiv2);
            float yMin = (float)(yCenter - hDiv2);
            if (!(yMax > yMin)) {
                throw new IllegalArgumentException("height is too small");
            }
            this.m_view.m_spacial.delete(this.m_inx);
            this.m_view.m_spacial.insert(this.m_inx, this.m_view.m_extentsBuff[0], yMin, this.m_view.m_extentsBuff[2], yMax);
            this.m_view.m_contentChanged = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getHeight() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return -1.0;
            }
            return (double)this.m_view.m_extentsBuff[3] - (double)this.m_view.m_extentsBuff[1];
        }
    }

    public Label getLabel() {
        return this;
    }

    public int getDegree() {
        return this.m_view.getGraphPerspective().getDegree(~this.m_inx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(double x, double y) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return;
            }
            double wDiv2 = ((double)this.m_view.m_extentsBuff[2] - (double)this.m_view.m_extentsBuff[0]) / 2.0;
            double hDiv2 = ((double)this.m_view.m_extentsBuff[3] - (double)this.m_view.m_extentsBuff[1]) / 2.0;
            float xMin = (float)(x - wDiv2);
            float xMax = (float)(x + wDiv2);
            float yMin = (float)(y - hDiv2);
            float yMax = (float)(y + hDiv2);
            if (!(xMax > xMin)) {
                throw new IllegalStateException("width of node has degenerated to zero after rounding");
            }
            if (!(yMax > yMin)) {
                throw new IllegalStateException("height of node has degenerated to zero after rounding");
            }
            this.m_view.m_spacial.delete(this.m_inx);
            this.m_view.m_spacial.insert(this.m_inx, xMin, yMin, xMax, yMax);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getOffset() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return null;
            }
            double xCenter = ((double)this.m_view.m_extentsBuff[0] + (double)this.m_view.m_extentsBuff[2]) / 2.0;
            double yCenter = ((double)this.m_view.m_extentsBuff[1] + (double)this.m_view.m_extentsBuff[3]) / 2.0;
            return new Point2D.Double(xCenter, yCenter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXPosition(double xPos) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return;
            }
            double wDiv2 = ((double)this.m_view.m_extentsBuff[2] - (double)this.m_view.m_extentsBuff[0]) / 2.0;
            float xMax = (float)(xPos + wDiv2);
            float xMin = (float)(xPos - wDiv2);
            if (!(xMax > xMin)) {
                throw new IllegalStateException("width of node has degenerated to zero after rounding");
            }
            this.m_view.m_spacial.delete(this.m_inx);
            this.m_view.m_spacial.insert(this.m_inx, xMin, this.m_view.m_extentsBuff[1], xMax, this.m_view.m_extentsBuff[3]);
            this.m_view.m_contentChanged = true;
        }
    }

    public void setXPosition(double xPos, boolean update) {
        this.setXPosition(xPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getXPosition() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return Double.NaN;
            }
            return ((double)this.m_view.m_extentsBuff[0] + (double)this.m_view.m_extentsBuff[2]) / 2.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYPosition(double yPos) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return;
            }
            double hDiv2 = ((double)this.m_view.m_extentsBuff[3] - (double)this.m_view.m_extentsBuff[1]) / 2.0;
            float yMax = (float)(yPos + hDiv2);
            float yMin = (float)(yPos - hDiv2);
            if (!(yMax > yMin)) {
                throw new IllegalStateException("height of node has degenerated to zero after rounding");
            }
            this.m_view.m_spacial.delete(this.m_inx);
            this.m_view.m_spacial.insert(this.m_inx, this.m_view.m_extentsBuff[0], yMin, this.m_view.m_extentsBuff[2], yMax);
            this.m_view.m_contentChanged = true;
        }
    }

    public void setYPosition(double yPos, boolean update) {
        this.setYPosition(yPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getYPosition() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (!this.m_view.m_spacial.exists(this.m_inx, this.m_view.m_extentsBuff, 0)) {
                return Double.NaN;
            }
            return ((double)this.m_view.m_extentsBuff[1] + (double)this.m_view.m_extentsBuff[3]) / 2.0;
        }
    }

    public void setNodePosition(boolean animate) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.m_view.m_lock;
        synchronized (object) {
            somethingChanged = this.selectInternal();
            if (somethingChanged) {
                this.m_view.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.m_view.m_lis[0]) != null) {
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesSelectedEvent(this.m_view, new int[]{~this.m_inx}));
        }
    }

    boolean selectInternal() {
        if (this.m_selected) {
            return false;
        }
        this.m_selected = true;
        this.m_view.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_selectedPaint);
        if (this.m_selectedPaint instanceof Color) {
            this.m_view.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
        }
        this.m_view.m_selectedNodes.insert(this.m_inx);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselect() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.m_view.m_lock;
        synchronized (object) {
            somethingChanged = this.unselectInternal();
            if (somethingChanged) {
                this.m_view.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.m_view.m_lis[0]) != null) {
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesUnselectedEvent(this.m_view, new int[]{~this.m_inx}));
        }
    }

    boolean unselectInternal() {
        if (!this.m_selected) {
            return false;
        }
        this.m_selected = false;
        this.m_view.m_nodeDetails.overrideFillPaint(this.m_inx, this.m_unselectedPaint);
        if (this.m_unselectedPaint instanceof Color) {
            this.m_view.m_nodeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
        }
        this.m_view.m_selectedNodes.delete(this.m_inx);
        return true;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public boolean setSelected(boolean selected) {
        if (selected) {
            this.select();
        } else {
            this.unselect();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShape(int shape) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            byte nativeShape;
            switch (shape) {
                case 0: {
                    nativeShape = 7;
                    break;
                }
                case 1: {
                    nativeShape = 1;
                    break;
                }
                case 2: {
                    nativeShape = 2;
                    break;
                }
                case 3: {
                    nativeShape = 3;
                    break;
                }
                case 4: {
                    nativeShape = 4;
                    break;
                }
                case 5: {
                    nativeShape = 5;
                    break;
                }
                case 6: {
                    nativeShape = 0;
                    break;
                }
                case 7: {
                    nativeShape = 6;
                    break;
                }
                default: {
                    nativeShape = -1;
                }
            }
            this.m_view.m_nodeDetails.overrideShape(this.m_inx, nativeShape);
            this.m_view.m_contentChanged = true;
        }
    }

    public void setToolTip(String tip) {
        this.m_toolTipText = tip;
        System.out.println("Tooltip set to: " + tip + "for nodeView: + " + this);
    }

    public String getToolTip() {
        return this.m_toolTipText;
    }

    public void setPositionHint(int position) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paint getTextPaint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_nodeDetails.labelPaint(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextPaint(Paint textPaint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_nodeDetails.overrideLabelPaint(this.m_inx, 0, textPaint);
            this.m_view.m_contentChanged = true;
        }
    }

    public double getGreekThreshold() {
        return 0.0;
    }

    public void setGreekThreshold(double threshold) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_nodeDetails.labelText(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_nodeDetails.overrideLabelText(this.m_inx, 0, text);
            if (DEFAULT_LABEL_TEXT.equals(this.m_view.m_nodeDetails.labelText(this.m_inx, 0))) {
                this.m_view.m_nodeDetails.overrideLabelCount(this.m_inx, 0);
            } else {
                this.m_view.m_nodeDetails.overrideLabelCount(this.m_inx, 1);
            }
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_nodeDetails.labelFont(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_nodeDetails.overrideLabelFont(this.m_inx, 0, font);
            this.m_view.m_contentChanged = true;
        }
    }
}

