/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.geom.rtree.RTree;
import cytoscape.geom.spacial.MutableSpacialIndex2D;
import cytoscape.geom.spacial.SpacialEntry2DEnumerator;
import cytoscape.geom.spacial.SpacialIndex2D;
import cytoscape.graph.fixed.FixedGraph;
import cytoscape.render.immed.GraphGraphics;
import cytoscape.render.stateful.EdgeDetails;
import cytoscape.render.stateful.GraphLOD;
import cytoscape.render.stateful.GraphRenderer;
import cytoscape.render.stateful.NodeDetails;
import cytoscape.util.intr.IntBTree;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import cytoscape.util.intr.IntStack;
import ding.view.ContentChangeListener;
import ding.view.ContentChangeListenerChain;
import ding.view.DContextMenu;
import ding.view.DEdgeDetails;
import ding.view.DEdgeView;
import ding.view.DNodeDetails;
import ding.view.DNodeView;
import ding.view.GraphViewChangeListenerChain;
import ding.view.GraphViewEdgesHiddenEvent;
import ding.view.GraphViewEdgesRestoredEvent;
import ding.view.GraphViewEdgesUnselectedEvent;
import ding.view.GraphViewNodesHiddenEvent;
import ding.view.GraphViewNodesRestoredEvent;
import ding.view.GraphViewNodesUnselectedEvent;
import ding.view.InnerCanvas;
import ding.view.NodeContextMenuListener;
import ding.view.ViewportChangeListener;
import ding.view.ViewportChangeListenerChain;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.awt.Component;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DGraphView
implements GraphView {
    final Object m_lock = new Object();
    final float[] m_extentsBuff = new float[4];
    final GeneralPath m_path = new GeneralPath();
    GraphPerspective m_perspective;
    GraphPerspective m_drawPersp;
    GraphPerspective m_structPersp;
    MutableSpacialIndex2D m_spacial;
    DNodeDetails m_nodeDetails;
    DEdgeDetails m_edgeDetails;
    HashMap m_nodeViewMap;
    HashMap m_edgeViewMap;
    String m_identifier;
    final float m_defaultNodeXMin;
    final float m_defaultNodeYMin;
    final float m_defaultNodeXMax;
    final float m_defaultNodeYMax;
    InnerCanvas m_canvas;
    protected DContextMenu contextMenu;
    boolean m_nodeSelection = true;
    boolean m_edgeSelection = true;
    final IntBTree m_selectedNodes;
    final IntBTree m_selectedEdges;
    boolean m_contentChanged = false;
    boolean m_viewportChanged = false;
    final GraphViewChangeListener[] m_lis = new GraphViewChangeListener[1];
    final ContentChangeListener[] m_cLis = new ContentChangeListener[1];
    final ViewportChangeListener[] m_vLis = new ViewportChangeListener[1];
    private final IntHash m_hash = new IntHash();

    public DGraphView(GraphPerspective perspective) {
        this.m_perspective = perspective;
        this.m_drawPersp = this.m_perspective.getRootGraph().createGraphPerspective((int[])null, (int[])null);
        this.m_structPersp = this.m_perspective.getRootGraph().createGraphPerspective((int[])null, (int[])null);
        this.m_spacial = new RTree();
        this.m_nodeDetails = new DNodeDetails();
        this.m_edgeDetails = new DEdgeDetails(this);
        this.m_nodeViewMap = new HashMap();
        this.m_edgeViewMap = new HashMap();
        this.m_defaultNodeXMin = 0.0f;
        this.m_defaultNodeYMin = 0.0f;
        this.m_defaultNodeXMax = this.m_defaultNodeXMin + 20.0f;
        this.m_defaultNodeYMax = this.m_defaultNodeYMin + 20.0f;
        this.m_canvas = new InnerCanvas(this.m_lock, this);
        this.m_selectedNodes = new IntBTree();
        this.m_selectedEdges = new IntBTree();
        System.out.println("DGraphView Built: " + this);
    }

    public GraphPerspective getGraphPerspective() {
        return this.m_perspective;
    }

    public boolean nodeSelectionEnabled() {
        return this.m_nodeSelection;
    }

    public boolean edgeSelectionEnabled() {
        return this.m_edgeSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableNodeSelection() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_nodeSelection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableNodeSelection() {
        int[] unselectedNodes;
        Object object = this.m_lock;
        synchronized (object) {
            this.m_nodeSelection = false;
            unselectedNodes = this.getSelectedNodeIndices();
            if (unselectedNodes.length > 0) {
                this.m_selectedNodes.empty();
                for (int i = 0; i < unselectedNodes.length; ++i) {
                    ((DNodeView)this.getNodeView(unselectedNodes[i])).unselectInternal();
                }
                this.m_contentChanged = true;
            }
        }
        if (unselectedNodes.length > 0) {
            GraphViewChangeListener listener = this.m_lis[0];
            if (listener != null) {
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesUnselectedEvent(this, unselectedNodes));
            }
            this.updateView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableEdgeSelection() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_edgeSelection = true;
        }
    }

    public boolean checkIt() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableEdgeSelection() {
        int[] unselectedEdges;
        Object object = this.m_lock;
        synchronized (object) {
            this.m_edgeSelection = false;
            unselectedEdges = this.getSelectedEdgeIndices();
            if (unselectedEdges.length > 0) {
                this.m_selectedEdges.empty();
                for (int i = 0; i < unselectedEdges.length; ++i) {
                    ((DEdgeView)this.getEdgeView(unselectedEdges[i])).unselectInternal();
                }
                this.m_contentChanged = true;
            }
        }
        if (unselectedEdges.length > 0) {
            GraphViewChangeListener listener = this.m_lis[0];
            if (listener != null) {
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesUnselectedEvent(this, unselectedEdges));
            }
            this.updateView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSelectedNodeIndices() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedNodes.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            int[] returnThis = new int[elms.numRemaining()];
            for (int i = 0; i < returnThis.length; ++i) {
                returnThis[i] = ~elms.nextInt();
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSelectedNodes() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedNodes.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            ArrayList returnThis = new ArrayList();
            while (elms.numRemaining() > 0) {
                returnThis.add(this.m_nodeViewMap.get(new Integer(~elms.nextInt())));
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSelectedEdgeIndices() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedEdges.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            int[] returnThis = new int[elms.numRemaining()];
            for (int i = 0; i < returnThis.length; ++i) {
                returnThis[i] = ~elms.nextInt();
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSelectedEdges() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedEdges.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            ArrayList returnThis = new ArrayList();
            while (elms.numRemaining() > 0) {
                returnThis.add(this.m_edgeViewMap.get(new Integer(~elms.nextInt())));
            }
            return returnThis;
        }
    }

    public void addGraphViewChangeListener(GraphViewChangeListener l) {
        this.m_lis[0] = GraphViewChangeListenerChain.add(this.m_lis[0], l);
    }

    public void removeGraphViewChangeListener(GraphViewChangeListener l) {
        this.m_lis[0] = GraphViewChangeListenerChain.remove(this.m_lis[0], l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundPaint(Paint paint) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_canvas.m_bgPaint = paint;
            this.m_contentChanged = true;
        }
    }

    public Paint getBackgroundPaint() {
        return this.m_canvas.m_bgPaint;
    }

    public Component getComponent() {
        return this.m_canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeView addNodeView(int nodeInx) {
        NodeView newView = null;
        Object object = this.m_lock;
        synchronized (object) {
            newView = this.addNodeViewInternal(nodeInx);
            if (newView == null) {
                return (NodeView)this.m_nodeViewMap.get(new Integer(nodeInx));
            }
            this.m_contentChanged = true;
        }
        GraphViewChangeListener listener = this.m_lis[0];
        if (listener != null) {
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesRestoredEvent(this, new int[]{newView.getRootGraphIndex()}));
        }
        return newView;
    }

    private NodeView addNodeViewInternal(int nodeInx) {
        NodeView oldView = (NodeView)this.m_nodeViewMap.get(new Integer(nodeInx));
        if (oldView != null) {
            return null;
        }
        if (this.m_drawPersp.restoreNode(nodeInx) == 0) {
            if (this.m_drawPersp.getNode(nodeInx) != null) {
                throw new IllegalStateException("something weird is going on - node already existed in graph but a view for it did not exist (debug)");
            }
            throw new IllegalArgumentException("node index specified does not exist in underlying RootGraph");
        }
        this.m_structPersp.restoreNode(nodeInx);
        DNodeView newView = new DNodeView(this, nodeInx);
        this.m_nodeViewMap.put(new Integer(nodeInx), newView);
        this.m_spacial.insert(~nodeInx, this.m_defaultNodeXMin, this.m_defaultNodeYMin, this.m_defaultNodeXMax, this.m_defaultNodeYMax);
        return newView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdgeView addEdgeView(int edgeInx) {
        NodeView sourceNode = null;
        NodeView targetNode = null;
        DEdgeView edgeView = null;
        Object object = this.m_lock;
        synchronized (object) {
            EdgeView oldView = (EdgeView)this.m_edgeViewMap.get(new Integer(edgeInx));
            if (oldView != null) {
                return oldView;
            }
            Edge edge = this.m_drawPersp.getRootGraph().getEdge(edgeInx);
            if (edge == null) {
                throw new IllegalArgumentException("edge index specified does not exist in underlying RootGraph");
            }
            sourceNode = this.addNodeViewInternal(edge.getSource().getRootGraphIndex());
            targetNode = this.addNodeViewInternal(edge.getTarget().getRootGraphIndex());
            if (this.m_drawPersp.restoreEdge(edgeInx) == 0) {
                if (this.m_drawPersp.getEdge(edgeInx) != null) {
                    throw new IllegalStateException("something weird is going on - edge already existed in graph but a view for it did not exist (debug)");
                }
                throw new IllegalArgumentException("edge index specified does not exist in underlying RootGraph");
            }
            this.m_structPersp.restoreEdge(edgeInx);
            edgeView = new DEdgeView(this, edgeInx);
            this.m_edgeViewMap.put(new Integer(edgeInx), edgeView);
            this.m_contentChanged = true;
        }
        GraphViewChangeListener listener = this.m_lis[0];
        if (listener != null) {
            if (sourceNode != null || targetNode != null) {
                int[] nodeInx = sourceNode == null ? new int[]{targetNode.getRootGraphIndex()} : (targetNode == null ? new int[]{sourceNode.getRootGraphIndex()} : new int[]{sourceNode.getRootGraphIndex(), targetNode.getRootGraphIndex()});
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesRestoredEvent(this, nodeInx));
            }
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesRestoredEvent(this, new int[]{edgeView.getRootGraphIndex()}));
        }
        return edgeView;
    }

    public EdgeView addEdgeView(String className, int edgeInx) {
        throw new UnsupportedOperationException("not implemented");
    }

    public NodeView addNodeView(String className, int nodeInx) {
        throw new UnsupportedOperationException("not implemented");
    }

    public NodeView addNodeView(int nodeInx, NodeView replacement) {
        throw new UnsupportedOperationException("not implemented");
    }

    public NodeView removeNodeView(NodeView nodeView) {
        return this.removeNodeView(nodeView.getRootGraphIndex());
    }

    public NodeView removeNodeView(Node node) {
        return this.removeNodeView(node.getRootGraphIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeView removeNodeView(int nodeInx) {
        DNodeView returnThis;
        int[] hiddenEdgeInx;
        Object object = this.m_lock;
        synchronized (object) {
            hiddenEdgeInx = this.m_structPersp.getAdjacentEdgeIndicesArray(nodeInx, true, true, true);
            if (hiddenEdgeInx == null) {
                return null;
            }
            for (int i = 0; i < hiddenEdgeInx.length; ++i) {
                this.removeEdgeViewInternal(hiddenEdgeInx[i]);
            }
            returnThis = (DNodeView)this.m_nodeViewMap.remove(new Integer(nodeInx));
            this.m_drawPersp.hideNode(nodeInx);
            this.m_structPersp.hideNode(nodeInx);
            this.m_nodeDetails.unregisterNode(~nodeInx);
            this.m_spacial.delete(~nodeInx);
            this.m_selectedNodes.delete(~nodeInx);
            returnThis.m_view = null;
            this.m_contentChanged = true;
        }
        GraphViewChangeListener listener = this.m_lis[0];
        if (listener != null) {
            if (hiddenEdgeInx.length > 0) {
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesHiddenEvent(this, hiddenEdgeInx));
            }
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesHiddenEvent(this, new int[]{returnThis.getRootGraphIndex()}));
        }
        return returnThis;
    }

    public EdgeView removeEdgeView(EdgeView edgeView) {
        return this.removeEdgeView(edgeView.getRootGraphIndex());
    }

    public EdgeView removeEdgeView(Edge edge) {
        return this.removeEdgeView(edge.getRootGraphIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdgeView removeEdgeView(int edgeInx) {
        GraphViewChangeListener listener;
        DEdgeView returnThis;
        Object object = this.m_lock;
        synchronized (object) {
            returnThis = this.removeEdgeViewInternal(edgeInx);
            if (returnThis != null) {
                this.m_contentChanged = true;
            }
        }
        if (returnThis != null && (listener = this.m_lis[0]) != null) {
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesHiddenEvent(this, new int[]{returnThis.getRootGraphIndex()}));
        }
        return returnThis;
    }

    private DEdgeView removeEdgeViewInternal(int edgeInx) {
        DEdgeView returnThis = (DEdgeView)this.m_edgeViewMap.remove(new Integer(edgeInx));
        if (returnThis == null) {
            return returnThis;
        }
        this.m_drawPersp.hideEdge(edgeInx);
        this.m_structPersp.hideEdge(edgeInx);
        this.m_edgeDetails.unregisterEdge(~edgeInx);
        this.m_selectedEdges.delete(~edgeInx);
        returnThis.m_view = null;
        return returnThis;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public void setIdentifier(String id) {
        this.m_identifier = id;
    }

    public double getZoom() {
        return this.m_canvas.m_scaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(double zoom) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_canvas.m_scaleFactor = zoom;
            this.m_viewportChanged = true;
        }
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fitContent() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_spacial.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, this.m_extentsBuff, 0, false).numRemaining() == 0) {
                return;
            }
            this.m_canvas.m_xCenter = ((double)this.m_extentsBuff[0] + (double)this.m_extentsBuff[2]) / 2.0;
            this.m_canvas.m_yCenter = ((double)this.m_extentsBuff[1] + (double)this.m_extentsBuff[3]) / 2.0;
            this.m_canvas.m_scaleFactor = Math.min((double)this.m_canvas.getWidth() / ((double)this.m_extentsBuff[2] - (double)this.m_extentsBuff[0]), (double)this.m_canvas.getHeight() / ((double)this.m_extentsBuff[3] - (double)this.m_extentsBuff[1]));
            this.m_viewportChanged = true;
        }
        this.updateView();
    }

    public void updateView() {
        this.m_canvas.repaint();
    }

    public RootGraph getRootGraph() {
        return this.m_perspective.getRootGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNodeViewsIterator() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_nodeViewMap.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeViewCount() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_nodeViewMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEdgeViewCount() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_edgeViewMap.size();
        }
    }

    public NodeView getNodeView(Node node) {
        return this.getNodeView(node.getRootGraphIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeView getNodeView(int nodeInx) {
        Object object = this.m_lock;
        synchronized (object) {
            return (NodeView)this.m_nodeViewMap.get(new Integer(nodeInx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEdgeViewsList() {
        Object object = this.m_lock;
        synchronized (object) {
            ArrayList returnThis = new ArrayList(this.m_edgeViewMap.size());
            Iterator values = this.m_edgeViewMap.values().iterator();
            while (values.hasNext()) {
                returnThis.add(values.next());
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEdgeViewsList(Node oneNode, Node otherNode) {
        Object object = this.m_lock;
        synchronized (object) {
            List edges = this.m_structPersp.edgesList(oneNode.getRootGraphIndex(), otherNode.getRootGraphIndex(), true);
            if (edges == null) {
                return null;
            }
            ArrayList<EdgeView> returnThis = new ArrayList<EdgeView>();
            Iterator it = edges.iterator();
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                returnThis.add(this.getEdgeView(e));
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEdgeViewsList(int oneNodeInx, int otherNodeInx, boolean includeUndirected) {
        Object object = this.m_lock;
        synchronized (object) {
            List edges = this.m_structPersp.edgesList(oneNodeInx, otherNodeInx, includeUndirected);
            if (edges == null) {
                return null;
            }
            ArrayList<EdgeView> returnThis = new ArrayList<EdgeView>();
            Iterator it = edges.iterator();
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                returnThis.add(this.getEdgeView(e));
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdgeView getEdgeView(int edgeInx) {
        Object object = this.m_lock;
        synchronized (object) {
            return (EdgeView)this.m_edgeViewMap.get(new Integer(edgeInx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getEdgeViewsIterator() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_edgeViewMap.values().iterator();
        }
    }

    public EdgeView getEdgeView(Edge edge) {
        return this.getEdgeView(edge.getRootGraphIndex());
    }

    public int edgeCount() {
        return this.getEdgeViewCount();
    }

    public int nodeCount() {
        return this.getNodeViewCount();
    }

    public boolean hideGraphObject(Object obj) {
        return this.hideGraphObjectInternal(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hideGraphObjectInternal(Object obj, boolean fireListenerEvents) {
        if (obj instanceof DEdgeView) {
            GraphViewChangeListener listener;
            int edgeInx;
            Object object = this.m_lock;
            synchronized (object) {
                edgeInx = ((DEdgeView)obj).getRootGraphIndex();
                if (this.m_drawPersp.hideEdge(edgeInx) == 0) {
                    return false;
                }
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesHiddenEvent(this, new int[]{edgeInx}));
            }
            return true;
        }
        if (obj instanceof DNodeView) {
            GraphViewChangeListener listener;
            int[] edges;
            int nodeInx;
            Object object = this.m_lock;
            synchronized (object) {
                DNodeView nView = (DNodeView)obj;
                nodeInx = nView.getRootGraphIndex();
                edges = this.m_drawPersp.getAdjacentEdgeIndicesArray(nodeInx, true, true, true);
                if (edges == null) {
                    return false;
                }
                for (int i = 0; i < edges.length; ++i) {
                    this.hideGraphObjectInternal(this.m_edgeViewMap.get(new Integer(edges[i])), false);
                }
                this.m_spacial.exists(~nodeInx, this.m_extentsBuff, 0);
                nView.m_hiddenXMin = this.m_extentsBuff[0];
                nView.m_hiddenYMin = this.m_extentsBuff[1];
                nView.m_hiddenXMax = this.m_extentsBuff[2];
                nView.m_hiddenYMax = this.m_extentsBuff[3];
                this.m_drawPersp.hideNode(nodeInx);
                this.m_spacial.delete(~nodeInx);
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                if (edges.length > 0) {
                    listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesHiddenEvent(this, edges));
                }
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesHiddenEvent(this, new int[]{nodeInx}));
            }
            return true;
        }
        return false;
    }

    public boolean showGraphObject(Object obj) {
        return this.showGraphObjectInternal(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showGraphObjectInternal(Object obj, boolean fireListenerEvents) {
        if (obj instanceof DNodeView) {
            GraphViewChangeListener listener;
            int nodeInx;
            Object object = this.m_lock;
            synchronized (object) {
                DNodeView nView = (DNodeView)obj;
                nodeInx = nView.getRootGraphIndex();
                if (this.m_structPersp.getNode(nodeInx) == null) {
                    return false;
                }
                if (this.m_drawPersp.restoreNode(nodeInx) == 0) {
                    return false;
                }
                this.m_spacial.insert(~nodeInx, nView.m_hiddenXMin, nView.m_hiddenYMin, nView.m_hiddenXMax, nView.m_hiddenYMax);
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesRestoredEvent(this, new int[]{nodeInx}));
            }
            return true;
        }
        if (obj instanceof DEdgeView) {
            GraphViewChangeListener listener;
            int sourceNode = 0;
            int targetNode = 0;
            int newEdge = 0;
            Object object = this.m_lock;
            synchronized (object) {
                Edge edge = this.m_structPersp.getEdge(((DEdgeView)obj).getRootGraphIndex());
                if (edge == null) {
                    return false;
                }
                sourceNode = edge.getSource().getRootGraphIndex();
                if (!this.showGraphObjectInternal(this.getNodeView(sourceNode), false)) {
                    sourceNode = 0;
                }
                if (!this.showGraphObjectInternal(this.getNodeView(targetNode = edge.getTarget().getRootGraphIndex()), false)) {
                    targetNode = 0;
                }
                if (this.m_drawPersp.restoreEdge(newEdge = edge.getRootGraphIndex()) == 0) {
                    return false;
                }
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                if (sourceNode != 0) {
                    listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesRestoredEvent(this, new int[]{sourceNode}));
                }
                if (targetNode != 0) {
                    listener.graphViewChanged((GraphViewChangeEvent)new GraphViewNodesRestoredEvent(this, new int[]{targetNode}));
                }
                listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesRestoredEvent(this, new int[]{newEdge}));
            }
            return true;
        }
        return false;
    }

    public boolean hideGraphObjects(List objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.hideGraphObject(it.next());
        }
        return true;
    }

    public boolean showGraphObjects(List objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.showGraphObject(it.next());
        }
        return true;
    }

    public Object[] getContextMethods(String className, boolean plusSuperclass) {
        return null;
    }

    public Object[] getContextMethods(String className, Object[] methods) {
        return null;
    }

    public boolean addContextMethod(String className, String methodClassName, String methodName, Object[] args, ClassLoader loader) {
        return false;
    }

    public void setAllNodePropertyData(int nodeInx, Object[] data) {
    }

    public Object[] getAllNodePropertyData(int nodeInx) {
        return null;
    }

    public void setAllEdgePropertyData(int edgeInx, Object[] data) {
    }

    public Object[] getAllEdgePropertyData(int edgeInx) {
        return null;
    }

    public Object getNodeObjectProperty(int nodeInx, int property) {
        return null;
    }

    public boolean setNodeObjectProperty(int nodeInx, int property, Object value) {
        return false;
    }

    public Object getEdgeObjectProperty(int edgeInx, int property) {
        return null;
    }

    public boolean setEdgeObjectProperty(int edgeInx, int property, Object value) {
        return false;
    }

    public double getNodeDoubleProperty(int nodeInx, int property) {
        return 0.0;
    }

    public boolean setNodeDoubleProperty(int nodeInx, int property, double val) {
        return false;
    }

    public double getEdgeDoubleProperty(int edgeInx, int property) {
        return 0.0;
    }

    public boolean setEdgeDoubleProperty(int edgeInx, int property, double val) {
        return false;
    }

    public float getNodeFloatProperty(int nodeInx, int property) {
        return 0.0f;
    }

    public boolean setNodeFloatProperty(int nodeInx, int property, float value) {
        return false;
    }

    public float getEdgeFloatProperty(int edgeInx, int property) {
        return 0.0f;
    }

    public boolean setEdgeFloatProperty(int edgeInx, int property, float value) {
        return false;
    }

    public boolean getNodeBooleanProperty(int nodeInx, int property) {
        return false;
    }

    public boolean setNodeBooleanProperty(int nodeInx, int property, boolean val) {
        return false;
    }

    public boolean getEdgeBooleanProperty(int edgeInx, int property) {
        return false;
    }

    public boolean setEdgeBooleanProperty(int edgeInx, int property, boolean val) {
        return false;
    }

    public int getNodeIntProperty(int nodeInx, int property) {
        return 0;
    }

    public boolean setNodeIntProperty(int nodeInx, int property, int value) {
        return false;
    }

    public int getEdgeIntProperty(int edgeInx, int property) {
        return 0;
    }

    public boolean setEdgeIntProperty(int edgeInx, int property, int value) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCenter(double x, double y) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_canvas.m_xCenter = x;
            this.m_canvas.m_yCenter = y;
            this.m_viewportChanged = true;
        }
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getCenter() {
        Object object = this.m_lock;
        synchronized (object) {
            return new Point2D.Double(this.m_canvas.m_xCenter, this.m_canvas.m_yCenter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fitSelected() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator selectedElms = this.m_selectedNodes.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            if (selectedElms.numRemaining() == 0) {
                return;
            }
            float xMin = Float.POSITIVE_INFINITY;
            float yMin = Float.POSITIVE_INFINITY;
            float xMax = Float.NEGATIVE_INFINITY;
            float yMax = Float.NEGATIVE_INFINITY;
            while (selectedElms.numRemaining() > 0) {
                int node = selectedElms.nextInt();
                this.m_spacial.exists(node, this.m_extentsBuff, 0);
                xMin = Math.min(xMin, this.m_extentsBuff[0]);
                yMin = Math.min(yMin, this.m_extentsBuff[1]);
                xMax = Math.max(xMax, this.m_extentsBuff[2]);
                yMax = Math.max(yMax, this.m_extentsBuff[3]);
            }
            this.m_canvas.m_xCenter = ((double)xMin + (double)xMax) / 2.0;
            this.m_canvas.m_yCenter = ((double)yMin + (double)yMax) / 2.0;
            this.m_canvas.m_scaleFactor = Math.min((double)this.m_canvas.getWidth() / ((double)xMax - (double)xMin), (double)this.m_canvas.getHeight() / ((double)yMax - (double)yMin));
            this.m_viewportChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphLOD(GraphLOD lod) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_canvas.m_lod = lod;
            this.m_contentChanged = true;
        }
    }

    public GraphLOD getGraphLOD() {
        return this.m_canvas.m_lod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNodesIntersectingRectangle(double xMinimum, double yMinimum, double xMaximum, double yMaximum, boolean treatNodeShapesAsRectangle, IntStack returnVal) {
        Object object = this.m_lock;
        synchronized (object) {
            float xMin = (float)xMinimum;
            float yMin = (float)yMinimum;
            float xMax = (float)xMaximum;
            float yMax = (float)yMaximum;
            SpacialEntry2DEnumerator under = this.m_spacial.queryOverlap(xMin, yMin, xMax, yMax, null, 0, false);
            int totalHits = under.numRemaining();
            if (treatNodeShapesAsRectangle) {
                for (int i = 0; i < totalHits; ++i) {
                    returnVal.push(~under.nextInt());
                }
            } else {
                double x = xMin;
                double y = yMin;
                double w = (double)xMax - (double)xMin;
                double h = (double)yMax - (double)yMin;
                for (int i = 0; i < totalHits; ++i) {
                    int node = under.nextExtents(this.m_extentsBuff, 0);
                    if (this.m_extentsBuff[0] < xMin && this.m_extentsBuff[1] < yMin || this.m_extentsBuff[0] < xMin && this.m_extentsBuff[3] > yMax || this.m_extentsBuff[2] > xMax && this.m_extentsBuff[3] > yMax || this.m_extentsBuff[2] > xMax && this.m_extentsBuff[1] < yMin) {
                        this.m_canvas.m_grafx.getNodeShape(this.m_nodeDetails.shape(node), this.m_extentsBuff[0], this.m_extentsBuff[1], this.m_extentsBuff[2], this.m_extentsBuff[3], this.m_path);
                        if (w > 0.0 && h > 0.0) {
                            if (!this.m_path.intersects(x, y, w, h)) continue;
                            returnVal.push(~node);
                            continue;
                        }
                        if (!this.m_path.contains(x, y)) continue;
                        returnVal.push(~node);
                        continue;
                    }
                    returnVal.push(~node);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExtents(double[] extentsBuff) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_spacial.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, this.m_extentsBuff, 0, false).numRemaining() == 0) {
                return false;
            }
            extentsBuff[0] = this.m_extentsBuff[0];
            extentsBuff[1] = this.m_extentsBuff[1];
            extentsBuff[2] = this.m_extentsBuff[2];
            extentsBuff[3] = this.m_extentsBuff[3];
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xformComponentToNodeCoords(double[] coords) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_canvas.m_grafx.xformImageToNodeCoords(coords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSnapshot(Image img, GraphLOD lod, Paint bgPaint, double xCenter, double yCenter, double scaleFactor) {
        Object object = this.m_lock;
        synchronized (object) {
            GraphRenderer.renderGraph((FixedGraph)((FixedGraph)this.m_drawPersp), (SpacialIndex2D)this.m_spacial, (GraphLOD)lod, (NodeDetails)this.m_nodeDetails, (EdgeDetails)this.m_edgeDetails, (IntHash)this.m_hash, (GraphGraphics)new GraphGraphics(img, false), (Paint)bgPaint, (double)xCenter, (double)yCenter, (double)scaleFactor);
        }
    }

    public void addContentChangeListener(ContentChangeListener l) {
        this.m_cLis[0] = ContentChangeListenerChain.add(this.m_cLis[0], l);
    }

    public void removeContentChangeListener(ContentChangeListener l) {
        this.m_cLis[0] = ContentChangeListenerChain.remove(this.m_cLis[0], l);
    }

    public void addViewportChangeListener(ViewportChangeListener l) {
        this.m_vLis[0] = ViewportChangeListenerChain.add(this.m_vLis[0], l);
    }

    public void removeViewportChangeListener(ViewportChangeListener l) {
        this.m_vLis[0] = ViewportChangeListenerChain.remove(this.m_vLis[0], l);
    }

    public InnerCanvas getCanvas() {
        return this.m_canvas;
    }

    public NodeView getPickedNodeView(Point2D pt) {
        NodeView nv = null;
        double[] locn = new double[]{pt.getX(), pt.getY()};
        int chosenNode = 0;
        this.xformComponentToNodeCoords(locn);
        IntStack nodeStack = new IntStack();
        this.getNodesIntersectingRectangle((float)locn[0], (float)locn[1], (float)locn[0], (float)locn[1], (this.m_canvas.getLastRenderDetail() & 1) == 0, nodeStack);
        int n = chosenNode = nodeStack.size() > 0 ? nodeStack.peek() : 0;
        if (chosenNode != 0) {
            nv = this.getNodeView(chosenNode);
        }
        return nv;
    }

    public void addNodeContextMenuListener(NodeContextMenuListener l) {
        System.out.println("Adding NodeContextListener: " + l);
        this.getCanvas().addNodeContextMenuListener(l);
    }

    public void removeNodeContextMenuListener(NodeContextMenuListener l) {
        this.getCanvas().removeNodeContextMenuListener(l);
    }
}

