/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.render.immed.EdgeAnchors;
import ding.view.DGraphView;
import ding.view.GraphViewEdgesSelectedEvent;
import ding.view.GraphViewEdgesUnselectedEvent;
import giny.model.Edge;
import giny.view.Bend;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import giny.view.Label;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class DEdgeView
implements EdgeView,
Label,
Bend,
EdgeAnchors {
    static final float DEFAULT_ARROW_SIZE = 5.0f;
    static final Paint DEFAULT_ARROW_PAINT = Color.black;
    static final float DEFAULT_EDGE_THICKNESS = 1.0f;
    static final String DEFAULT_LABEL_TEXT = "";
    static final Font DEFAULT_LABEL_FONT = new Font(null, 0, 1);
    static final Paint DEFAULT_LABEL_PAINT = Color.black;
    DGraphView m_view;
    final int m_inx;
    boolean m_selected;
    Paint m_unselectedPaint;
    Paint m_selectedPaint;
    Paint m_sourceUnselectedPaint;
    Paint m_sourceSelectedPaint;
    Paint m_targetUnselectedPaint;
    Paint m_targetSelectedPaint;
    int m_sourceEdgeEnd;
    int m_targetEdgeEnd;
    final ArrayList m_anchors;
    int m_lineType;

    DEdgeView(DGraphView view, int inx) {
        this.m_view = view;
        this.m_inx = ~inx;
        this.m_selected = false;
        this.m_unselectedPaint = this.m_view.m_edgeDetails.segmentPaint(this.m_inx);
        this.m_selectedPaint = Color.red;
        this.m_sourceUnselectedPaint = this.m_view.m_edgeDetails.sourceArrowPaint(this.m_inx);
        this.m_sourceSelectedPaint = DEFAULT_ARROW_PAINT;
        this.m_targetUnselectedPaint = this.m_view.m_edgeDetails.targetArrowPaint(this.m_inx);
        this.m_targetSelectedPaint = DEFAULT_ARROW_PAINT;
        this.m_sourceEdgeEnd = 0;
        this.m_targetEdgeEnd = 0;
        this.m_anchors = new ArrayList();
        this.m_lineType = 2;
    }

    public int getGraphPerspectiveIndex() {
        return ~this.m_inx;
    }

    public int getRootGraphIndex() {
        return ~this.m_inx;
    }

    public Edge getEdge() {
        return this.m_view.getGraphPerspective().getEdge(~this.m_inx);
    }

    public GraphView getGraphView() {
        return this.m_view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeWidth(float width) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideSegmentThickness(this.m_inx, width);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getStrokeWidth() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.segmentThickness(this.m_inx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            Object object = this.m_view.m_lock;
            synchronized (object) {
                BasicStroke bStroke = (BasicStroke)stroke;
                this.m_view.m_edgeDetails.overrideSegmentThickness(this.m_inx, bStroke.getLineWidth());
                float[] dashArr = bStroke.getDashArray();
                if (dashArr != null && dashArr.length > 0) {
                    this.m_view.m_edgeDetails.overrideSegmentDashLength(this.m_inx, dashArr[0]);
                }
                this.m_view.m_contentChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stroke getStroke() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            float segmentThickness = this.m_view.m_edgeDetails.segmentThickness(this.m_inx);
            float segmentDashLength = this.m_view.m_edgeDetails.segmentDashLength(this.m_inx);
            if (segmentDashLength > 0.0f) {
                float[] dashes = new float[]{segmentDashLength, segmentDashLength};
                return new BasicStroke(segmentThickness, 2, 0, 10.0f, dashes, 0.0f);
            }
            return new BasicStroke(segmentThickness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineType(int lineType) {
        if (lineType == 1 || lineType == 2) {
            Object object = this.m_view.m_lock;
            synchronized (object) {
                this.m_lineType = lineType;
                this.m_view.m_contentChanged = true;
            }
        } else {
            throw new IllegalArgumentException("unrecognized line type");
        }
    }

    public int getLineType() {
        return this.m_lineType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnselectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_unselectedPaint = paint;
            if (!this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_unselectedPaint);
                if (this.m_unselectedPaint instanceof Color) {
                    this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
                }
                this.m_view.m_contentChanged = true;
            }
        }
    }

    public Paint getUnselectedPaint() {
        return this.m_unselectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_selectedPaint = paint;
            if (this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_selectedPaint);
                if (this.m_selectedPaint instanceof Color) {
                    this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
                }
                this.m_view.m_contentChanged = true;
            }
        }
    }

    public Paint getSelectedPaint() {
        return this.m_selectedPaint;
    }

    public Paint getSourceEdgeEndPaint() {
        return this.m_sourceUnselectedPaint;
    }

    public Paint getSourceEdgeEndSelectedPaint() {
        return this.m_sourceSelectedPaint;
    }

    public Paint getTargetEdgeEndPaint() {
        return this.m_targetUnselectedPaint;
    }

    public Paint getTargetEdgeEndSelectedPaint() {
        return this.m_targetSelectedPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceEdgeEndSelectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_sourceSelectedPaint = paint;
            if (this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceSelectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetEdgeEndSelectedPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_targetSelectedPaint = paint;
            if (this.isSelected()) {
                this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetSelectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    public void setSourceEdgeEndStrokePaint(Paint paint) {
    }

    public void setTargetEdgeEndStrokePaint(Paint paint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceEdgeEndPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_sourceUnselectedPaint = paint;
            if (!this.isSelected()) {
                this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceUnselectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetEdgeEndPaint(Paint paint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (paint == null) {
                throw new NullPointerException("paint is null");
            }
            this.m_targetUnselectedPaint = paint;
            if (!this.isSelected()) {
                this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetUnselectedPaint);
                this.m_view.m_contentChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.m_view.m_lock;
        synchronized (object) {
            somethingChanged = this.selectInternal();
            if (somethingChanged) {
                this.m_view.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.m_view.m_lis[0]) != null) {
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesSelectedEvent(this.m_view, new int[]{~this.m_inx}));
        }
    }

    boolean selectInternal() {
        if (this.m_selected) {
            return false;
        }
        this.m_selected = true;
        this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_selectedPaint);
        this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceSelectedPaint);
        this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetSelectedPaint);
        if (this.m_selectedPaint instanceof Color) {
            this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_selectedPaint);
        }
        this.m_view.m_selectedEdges.insert(this.m_inx);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselect() {
        GraphViewChangeListener listener;
        boolean somethingChanged;
        Object object = this.m_view.m_lock;
        synchronized (object) {
            somethingChanged = this.unselectInternal();
            if (somethingChanged) {
                this.m_view.m_contentChanged = true;
            }
        }
        if (somethingChanged && (listener = this.m_view.m_lis[0]) != null) {
            listener.graphViewChanged((GraphViewChangeEvent)new GraphViewEdgesUnselectedEvent(this.m_view, new int[]{~this.m_inx}));
        }
    }

    boolean unselectInternal() {
        if (!this.m_selected) {
            return false;
        }
        this.m_selected = false;
        this.m_view.m_edgeDetails.overrideSegmentPaint(this.m_inx, this.m_unselectedPaint);
        this.m_view.m_edgeDetails.overrideSourceArrowPaint(this.m_inx, this.m_sourceUnselectedPaint);
        this.m_view.m_edgeDetails.overrideTargetArrowPaint(this.m_inx, this.m_targetUnselectedPaint);
        if (this.m_unselectedPaint instanceof Color) {
            this.m_view.m_edgeDetails.overrideColorLowDetail(this.m_inx, (Color)this.m_unselectedPaint);
        }
        this.m_view.m_selectedEdges.delete(this.m_inx);
        return true;
    }

    public boolean setSelected(boolean state) {
        if (state) {
            this.select();
        } else {
            this.unselect();
        }
        return true;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public boolean getSelected() {
        return this.m_selected;
    }

    public void updateEdgeView() {
    }

    public void updateTargetArrow() {
    }

    public void updateSourceArrow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceEdgeEnd(int type) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (type == this.m_sourceEdgeEnd) {
                return;
            }
            switch (type) {
                case 0: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-1);
                    break;
                }
                case 1: 
                case 4: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-2);
                    this.setSourceEdgeEndPaint(Color.white);
                    break;
                }
                case 2: 
                case 5: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-2);
                    this.setSourceEdgeEndPaint(Color.black);
                    break;
                }
                case 3: 
                case 6: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-2);
                    this.setSourceEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                case 7: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-3);
                    this.setSourceEdgeEndPaint(Color.white);
                    break;
                }
                case 8: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-3);
                    this.setSourceEdgeEndPaint(Color.black);
                    break;
                }
                case 9: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-3);
                    this.setSourceEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                case 10: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-4);
                    this.setSourceEdgeEndPaint(Color.white);
                    break;
                }
                case 11: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-4);
                    this.setSourceEdgeEndPaint(Color.black);
                    break;
                }
                case 12: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-4);
                    this.setSourceEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                case 13: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-5);
                    this.setSourceEdgeEndPaint(Color.white);
                    break;
                }
                case 14: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-5);
                    this.setSourceEdgeEndPaint(Color.black);
                    break;
                }
                case 15: {
                    this.m_view.m_edgeDetails.overrideSourceArrow(this.m_inx, (byte)-5);
                    this.setSourceEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unrecognized edge end type");
                }
            }
            this.m_sourceEdgeEnd = type;
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetEdgeEnd(int type) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (type == this.m_targetEdgeEnd) {
                return;
            }
            switch (type) {
                case 0: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-1);
                    break;
                }
                case 1: 
                case 4: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-2);
                    this.setTargetEdgeEndPaint(Color.white);
                    break;
                }
                case 2: 
                case 5: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-2);
                    this.setTargetEdgeEndPaint(Color.black);
                    break;
                }
                case 3: 
                case 6: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-2);
                    this.setTargetEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                case 7: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-3);
                    this.setTargetEdgeEndPaint(Color.white);
                    break;
                }
                case 8: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-3);
                    this.setTargetEdgeEndPaint(Color.black);
                    break;
                }
                case 9: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-3);
                    this.setTargetEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                case 10: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-4);
                    this.setTargetEdgeEndPaint(Color.white);
                    break;
                }
                case 11: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-4);
                    this.setTargetEdgeEndPaint(Color.black);
                    break;
                }
                case 12: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-4);
                    this.setTargetEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                case 13: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-5);
                    this.setTargetEdgeEndPaint(Color.white);
                    break;
                }
                case 14: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-5);
                    this.setTargetEdgeEndPaint(Color.black);
                    break;
                }
                case 15: {
                    this.m_view.m_edgeDetails.overrideTargetArrow(this.m_inx, (byte)-5);
                    this.setTargetEdgeEndPaint(this.getUnselectedPaint());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unrecognized edge end type");
                }
            }
            this.m_targetEdgeEnd = type;
            this.m_view.m_contentChanged = true;
        }
    }

    public int getSourceEdgeEnd() {
        return this.m_sourceEdgeEnd;
    }

    public int getTargetEdgeEnd() {
        return this.m_targetEdgeEnd;
    }

    public void updateLine() {
    }

    public void drawSelected() {
        this.select();
    }

    public void drawUnselected() {
        this.unselect();
    }

    public Bend getBend() {
        return this;
    }

    public void clearBends() {
        this.removeAllHandles();
    }

    public Label getLabel() {
        return this;
    }

    public void setToolTip(String tip) {
    }

    public void setPositionHint(int position) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paint getTextPaint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.labelPaint(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextPaint(Paint textPaint) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideLabelPaint(this.m_inx, 0, textPaint);
            this.m_view.m_contentChanged = true;
        }
    }

    public double getGreekThreshold() {
        return 0.0;
    }

    public void setGreekThreshold(double threshold) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.labelText(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideLabelText(this.m_inx, 0, text);
            if (DEFAULT_LABEL_TEXT.equals(this.m_view.m_edgeDetails.labelText(this.m_inx, 0))) {
                this.m_view.m_edgeDetails.overrideLabelCount(this.m_inx, 0);
            } else {
                this.m_view.m_edgeDetails.overrideLabelCount(this.m_inx, 1);
            }
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            return this.m_view.m_edgeDetails.labelFont(this.m_inx, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_view.m_edgeDetails.overrideLabelFont(this.m_inx, 0, font);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandles(List bendPoints) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.removeAllHandles();
            for (int i = 0; i < bendPoints.size(); ++i) {
                Point2D nextPt = (Point2D)bendPoints.get(i);
                this.addHandle(nextPt);
            }
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHandles() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            ArrayList<Point2D.Float> returnThis = new ArrayList<Point2D.Float>();
            for (int i = 0; i < this.m_anchors.size(); ++i) {
                Point2D.Float addThis = new Point2D.Float();
                addThis.setLocation((Point2D)this.m_anchors.get(i));
                returnThis.add(addThis);
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHandle(int inx, Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            Point2D movePt = (Point2D)this.m_anchors.get(inx);
            movePt.setLocation(pt);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getSourceHandlePoint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (this.m_anchors.size() == 0) {
                return null;
            }
            Point2D.Float returnThis = new Point2D.Float();
            returnThis.setLocation((Point2D)this.m_anchors.get(0));
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getTargetHandlePoint() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            if (this.m_anchors.size() == 0) {
                return null;
            }
            Point2D.Float returnThis = new Point2D.Float();
            returnThis.setLocation((Point2D)this.m_anchors.get(this.m_anchors.size() - 1));
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandle(Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            Point2D.Float addThis = new Point2D.Float();
            addThis.setLocation(pt);
            this.m_anchors.add(addThis);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandle(int insertInx, Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            Point2D.Float addThis = new Point2D.Float();
            addThis.setLocation(pt);
            this.m_anchors.add(insertInx, addThis);
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandle(Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            float x = (float)pt.getX();
            float y = (float)pt.getY();
            for (int i = 0; i < this.m_anchors.size(); ++i) {
                Point2D.Float currPt = (Point2D.Float)this.m_anchors.get(i);
                if (x != currPt.x || y != currPt.y) continue;
                this.m_anchors.remove(i);
                this.m_view.m_contentChanged = true;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandle(int inx) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_anchors.remove(inx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHandles() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            this.m_anchors.clear();
            this.m_view.m_contentChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleAlreadyExists(Point2D pt) {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            float x = (float)pt.getX();
            float y = (float)pt.getY();
            for (int i = 0; i < this.m_anchors.size(); ++i) {
                Point2D.Float currPt = (Point2D.Float)this.m_anchors.get(i);
                if (x != currPt.x || y != currPt.y) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D[] getDrawPoints() {
        Object object = this.m_view.m_lock;
        synchronized (object) {
            Point2D[] returnThis = new Point2D[this.m_anchors.size()];
            for (int i = 0; i < returnThis.length; ++i) {
                returnThis[i] = new Point2D.Float();
                returnThis[i].setLocation((Point2D)this.m_anchors.get(i));
            }
            return returnThis;
        }
    }

    public int numAnchors() {
        if (this.m_lineType == 1) {
            return this.m_anchors.size();
        }
        return 2 * this.m_anchors.size();
    }

    public void getAnchor(int anchorIndex, float[] anchorArr, int offset) {
        Point2D.Float anchor = this.m_lineType == 1 ? (Point2D.Float)this.m_anchors.get(anchorIndex) : (Point2D.Float)this.m_anchors.get(anchorIndex / 2);
        anchorArr[offset] = anchor.x;
        anchorArr[offset + 1] = anchor.y;
    }
}

