/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.impl;

import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.actions.DeleteAction;
import cytoscape.editor.event.BasicCytoShapeTransferHandler;
import cytoscape.editor.impl.BasicCytoShapeEntity;
import cytoscape.editor.impl.StringTransferHandler;
import cytoscape.view.CyNetworkView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ShapePalette
extends JPanel {
    static HashMap _shapeMap = new HashMap();
    protected JList dataList;
    protected DefaultListModel listModel;
    protected JScrollPane scrollPane;
    protected JScrollPane helpScrollPane;
    private static final String ICONS_REL_LOC = "images/";
    private JButton deleteButton;
    private JButton undoButton;
    private JButton redoButton;
    private ImageIcon deleteIcon;
    private ImageIcon undoIcon;
    private ImageIcon redoIcon;
    private JPanel _controlPane = new JPanel();
    protected JPanel _shapePane;

    public ShapePalette() {
        this._controlPane.setLayout(new BoxLayout(this._controlPane, 1));
        this.listModel = new DefaultListModel();
        this.dataList = new JList(this.listModel);
        this.dataList.setCellRenderer(new MyCellRenderer());
        this.dataList.setDragEnabled(true);
        this.dataList.setTransferHandler(new PaletteListTransferHandler());
        this.dataList.setFixedCellHeight(37);
        JTextArea instructionsArea = new JTextArea();
        instructionsArea.setLineWrap(true);
        instructionsArea.setWrapStyleWord(true);
        instructionsArea.setText("To add a node to a network, drag and drop a shape from the palette onto the canvas.\n\nTo connect two nodes with an edge, drag and drop the arrow onto a node on the canvas, then move the cursor over a second node and click the mouse.");
        Border blackline = BorderFactory.createLineBorder(Color.black);
        TitledBorder title = BorderFactory.createTitledBorder(blackline, "Cytoscape Editor");
        instructionsArea.setBorder(title);
        instructionsArea.setBackground(Cytoscape.getDesktop().getBackground());
        instructionsArea.setPreferredSize(new Dimension(((JPanel)Cytoscape.getDesktop().getCytoPanel((int)7)).getSize().width - 5, 125));
        this._shapePane = new JPanel();
        this._shapePane.setLayout(new BoxLayout(this._shapePane, 1));
        this.scrollPane = new JScrollPane(this._shapePane);
        this.helpScrollPane = new JScrollPane(instructionsArea);
        this._controlPane.add(this.helpScrollPane);
        this.scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.dataList.setBackground(Cytoscape.getDesktop().getBackground());
        this.scrollPane.setBackground(Cytoscape.getDesktop().getBackground());
        this.scrollPane.setPreferredSize(new Dimension(((JPanel)Cytoscape.getDesktop().getCytoPanel((int)7)).getSize().width - 5, ((JPanel)Cytoscape.getDesktop().getCytoPanel((int)7)).getSize().height - instructionsArea.getPreferredSize().height - 5));
        this._controlPane.add(this.scrollPane);
        CytoscapeEditorManager.setCurrentShapePalette(this);
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        CytoscapeEditorManager.setShapePaletteForView(view, this);
        this.add(this._controlPane);
        this.setBackground(Cytoscape.getDesktop().getBackground());
        this.setVisible(true);
    }

    private JPanel buildEditControlsPanel() {
        JPanel editControlsPanel = new JPanel();
        editControlsPanel.setLayout(new BoxLayout(editControlsPanel, 0));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        TitledBorder title = BorderFactory.createTitledBorder(blackline, "Delete/Undo/Redo");
        editControlsPanel.setBorder(title);
        this.deleteButton = new JButton();
        this.deleteButton.setAction(new DeleteAction());
        this.deleteIcon = new ImageIcon(this.getClass().getResource("images/deleteIcon.gif"));
        this.deleteButton.setIcon(this.deleteIcon);
        this.deleteButton.setToolTipText("Delete Selected Nodes and Edges");
        editControlsPanel.add(this.deleteButton);
        this.undoButton = new JButton();
        this.undoIcon = new ImageIcon(this.getClass().getResource("images/undo.gif"));
        this.undoButton.setIcon(this.undoIcon);
        this.undoButton.setToolTipText("Undo");
        editControlsPanel.add(this.undoButton);
        this.redoButton = new JButton();
        editControlsPanel.add(this.redoButton);
        this.redoIcon = new ImageIcon(this.getClass().getResource("images/redo.gif"));
        this.redoButton.setIcon(this.redoIcon);
        this.redoButton.setToolTipText("redo");
        return editControlsPanel;
    }

    public void addShape(String attributeName, String attributeValue, Icon img, String name) {
        BasicCytoShapeEntity cytoShape = new BasicCytoShapeEntity(attributeName, attributeValue, img, name);
        cytoShape.setTransferHandler(new BasicCytoShapeTransferHandler(cytoShape, null));
        _shapeMap.put(cytoShape.getTitle(), cytoShape);
        this._shapePane.add(cytoShape);
    }

    public void showPalette() {
        int idx = Cytoscape.getDesktop().getCytoPanel(7).indexOfComponent("Editor");
        System.out.println("index of current palette = " + idx);
        if (idx >= 0) {
            Cytoscape.getDesktop().getCytoPanel(7).remove(idx);
            System.out.println("removing palette at Cytopanel indes: " + idx);
        }
        Cytoscape.getDesktop().getCytoPanel(7).add("Editor", (Component)this);
        Cytoscape.getDesktop().getCytoPanel(7).setSelectedIndex(Cytoscape.getDesktop().getCytoPanel(7).indexOfComponent((Component)this));
        System.out.println("Set new selected component on Cytopanel: " + Cytoscape.getDesktop().getCytoPanel(7).getSelectedComponent());
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        CytoscapeEditorManager.setShapePaletteForView(view, this);
        this.setVisible(true);
    }

    public static BasicCytoShapeEntity getBasicCytoShapeEntity(String key) {
        Object val = _shapeMap.get(key);
        if (val instanceof BasicCytoShapeEntity) {
            return (BasicCytoShapeEntity)val;
        }
        return null;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JButton getRedoButton() {
        return this.redoButton;
    }

    public JButton getUndoButton() {
        return this.undoButton;
    }

    class PaletteListTransferHandler
    extends StringTransferHandler {
        private int[] indices = null;
        private int addIndex = -1;
        private int addCount = 0;

        PaletteListTransferHandler() {
        }

        protected void cleanup(JComponent c, boolean remove) {
        }

        protected void importString(JComponent c, String str) {
        }

        protected String exportString(JComponent c) {
            JList list = (JList)c;
            Object val = list.getSelectedValue();
            if (val instanceof BasicCytoShapeEntity) {
                return ((BasicCytoShapeEntity)val).getTitle();
            }
            return null;
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof BasicCytoShapeEntity) {
                BasicCytoShapeEntity cytoShape = (BasicCytoShapeEntity)value;
                this.setText(cytoShape.getTitle());
                this.setIcon(cytoShape.getIcon());
                this.setToolTipText(cytoShape.getToolTipText());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class DragMouseAdapter
    extends MouseAdapter {
        private DragMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            System.out.println("Mouse pressed on: " + c);
            if (c instanceof BasicCytoShapeEntity) {
                BasicCytoShapeTransferHandler handler = (BasicCytoShapeTransferHandler)((BasicCytoShapeEntity)c).getTransferHandler();
                handler.exportString(c);
            }
        }
    }
}

