/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.impl;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.CytoscapeEditorFactory;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.InvalidEditorException;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.util.UndoManager;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;

public class CytoscapeEditorManagerSupport
implements PropertyChangeListener,
ChangeListener,
GraphPerspectiveChangeListener,
FlagEventListener {
    public CytoscapeEditorManagerSupport() {
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener(CytoscapeDesktop.NETWORK_VIEW_FOCUSED, this);
        Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener(CytoscapeDesktop.NETWORK_VIEW_CREATED, this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getDesktop().getVizMapManager().addChangeListener((ChangeListener)this);
    }

    public void stateChanged(ChangeEvent e) {
        boolean newEditor = false;
        if (!CytoscapeEditorManager.isEditingEnabled()) {
            return;
        }
        VisualMappingManager VMM = (VisualMappingManager)e.getSource();
        if (VMM != null) {
            VisualStyle style = VMM.getVisualStyle();
            CytoscapeEditor editorForStyle = CytoscapeEditorManager.getEditorForVisualStyle(style);
            if (editorForStyle == null) {
                String editorType = CytoscapeEditorManager.getEditorTypeForVisualStyleName(style.getName());
                if (editorType == null) {
                    editorType = "DefaultCytoscapeEditor";
                }
                try {
                    editorForStyle = CytoscapeEditorFactory.INSTANCE.getEditor(editorType);
                    CytoscapeEditorManager.setEditorForVisualStyle(style, editorForStyle);
                    System.out.println("built new editor: " + editorForStyle + ", for visual Style = " + style);
                    newEditor = true;
                }
                catch (InvalidEditorException ex) {
                    System.out.println("Error building editor for editor type = " + editorType + ", error = " + ex);
                    ex.printStackTrace();
                }
            }
            if (editorForStyle != null) {
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                CytoscapeEditor editorForView = CytoscapeEditorManager.getEditorForView(Cytoscape.getCurrentNetworkView());
                System.out.println("Got editor for view: " + editorForView);
                if (editorForView == editorForStyle && editorForView == CytoscapeEditorManager.getCurrentEditor()) {
                    return;
                }
                if (editorForView != null && !CytoscapeEditorManager.isSettingUpEditor()) {
                    editorForView.disableControls(null);
                }
                editorForStyle.initializeControls(null);
                CytoscapeEditorManager.setEditorForView(view, editorForStyle);
                CytoscapeEditorManager.setupNewNetworkView(view);
                CytoscapeEditorManager.setCurrentEditor(editorForStyle);
                CytoscapeEditorManager.setEventHandlerForView(view);
            }
        }
    }

    public void onFlagEvent(FlagEvent e) {
        System.out.println("Got flagged object: " + e.getTarget());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals(Cytoscape.NETWORK_CREATED)) {
            String netId = e.getNewValue().toString();
            CyNetwork net = Cytoscape.getNetwork((String)netId);
            net.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
            net.addFlagEventListener((FlagEventListener)this);
            System.out.println("Added graph perspective change listener to: " + net);
        }
        if (!e.getPropertyName().equals(CytoscapeDesktop.NETWORK_VIEW_CREATED) && !e.getPropertyName().equals(Cytoscape.ATTRIBUTES_CHANGED)) {
            if (e.getPropertyName().equals("NETWORK_MODIFIED")) {
                Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
            } else if (e.getPropertyName().equals(CytoscapeDesktop.NETWORK_VIEW_FOCUSED)) {
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                CytoscapeEditor cyEditor = CytoscapeEditorManager.getEditorForView(view);
                UndoManager undo = CytoscapeDesktop.undo;
                ShapePalette palette = CytoscapeEditorManager.getShapePaletteForView(view);
                if (palette != null) {
                    // empty if block
                }
                if (cyEditor == null) {
                    cyEditor = CytoscapeEditorManager.getCurrentEditor();
                    if (cyEditor == null) {
                        return;
                    }
                    CytoscapeEditorManager.setupNewNetworkView(view);
                }
            }
        }
    }

    public void setupUndoableAdditionEdit(CyNetwork net, CyNode node, CyEdge edge) {
        final boolean isNode = node != null;
        final int[] nodes = new int[1];
        final int[] edges = new int[1];
        final CyNetwork cyNet = net;
        if (node != null) {
            int nodeIdx;
            nodes[0] = nodeIdx = node.getRootGraphIndex();
        }
        if (edge != null) {
            int edgeIdx;
            edges[0] = edgeIdx = edge.getRootGraphIndex();
        }
        CytoscapeEditorManager.getNodeClipBoard().elements(nodes);
        CytoscapeEditorManager.getEdgeClipBoard().elements(edges);
        CytoscapeEditorManager.setNetworkClipBoard(cyNet.getIdentifier());
        System.out.println("Adding an ADD edit to " + cyNet);
        CytoscapeEditorManager.addEdit(new AbstractUndoableEdit(){
            final String network_id;
            {
                this.network_id = cyNet.getIdentifier();
            }

            public String getPresentationName() {
                return "Add";
            }

            public String getRedoPresentationName() {
                if (isNode) {
                    return "Redo: Added Node";
                }
                return "Redo: Added Edge";
            }

            public String getUndoPresentationName() {
                if (isNode) {
                    return "Undo: Added Node";
                }
                return "Undo: Added Edge";
            }

            public void undo() {
                System.out.println("Trying to UNDO add on: " + Cytoscape.getNetwork((String)this.network_id));
                super.undo();
                CyNetwork network = Cytoscape.getNetwork((String)this.network_id);
                if (network != null) {
                    network.hideEdges(edges);
                    network.hideNodes(nodes);
                    CytoscapeEditorManager.getNodeClipBoard().elements(nodes);
                    CytoscapeEditorManager.getEdgeClipBoard().elements(edges);
                }
            }

            public void redo() {
                super.redo();
                CyNetwork network = Cytoscape.getNetwork((String)this.network_id);
                if (network != null) {
                    network.restoreNodes(nodes);
                    network.restoreEdges(edges);
                }
            }
        });
    }

    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent event) {
        int i;
        CyNetwork net = Cytoscape.getCurrentNetwork();
        boolean nodeChanges = false;
        boolean edgeChanges = false;
        if (event.isNodesHiddenType()) {
            int[] hiddenNodes = event.getHiddenNodeIndices();
            for (i = 0; i < hiddenNodes.length; ++i) {
                CytoscapeEditorManager.addHiddenNodeForNetwork(net, hiddenNodes[i]);
            }
            if (hiddenNodes != null) {
                nodeChanges = true;
            }
        }
        if (event.isEdgesHiddenType()) {
            int[] hiddenEdges = event.getHiddenEdgeIndices();
            if (hiddenEdges != null) {
                edgeChanges = true;
            }
            for (i = 0; i < hiddenEdges.length; ++i) {
                CytoscapeEditorManager.addHiddenEdgeForNetwork(net, hiddenEdges[i]);
            }
        }
        if (nodeChanges || edgeChanges) {
            Cytoscape.firePropertyChange((String)"NETWORK_MODIFIED", null, (Object)Cytoscape.getCurrentNetwork());
        }
    }
}

