/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.impl;

import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.CytoscapeEditorFactory;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.InvalidEditorException;
import cytoscape.editor.event.NetworkEditEventAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CytoscapeEditorFactoryImpl
implements CytoscapeEditorFactory {
    private Collection editorTypes = new ArrayList();
    private HashMap editors = new HashMap();

    public CytoscapeEditor getEditor(String editorType, List args) throws InvalidEditorException {
        CytoscapeEditor cyEditor = null;
        Object cyEditObj = this.editors.get(editorType);
        if (cyEditObj != null) {
            cyEditor = (CytoscapeEditor)cyEditObj;
            return cyEditor;
        }
        try {
            Class<?> editorClass = Class.forName("cytoscape.editor.editors." + editorType);
            this.editorTypes.add(editorType);
            cyEditor = (CytoscapeEditor)editorClass.newInstance();
            this.editors.put(editorType, cyEditor);
            cyEditor.setEditorName(editorType);
        }
        catch (ClassNotFoundException e) {
            String msg = "Cannot create editor of type: " + editorType;
            InvalidEditorException ex = new InvalidEditorException(msg, new Throwable("type not found"));
            ex.printStackTrace();
            throw ex;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        CytoscapeEditorManager.setCurrentEditor(cyEditor);
        return cyEditor;
    }

    public CytoscapeEditor getEditor(String editorType) throws InvalidEditorException {
        return this.getEditor(editorType, null);
    }

    public Collection getEditorTypes() {
        return this.editorTypes;
    }

    public void addEditorType(String editorType) {
        this.editorTypes.add(editorType);
    }

    public NetworkEditEventAdapter getNetworkEditEventAdapter(CytoscapeEditor editor) {
        NetworkEditEventAdapter event = null;
        String editorType = editor.getEditorName();
        String adapterName = CytoscapeEditorManager.getNetworkEditEventAdapterType(editorType);
        try {
            Class<?> eventAdapterClass = Class.forName(adapterName);
            event = (NetworkEditEventAdapter)eventAdapterClass.newInstance();
            event.set_caller(editor);
        }
        catch (ClassNotFoundException ex) {
            String msg = "Cannot create NetworkEditEvent handler of type: " + adapterName;
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return event;
    }
}

