/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.impl;

import cytoscape.visual.Arrow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;

public class CytoShapeIcon
implements Icon {
    private Color _color;
    private Image _image = null;
    private byte _shape;
    private Arrow _arrowType = null;
    public static final int WIDTH = 32;
    public static final int HEIGHT = 32;

    public CytoShapeIcon(byte shape, Color color) {
        this._color = color;
        this._shape = shape;
        this._image = null;
        this._arrowType = null;
    }

    public CytoShapeIcon(Image img) {
        this._image = img;
        this._arrowType = null;
    }

    public CytoShapeIcon(Arrow arrowType) {
        this._arrowType = arrowType;
    }

    public int getIconHeight() {
        return 32;
    }

    public int getIconWidth() {
        return 32;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        if (this._image != null) {
            g.drawImage(this._image, x, y, c);
            return;
        }
        if (this._arrowType != null) {
            g.setColor(Color.BLACK);
            if (this._arrowType == Arrow.BLACK_DELTA) {
                g.fillPolygon(new int[]{x, x + 3 * width / 4, x + 3 * width / 4, x + width, x + 3 * width / 4, x + 3 * width / 4, x}, new int[]{y + 7 * height / 16, y + 7 * height / 16, y + 5 * height / 16, y + height / 2, y + 11 * height / 16, y + 9 * height / 16, y + 9 * height / 16}, 7);
            } else if (this._arrowType == Arrow.COLOR_DELTA) {
                g.setColor(Color.BLUE);
                g.fillPolygon(new int[]{x, x + 3 * width / 4, x + 3 * width / 4, x + width, x + 3 * width / 4, x + 3 * width / 4, x}, new int[]{y + 7 * height / 16, y + 7 * height / 16, y + 5 * height / 16, y + height / 2, y + 11 * height / 16, y + 9 * height / 16, y + 9 * height / 16}, 7);
            } else if (this._arrowType == Arrow.BLACK_CIRCLE) {
                g.fillRect(x, y + 7 * height / 16, 13 * (width / 16), height / 8);
                g.fillOval(x + 5 * width / 8, y + 5 * height / 16, 6 * width / 16, 6 * height / 16);
            } else if (this._arrowType == Arrow.BLACK_T) {
                g.fillRect(x, y + 7 * height / 16, 15 * (width / 16), height / 8);
                g.fillRect(x + 15 * (width / 16), y + 5 * height / 16, width / 16, height * 6 / 16);
            } else if (this._arrowType == Arrow.NONE) {
                g.fillRect(x, y + 7 * height / 16, 15 * (width / 16), height / 8);
            }
            return;
        }
        g.setColor(this._color);
        if (this._shape == 5) {
            g.fillPolygon(new int[]{x, x + width / 2, x + width}, new int[]{y + height, y, y + height}, 3);
            g.setColor(Color.BLACK);
            g.drawPolygon(new int[]{x, x + width / 2, x + width}, new int[]{y + height, y, y + height}, 3);
        } else if (this._shape == 1) {
            g.fillRoundRect(x, y, width, height, width / 2, height / 2);
            g.setColor(Color.BLACK);
            g.drawRoundRect(x, y, width, height, width / 2, height / 2);
        } else if (this._shape == 7) {
            g.fillPolygon(new int[]{x, x + width / 2, x + width, x + width / 2}, new int[]{y + height / 2, y, y + height / 2, y + height}, 4);
            g.setColor(Color.BLACK);
            g.drawPolygon(new int[]{x, x + width / 2, x + width, x + width / 2}, new int[]{y + height / 2, y, y + height / 2, y + height}, 4);
        } else if (this._shape == 8) {
            g.fillOval(x, y, width, height);
            g.setColor(Color.BLACK);
            g.drawOval(x, y, width, height);
        } else if (this._shape == 9) {
            g.fillPolygon(new int[]{x, x + width / 4, x + 3 * width / 4, x + width, x + 3 * width / 4, x + width / 4}, new int[]{y + height / 2, y, y, y + height / 2, y + height, y + height}, 6);
            g.setColor(Color.BLACK);
            g.drawPolygon(new int[]{x, x + width / 4, x + 3 * width / 4, x + width, x + 3 * width / 4, x + width / 4}, new int[]{y + height / 2, y, y, y + height / 2, y + height, y + height}, 6);
        } else if (this._shape == 10) {
            g.fillPolygon(new int[]{x, x + width / 4, x + 3 * width / 4, x + width, x + width, x + 3 * width / 4, x + width / 4, x}, new int[]{y + height / 4, y, y, y + height / 4, y + 3 * (height / 4), y + height, y + height, y + 3 * (height / 4)}, 8);
            g.setColor(Color.BLACK);
            g.drawPolygon(new int[]{x, x + width / 4, x + 3 * width / 4, x + width, x + width, x + 3 * width / 4, x + width / 4, x}, new int[]{y + height / 4, y, y, y + height / 4, y + 3 * (height / 4), y + height, y + height, y + 3 * (height / 4)}, 8);
        } else if (this._shape == 6) {
            g.fillPolygon(new int[]{x, x + 3 * width / 4, x + width, x + width / 4}, new int[]{y, y, y + height, y + height}, 4);
            g.setColor(Color.BLACK);
            g.drawPolygon(new int[]{x, x + 3 * width / 4, x + width, x + width / 4}, new int[]{y, y, y + height, y + height}, 4);
        } else if (this._shape == 0) {
            g.fillRect(x, y, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y, width, height);
        }
    }
}

