/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.event;

import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.event.BasicNetworkEditEventHandler;
import cytoscape.editor.impl.BasicCytoShapeEntity;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Iterator;
import phoebe.PhoebeCanvasDropEvent;

public class PaletteNetworkEditEventHandler
extends BasicNetworkEditEventHandler {
    BasicNetworkEditEventHandler editEvent;
    public static final String NODE_TYPE = "NODE_TYPE";

    public PaletteNetworkEditEventHandler() {
    }

    public PaletteNetworkEditEventHandler(CytoscapeEditor caller) {
        super(caller);
    }

    public PaletteNetworkEditEventHandler(CytoscapeEditor caller, CyNetworkView view) {
        super(caller, view);
    }

    public void itemDropped(PhoebeCanvasDropEvent e) {
        Object shape = null;
        String shapeName = null;
        Point location = e.getLocation();
        Transferable t = e.getTransferable();
        BasicCytoShapeEntity myShape = null;
        DataFlavor[] dfl = t.getTransferDataFlavors();
        for (int i = 0; i < dfl.length; ++i) {
            DataFlavor d = dfl[i];
            if (d.isMimeTypeEqual("application/x-java-url")) {
                this.handleDroppedURL(t, d, location);
                continue;
            }
            if (!t.isDataFlavorSupported(dfl[i])) continue;
            try {
                shape = t.getTransferData(dfl[i]);
                continue;
            }
            catch (UnsupportedFlavorException exc) {
                exc.printStackTrace();
                return;
            }
            catch (IOException exc) {
                exc.printStackTrace();
                return;
            }
        }
        if (shape != null) {
            shapeName = shape.toString();
            myShape = ShapePalette.getBasicCytoShapeEntity(shapeName);
        }
        Object[] args = null;
        if (myShape != null) {
            String attributeName = myShape.getAttributeName();
            String attributeValue = myShape.getAttributeValue();
            System.out.println("Item dropped of type: " + attributeName);
            args = new Object[]{"LOCATION", location};
            if (attributeName.equals(NODE_TYPE)) {
                this.setNodeAttributeName(attributeName);
                this.setNodeAttributeValue(attributeValue);
                CyNode cn = this._caller.addNode("node" + counter, attributeName, attributeValue);
                ++counter;
                double zoom = Cytoscape.getCurrentNetworkView().getZoom();
                Cytoscape.getCurrentNetwork().restoreNode((Node)cn);
                NodeView nv = Cytoscape.getCurrentNetworkView().getNodeView((Node)cn);
                nv.setOffset((double)location.x, (double)location.y);
                DGraphView dview = (DGraphView)Cytoscape.getCurrentNetworkView();
                double[] locn = new double[]{location.getX(), location.getY()};
                dview.xformComponentToNodeCoords(locn);
                nv.setOffset(locn[0], locn[1]);
                System.out.println("Offset set to: " + locn[0] + "," + locn[1]);
            } else if (attributeName.equals("EDGE_TYPE")) {
                this.setEdgeAttributeName(attributeName);
                this.setEdgeAttributeValue(attributeValue);
                this.handleDroppedEdge(attributeValue, e);
            }
        }
    }

    public void handleDroppedEdge(String attributeValue, PhoebeCanvasDropEvent e) {
        Point location = e.getLocation();
        Point2D locn = (Point2D)location.clone();
        this.editEvent = this;
        if (this.edgeStarted) {
            return;
        }
        NodeView targetNode = this.findEdgeDropTarget(locn);
        System.out.println("drop target = " + targetNode);
        if (targetNode == null) {
            return;
        }
        this.nextPoint = e.getLocation();
        boolean onNode = true;
        if (onNode && !this.edgeStarted) {
            this.setHandlingEdgeDrop(true);
            this.edgeStarted = true;
            this.setEdgeStarted(true);
            this.setNode(targetNode);
            this.edge = new PPath();
            this.edge.setStroke((Stroke)new PFixedWidthStroke(3.0f));
            this.edge.setPaint((Paint)Color.black);
            this.startPoint = this.nextPoint;
            this.updateEdge();
            this.setEdge(this.edge);
            this.setStartPoint(this.startPoint);
        }
    }

    public NodeView findEdgeDropTarget(Point2D location) {
        double[] locn = new double[]{location.getX(), location.getY()};
        boolean chosenNode = false;
        this.getView().xformComponentToNodeCoords(locn);
        double locnX = locn[0];
        double locnY = locn[1];
        Iterator it = Cytoscape.getCurrentNetworkView().getNodeViewsIterator();
        while (it.hasNext()) {
            NodeView nv = (NodeView)it.next();
            if (!(locnX >= nv.getXPosition() - nv.getWidth()) || !(locnX <= nv.getXPosition() + nv.getWidth()) || !(locnY >= nv.getYPosition() - nv.getHeight()) || !(locnY <= nv.getYPosition() + nv.getHeight())) continue;
            return nv;
        }
        return null;
    }

    public void handleDroppedURL(Transferable t, DataFlavor d, Point location) {
        try {
            Object URL2 = t.getTransferData(d);
            if (URL2 != null) {
                String URLString = URL2.toString();
                System.out.println("Handling dropped URL = " + URLString);
                CyNode cn = this._caller.addNode("node" + counter, "URL");
                ++counter;
                double zoom = Cytoscape.getCurrentNetworkView().getZoom();
                Cytoscape.getCurrentNetwork().restoreNode((Node)cn);
                NodeView nv = Cytoscape.getCurrentNetworkView().getNodeView((Node)cn);
            }
        }
        catch (UnsupportedFlavorException exc) {
            exc.printStackTrace();
            return;
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return;
        }
    }
}

