/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.event;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.event.PaletteNetworkEditEventHandler;
import cytoscape.editor.impl.BasicCytoShapeEntity;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import edu.umd.cs.piccolo.event.PInputEvent;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.io.IOException;
import phoebe.PhoebeCanvasDropEvent;

public class BioPAXNetworkEditEventHandler
extends PaletteNetworkEditEventHandler {
    public static CyAttributes nodeAttribs = Cytoscape.getNodeAttributes();
    public static CyAttributes edgeAttribs = Cytoscape.getEdgeAttributes();

    public BioPAXNetworkEditEventHandler() {
    }

    public BioPAXNetworkEditEventHandler(CytoscapeEditor caller) {
        super(caller);
    }

    public BioPAXNetworkEditEventHandler(CytoscapeEditor caller, CyNetworkView view) {
        super(caller, view);
    }

    public CyNode createNode(Point2D location) {
        CyNode cn = super.createNode(location);
        CyNetwork net = Cytoscape.getCurrentNetwork();
        nodeAttribs.setAttribute(cn.getIdentifier(), "BIOPAX_NAME", cn.getIdentifier());
        return cn;
    }

    public CyEdge finishEdge(PInputEvent e) {
        System.out.println("Finishing edge in BioPAX network event handler");
        this.edgeStarted = false;
        this.updateEdge();
        NodeView target = (NodeView)e.getPickedNode();
        NodeView source = this.node;
        Node source_node = source.getNode();
        Node target_node = target.getNode();
        CyEdge myEdge = this._caller.addEdge(source_node, target_node, "interaction", "default", true, this.getEdgeAttributeValue());
        System.out.println("setting BIOPAX_EDGE_TYPE for " + myEdge.getIdentifier() + " to " + this.getEdgeAttributeValue());
        edgeAttribs.setAttribute(myEdge.getIdentifier(), "BIOPAX_EDGE_TYPE", this.getEdgeAttributeValue());
        this.edge = null;
        this.node = null;
        if (this.isHandlingEdgeDrop()) {
            this.setHandlingEdgeDrop(false);
        }
        target.setSelected(!target.isSelected());
        if (Cytoscape.getCurrentNetwork().getNodeCount() <= 100) {
            Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
        }
        return myEdge;
    }

    public void itemDropped(PhoebeCanvasDropEvent e) {
        DGraphView thisView = this.getView();
        if (thisView != (DGraphView)Cytoscape.getCurrentNetworkView()) {
            return;
        }
        Object shape = null;
        String shapeName = null;
        Point location = e.getLocation();
        System.out.println("Item dropped at: " + e.getLocation());
        System.out.println("Bounds of current view are: " + Cytoscape.getCurrentNetworkView().getComponent().getBounds());
        Point2D locn = (Point2D)location.clone();
        Transferable t = e.getTransferable();
        BasicCytoShapeEntity myShape = null;
        DataFlavor[] dfl = t.getTransferDataFlavors();
        for (int i = 0; i < dfl.length; ++i) {
            DataFlavor d = dfl[i];
            if (d.isMimeTypeEqual("application/x-java-url")) {
                this.handleDroppedURL(t, d, location);
                continue;
            }
            if (!t.isDataFlavorSupported(dfl[i])) continue;
            try {
                shape = t.getTransferData(dfl[i]);
                continue;
            }
            catch (UnsupportedFlavorException exc) {
                exc.printStackTrace();
                return;
            }
            catch (IOException exc) {
                exc.printStackTrace();
                return;
            }
        }
        if (shape != null) {
            shapeName = shape.toString();
            myShape = ShapePalette.getBasicCytoShapeEntity(shapeName);
        }
        Object[] args = null;
        if (myShape != null) {
            String attributeName = myShape.getAttributeName();
            String attributeValue = myShape.getAttributeValue();
            args = new Object[]{"LOCATION", location};
            if (attributeName.equals("NODE_TYPE")) {
                this.setNodeAttributeName(attributeName);
                this.setNodeAttributeValue(attributeValue);
                CyNode cn = this._caller.addNode("node" + counter, attributeName, attributeValue);
                ++counter;
                double zoom = Cytoscape.getCurrentNetworkView().getZoom();
                Cytoscape.getCurrentNetwork().restoreNode((Node)cn);
                NodeView nv = Cytoscape.getCurrentNetworkView().getNodeView((Node)cn);
                nv.setOffset(locn.getX(), locn.getY());
                nodeAttribs.setAttribute(cn.getIdentifier(), "BIOPAX_NAME", cn.getIdentifier());
            } else if (attributeName.equals("EDGE_TYPE") || attributeName.equals("BIOPAX_EDGE_TYPE")) {
                this.setEdgeAttributeName(attributeName);
                this.setEdgeAttributeValue(attributeValue);
                this.handleDroppedEdge(attributeValue, e);
            }
        }
    }
}

