/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.event;

import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.attr.MultiHashMapListener;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.event.NetworkEditEventAdapter;
import cytoscape.util.intr.IntStack;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import ding.view.DNodeView;
import ding.view.InnerCanvas;
import edu.umd.cs.piccolo.nodes.PPath;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class BasicNetworkEditEventHandler
extends NetworkEditEventAdapter
implements ActionListener,
MultiHashMapListener {
    protected NodeView node;
    protected PPath edge;
    protected boolean edgeStarted;
    protected Point2D startPoint;
    protected Point2D nextPoint;
    protected InnerCanvas canvas;
    protected DGraphView view;
    protected static int counter = 0;
    public final int ADD_MODE = 1;
    public final int CONNECT_MODE = 2;
    public final int LABEL_MODE = 3;
    public final int SELECT_MODE = 0;
    public int mode = 0;
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String EDGE_TYPE = "EDGE_TYPE";
    public static final String DEFAULT_NODE = "DefaultNode";
    public static final String DEFAULT_EDGE = "DefaultEdge";
    protected String nodeAttributeName = "NODE_TYPE";
    protected String nodeAttributeValue = "DefaultNode";
    protected String edgeAttributeName = "EDGE_TYPE";
    protected String edgeAttributeValue = "DefaultEdge";
    CyNode _nodeBeingLabeled = null;
    NodeView _nodeViewBeingLabeled = null;
    JPanel _nodeLabelerPanel;
    CytoscapeEditor _caller;
    double saveX1 = Double.MIN_VALUE;
    double saveY1 = Double.MIN_VALUE;
    double saveX2 = Double.MIN_VALUE;
    double saveY2 = Double.MIN_VALUE;
    public boolean handlingEdgeDrop = false;

    public BasicNetworkEditEventHandler() {
        this._nodeLabelerPanel = new JPanel();
    }

    public BasicNetworkEditEventHandler(CytoscapeEditor caller) {
        this();
        this._caller = caller;
    }

    public BasicNetworkEditEventHandler(CytoscapeEditor caller, CyNetworkView view) {
        this();
        this._caller = caller;
        this.setView((DGraphView)view);
    }

    public InnerCanvas getCanvas() {
        return this.canvas;
    }

    public void mousePressed(MouseEvent e) {
        this.nextPoint = e.getPoint();
        NodeView nv = null;
        System.out.println("Mouse pressed at viewport coordinate: " + this.nextPoint);
        boolean onNode = false;
        nv = this.getPickedNodeView(this.nextPoint);
        System.out.println("Picked NodeView = " + nv);
        System.out.println("Edge started = " + this.edgeStarted);
        System.out.println("node = " + this.node);
        if (nv != null) {
            onNode = true;
        }
        if (onNode && !this.edgeStarted && e.isControlDown()) {
            this.beginEdge(this.nextPoint, nv);
        } else if (onNode && this.edgeStarted && nv != this.node) {
            System.out.println("calling finishEdge for NodeView " + nv);
            this.finishEdge(this.nextPoint, nv);
            this.edgeStarted = false;
            onNode = false;
        } else if (!onNode && this.edgeStarted) {
            this.edgeStarted = false;
            this.saveX1 = Double.MIN_VALUE;
            this.saveX2 = Double.MIN_VALUE;
            this.saveY1 = Double.MIN_VALUE;
            this.saveY2 = Double.MIN_VALUE;
            this.setHandlingEdgeDrop(false);
        } else if (!onNode && !this.edgeStarted && e.isControlDown()) {
            this.createNode(this.nextPoint);
        }
    }

    public NodeView getPickedNodeView(Point2D pt) {
        NodeView nv = null;
        double[] locn = new double[]{pt.getX(), pt.getY()};
        int chosenNode = 0;
        this.getView().xformComponentToNodeCoords(locn);
        IntStack nodeStack = new IntStack();
        this.getView().getNodesIntersectingRectangle((float)locn[0], (float)locn[1], (float)locn[0], (float)locn[1], (this.canvas.getLastRenderDetail() & 1) == 0, nodeStack);
        int n = chosenNode = nodeStack.size() > 0 ? nodeStack.peek() : 0;
        if (chosenNode != 0) {
            nv = this.getView().getNodeView(chosenNode);
        }
        return nv;
    }

    public void beginEdge(Point2D location, NodeView nv) {
        this.edgeStarted = true;
        this.node = nv;
        this.startPoint = location;
        this.updateEdge();
        this.setEdgeStarted(true);
        this.setStartPoint(this.startPoint);
    }

    public CyEdge finishEdge(Point2D location, NodeView target) {
        this.edgeStarted = false;
        this.updateEdge();
        this.saveX1 = Double.MIN_VALUE;
        this.saveX2 = Double.MIN_VALUE;
        this.saveY1 = Double.MIN_VALUE;
        this.saveY2 = Double.MIN_VALUE;
        NodeView source = this.node;
        Node source_node = source.getNode();
        Node target_node = target.getNode();
        CyEdge myEdge = this._caller.addEdge(source_node, target_node, "interaction", "default", true, this.getEdgeAttributeValue() != null ? this.getEdgeAttributeValue() : DEFAULT_EDGE);
        this.edge = null;
        this.node = null;
        if (this.isHandlingEdgeDrop()) {
            this.setHandlingEdgeDrop(false);
        }
        target.setSelected(!target.isSelected());
        this.getCanvas().repaint();
        if (Cytoscape.getCurrentNetwork().getNodeCount() <= 500) {
            Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
        }
        return myEdge;
    }

    public CyNode createNode(Point2D location) {
        CyNode cn = null;
        cn = this._caller.addNode("node" + counter, this.getNodeAttributeName(), this.getNodeAttributeValue());
        ++counter;
        double zoom = Cytoscape.getCurrentNetworkView().getZoom();
        NodeView nv = Cytoscape.getCurrentNetworkView().getNodeView((Node)cn);
        double[] nextLocn = new double[]{this.nextPoint.getX(), this.nextPoint.getY()};
        this.view.xformComponentToNodeCoords(nextLocn);
        nv.setOffset(nextLocn[0], nextLocn[1]);
        nv.setToolTip(cn.getIdentifier());
        ((DNodeView)nv).setToolTip(cn.getIdentifier());
        System.out.println("Setting tooltip text on nodeView: " + nv);
        System.out.println("   to: " + ((DNodeView)nv).getToolTip());
        return cn;
    }

    public void mouseMoved(MouseEvent e) {
        this.nextPoint = e.getPoint();
        if (this.edgeStarted) {
            this.updateEdge();
        }
    }

    public void mouseEntered(MouseEvent e) {
        Point location = e.getPoint();
        NodeView nv = this.getPickedNodeView(location);
        if (nv != null) {
            if (this.edgeStarted) {
                nv.setSelected(!nv.isSelected());
            }
            this.getCanvas().repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        Point location = e.getPoint();
        NodeView nv = this.getPickedNodeView(location);
        if (nv != null) {
            if (this.edgeStarted) {
                nv.setSelected(!nv.isSelected());
            }
            this.getCanvas().repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.nextPoint = e.getPoint();
        boolean onNode = false;
        Point location = e.getPoint();
        NodeView nv = this.getPickedNodeView(location);
        if (nv != null) {
            onNode = true;
        }
        if (onNode && !this.edgeStarted && e.isControlDown()) {
            this.beginEdge(this.nextPoint, nv);
        }
        if (!this.edgeStarted) {
            // empty if block
        }
        if (this.edgeStarted) {
            this.updateEdge();
        }
    }

    public void updateEdge() {
        double x1 = this.startPoint.getX();
        double y1 = this.startPoint.getY();
        double x2 = this.nextPoint.getX();
        double y2 = this.nextPoint.getY();
        double lineLen = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double offset = 5.0;
        if (lineLen == 0.0) {
            lineLen = 1.0;
        }
        y2 += (y1 - y2) / lineLen * offset;
        x2 += (x1 - x2) / lineLen * offset;
        this.nextPoint.setLocation(x2, y2);
        Color saveColor = this.canvas.getGraphics().getColor();
        if (this.saveX1 != Double.MIN_VALUE) {
            this.canvas.getGraphics().setColor(this.canvas.getBackground());
            this.canvas.getGraphics().drawLine((int)this.saveX1 - 1, (int)this.saveY1 - 1, (int)this.saveX2 + 1, (int)this.saveY2 + 1);
        }
        this.canvas.update(this.canvas.getGraphics());
        this.canvas.getGraphics().setColor(Color.BLACK);
        this.canvas.getGraphics().drawLine((int)x1 - 1, (int)y1 - 1, (int)x2 + 1, (int)y2 + 1);
        this.canvas.getGraphics().setColor(saveColor);
        this.saveX1 = x1;
        this.saveX2 = x2;
        this.saveY1 = y1;
        this.saveY2 = y2;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void attributeValueAssigned(String objectKey, String attributeName, Object[] keyIntoValue, Object oldAttributeValue, Object newAttributeValue) {
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        if (view != null) {
            // empty if block
        }
    }

    public void attributeValueRemoved(String objectKey, String attributeName, Object[] keyIntoValue, Object attributeValue) {
    }

    public void allAttributeValuesRemoved(String objectKey, String attributeName) {
    }

    public PPath getEdge() {
        return this.edge;
    }

    public void setEdge(PPath edge) {
        this.edge = edge;
    }

    public boolean isEdgeStarted() {
        return this.edgeStarted;
    }

    public void setEdgeStarted(boolean edgeStarted) {
        this.edgeStarted = edgeStarted;
    }

    public Point2D getNextPoint() {
        return this.nextPoint;
    }

    public void setNextPoint(Point2D nextPoint) {
        this.nextPoint = nextPoint;
    }

    public NodeView getNode() {
        return this.node;
    }

    public void setNode(NodeView node) {
        this.node = node;
    }

    public Point2D getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Point2D startPoint) {
        this.startPoint = startPoint;
    }

    public DGraphView getView() {
        return this.view;
    }

    public void setView(DGraphView view) {
        this.view = view;
    }

    public boolean isHandlingEdgeDrop() {
        return this.handlingEdgeDrop;
    }

    public void setHandlingEdgeDrop(boolean handlingEdgeDrop) {
        this.handlingEdgeDrop = handlingEdgeDrop;
    }

    public void start(DGraphView view) {
        this.view = view;
        this.canvas = view.getCanvas();
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
    }

    public void stop() {
        if (this.canvas != null) {
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            this.view = null;
            this.canvas = null;
        }
    }

    public String getEdgeAttributeValue() {
        return this.edgeAttributeValue;
    }

    public void setEdgeAttributeValue(String edgeAttributeValue) {
        this.edgeAttributeValue = edgeAttributeValue;
    }

    public String getNodeAttributeName() {
        return this.nodeAttributeName;
    }

    public void setNodeAttributeName(String nodeAttributeName) {
        this.nodeAttributeName = nodeAttributeName;
    }

    public String getEdgeAttributeName() {
        return this.edgeAttributeName;
    }

    public void setEdgeAttributeName(String edgeAttributeName) {
        this.edgeAttributeName = edgeAttributeName;
    }

    public String getNodeAttributeValue() {
        return this.nodeAttributeValue;
    }

    public void setNodeAttributeValue(String nodeAttributeValue) {
        this.nodeAttributeValue = nodeAttributeValue;
    }

    public CytoscapeEditor get_caller() {
        return this._caller;
    }

    public void set_caller(CytoscapeEditor _caller) {
        this._caller = _caller;
    }
}

