/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.editors;

import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.editors.BasicCytoscapeEditor;
import cytoscape.editor.impl.CytoShapeIcon;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.mappings.DiscreteMapping;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SimpleBioPAX_Editor
extends BasicCytoscapeEditor {
    private ShapePalette shapePalette;
    public static final String NODE_TYPE = "NODE_TYPE";

    public void initializeControls(List args) {
        String title;
        String controllingNodeAttribute = CytoscapeEditorManager.getControllingNodeAttribute(this);
        String controllingEdgeAttribute = CytoscapeEditorManager.getControllingEdgeAttribute(this);
        this.shapePalette = new ShapePalette();
        VisualMappingManager manager = Cytoscape.getDesktop().getVizMapManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        VisualStyle vizStyle = manager.getVisualStyle();
        System.out.println("Got visual style: " + vizStyle);
        EdgeAppearanceCalculator eac = vizStyle.getEdgeAppearanceCalculator();
        System.out.println("Got edgeAppearanceCalculator: " + eac);
        if (eac == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
            String title2 = "Cannot build palette for SimpleBioPAXEditor: no edge appearance calculator";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title2, -1);
            return;
        }
        GenericEdgeArrowCalculator edgeCalc = (GenericEdgeArrowCalculator)eac.getEdgeTargetArrowCalculator();
        System.out.println("Got edge target arrow calculator: " + edgeCalc);
        if (edgeCalc == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
            String title3 = "Cannot build palette for SimpleBioPAXEditor: no edge arrow calculator";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title3, -1);
            return;
        }
        Vector edgeMappings = edgeCalc.getMappings();
        DiscreteMapping dArrow = null;
        for (int i = 0; i < edgeMappings.size(); ++i) {
            DiscreteMapping dArrowCandidate = (DiscreteMapping)edgeMappings.get(i);
            String attr = dArrowCandidate.getControllingAttributeName();
            System.out.println("checking attribute: " + attr + " against controlling attribute: " + controllingEdgeAttribute);
            if (!attr.equals(controllingEdgeAttribute)) continue;
            dArrow = dArrowCandidate;
            break;
        }
        if (dArrow == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
            String title4 = "Cannot build palette for SimpleBioPAXEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title4, -1);
            return;
        }
        Arrow arrowType = (Arrow)dArrow.getMapValue((Object)"ACTIVATION");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "ACTIVATION", new CytoShapeIcon(arrowType), "ACTIVATION");
        arrowType = (Arrow)dArrow.getMapValue((Object)"ACTIVATION-NONALLOSTERIC");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "ACTIVATION-NONALLOSTERIC", new CytoShapeIcon(arrowType), "ACTIVATION-NONALLOSTERIC");
        arrowType = (Arrow)dArrow.getMapValue((Object)"COFACTOR");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "COFACTOR", new CytoShapeIcon(arrowType), "COFACTOR");
        arrowType = (Arrow)dArrow.getMapValue((Object)"CONTAINS");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "CONTAINS", new CytoShapeIcon(arrowType), "CONTAINS");
        arrowType = (Arrow)dArrow.getMapValue((Object)"CONTROLLED");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "CONTROLLED", new CytoShapeIcon(arrowType), "CONTROLLED");
        arrowType = (Arrow)dArrow.getMapValue((Object)"CONTROLLER");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "CONTROLLER", new CytoShapeIcon(arrowType), "CONTROLLER");
        arrowType = (Arrow)dArrow.getMapValue((Object)"INHIBITION");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "INHIBITION", new CytoShapeIcon(arrowType), "INHIBITION");
        arrowType = (Arrow)dArrow.getMapValue((Object)"LEFT");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "LEFT", new CytoShapeIcon(arrowType), "LEFT");
        arrowType = (Arrow)dArrow.getMapValue((Object)"RIGHT");
        this.shapePalette.addShape("BIOPAX_EDGE_TYPE", "RIGHT", new CytoShapeIcon(arrowType), "RIGHT");
        Color nodeColor = null;
        DiscreteMapping dfill = null;
        NodeAppearanceCalculator nac = vizStyle.getNodeAppearanceCalculator();
        System.out.println("Got NodeAppearanceCalculator: " + nac);
        if (nac == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to a aNODE_TYPE attribute.";
            String title5 = "Cannot build palette for SimpleBioPAXEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title5, -1);
            return;
        }
        GenericNodeColorCalculator nfill = (GenericNodeColorCalculator)nac.getNodeFillColorCalculator();
        System.out.println("Got node fill color calculator: " + nfill);
        if (nfill == null) {
            nodeColor = nac.getDefaultNodeFillColor();
        } else {
            Vector mappings = nfill.getMappings();
            dfill = null;
            for (int i = 0; i < mappings.size(); ++i) {
                DiscreteMapping dfillCandidate = (DiscreteMapping)mappings.get(i);
                String attr = dfillCandidate.getControllingAttributeName();
                System.out.println("checking attribute: " + attr + " against controlling attribute: " + controllingNodeAttribute);
                if (!attr.equals(controllingNodeAttribute)) continue;
                dfill = dfillCandidate;
                break;
            }
            if (dfill == null) {
                String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Shape to a ODE_TYPE attribute.";
                title = "Cannot build palette for SimpleBioPAXEditor";
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
                return;
            }
        }
        GenericNodeShapeCalculator nshape = (GenericNodeShapeCalculator)nac.getNodeShapeCalculator();
        if (nshape == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to a NODE_TYPE attribute.";
            title = "Cannot build palette for SimpleBioPAXEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        Vector mappings = nshape.getMappings();
        DiscreteMapping dshape = null;
        for (int i = 0; i < mappings.size(); ++i) {
            DiscreteMapping dshapeCandidate = (DiscreteMapping)mappings.get(i);
            String attr = dshapeCandidate.getControllingAttributeName();
            if (!attr.equals(controllingNodeAttribute)) continue;
            dshape = dshapeCandidate;
            break;
        }
        if (dshape == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Shape to NODE_TYPE attribute.";
            String title6 = "Cannot build palette for SimpleBioPAXEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title6, -1);
            return;
        }
        if (nodeColor == null) {
            nodeColor = nac.getDefaultNodeFillColor();
        }
        byte nodeShape = (Byte)dshape.getMapValue((Object)"protein");
        if (dfill != null) {
            nodeColor = (Color)dfill.getMapValue((Object)"protein");
        }
        this.shapePalette.addShape(NODE_TYPE, "protein", new CytoShapeIcon(nodeShape, nodeColor), "Protein");
        nodeShape = (Byte)dshape.getMapValue((Object)"catalysis");
        if (dfill != null) {
            nodeColor = (Color)dfill.getMapValue((Object)"catalysis");
        }
        this.shapePalette.addShape(NODE_TYPE, "catalysis", new CytoShapeIcon(nodeShape, nodeColor), "Catalysis");
        nodeShape = (Byte)dshape.getMapValue((Object)"smallMolecule");
        if (dfill != null) {
            nodeColor = (Color)dfill.getMapValue((Object)"smallMolecule");
        }
        this.shapePalette.addShape(NODE_TYPE, "smallMolecule", new CytoShapeIcon(nodeShape, nodeColor), "Small Molecule");
        nodeShape = (Byte)dshape.getMapValue((Object)"biochemicalReaction");
        if (dfill != null) {
            nodeColor = (Color)dfill.getMapValue((Object)"biochemicalReaction");
        }
        this.shapePalette.addShape(NODE_TYPE, "biochemicalReaction", new CytoShapeIcon(nodeShape, nodeColor), "Biochemical Reaction");
        nodeShape = (Byte)dshape.getMapValue((Object)"complex");
        if (dfill != null) {
            nodeColor = (Color)dfill.getMapValue((Object)"complex");
        }
        this.shapePalette.addShape(NODE_TYPE, "complex", new CytoShapeIcon(nodeShape, nodeColor), "Complex");
        nodeShape = (Byte)dshape.getMapValue((Object)"modulation");
        if (dfill != null) {
            nodeColor = (Color)dfill.getMapValue((Object)"modulation");
        }
        this.shapePalette.addShape(NODE_TYPE, "modulation", new CytoShapeIcon(nodeShape, nodeColor), "Modulation");
        nodeShape = (Byte)dshape.getMapValue((Object)"physicalEntity");
        if (dfill != null) {
            nodeColor = (Color)dfill.getMapValue((Object)"physicalEntity");
        }
        this.shapePalette.addShape(NODE_TYPE, "physicalEntity", new CytoShapeIcon(nodeShape, nodeColor), "Physical Entity");
        this.shapePalette.showPalette();
    }

    public void disableControls(List args) {
        this.shapePalette.setVisible(false);
    }

    public void enableControls(List args) {
        this.shapePalette.showPalette();
        this.shapePalette.setVisible(true);
    }
}

