/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.editors;

import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.editors.BasicCytoscapeEditor;
import cytoscape.editor.editors.MapBioMoleculeEditorToVisualStyle;
import cytoscape.editor.impl.CytoShapeIcon;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.mappings.DiscreteMapping;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SimpleBioMoleculeEditor
extends BasicCytoscapeEditor {
    private ShapePalette shapePalette;
    private static final String ICONS_REL_LOC = "images/";
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String EDGE_TYPE = "EDGE_TYPE";
    public static final String ACTIVATION = "Activation";
    public static final String INHIBITION = "Inhibition";
    public static final String CATALYSIS = "Catalysis";
    public static final String BIOMOLECULE_VISUAL_STYLE = "BioMoleculeEditor";
    public static MapBioMoleculeEditorToVisualStyle mpbv = null;
    private static boolean regeneratedVizStyle = false;

    public void initializeControls(List args) {
        VisualMappingManager manager = Cytoscape.getDesktop().getVizMapManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        VisualStyle vizStyle = catalog.getVisualStyle(BIOMOLECULE_VISUAL_STYLE);
        if (mpbv == null) {
            mpbv = new MapBioMoleculeEditorToVisualStyle();
            mpbv.createVizMapper();
        } else {
            mpbv.defineVisualStyle(vizStyle, manager, catalog);
        }
        this.shapePalette = new ShapePalette();
        String controllingNodeAttribute = CytoscapeEditorManager.getControllingNodeAttribute(this);
        String controllingEdgeAttribute = CytoscapeEditorManager.getControllingEdgeAttribute(this);
        if (vizStyle == null) {
            String expDescript = "Cannot find SimpleBioMoleculeEditor Visual Style.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        if (!regeneratedVizStyle) {
            regeneratedVizStyle = true;
            mpbv.defineVisualStyle(vizStyle, manager, catalog);
        }
        NodeAppearanceCalculator nac = vizStyle.getNodeAppearanceCalculator();
        System.out.println("NodeAppearanceCalculator for visual style: " + vizStyle + " is " + nac);
        if (nac == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to NODE_TYPE attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        GenericNodeColorCalculator nfill = (GenericNodeColorCalculator)nac.getNodeFillColorCalculator();
        System.out.println("NodeColorCalculator for visual style: " + vizStyle + " is " + nfill);
        if (nfill == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to NODE_TYPE attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        Vector mappings = nfill.getMappings();
        DiscreteMapping dfill = null;
        for (int i = 0; i < mappings.size(); ++i) {
            DiscreteMapping dfillCandidate = (DiscreteMapping)mappings.get(i);
            String attr = dfillCandidate.getControllingAttributeName();
            if (!attr.equals(NODE_TYPE)) continue;
            dfill = dfillCandidate;
            break;
        }
        System.out.println("DiscreteMapping for visual style: " + vizStyle + " is " + dfill);
        if (dfill == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Shape to NODE_TYPE attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        GenericNodeShapeCalculator nshape = (GenericNodeShapeCalculator)nac.getNodeShapeCalculator();
        if (nshape == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to NODE_TYPE attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        mappings = nshape.getMappings();
        DiscreteMapping dshape = null;
        for (int i = 0; i < mappings.size(); ++i) {
            DiscreteMapping dshapeCandidate = (DiscreteMapping)mappings.get(i);
            String attr = dshapeCandidate.getControllingAttributeName();
            if (!attr.equals(NODE_TYPE)) continue;
            dshape = dshapeCandidate;
            break;
        }
        if (dshape == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Shape to NODE_TYPE attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        EdgeAppearanceCalculator eac = vizStyle.getEdgeAppearanceCalculator();
        System.out.println("Got edgeAppearanceCalculator: " + eac);
        if (eac == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor: no edge appearance calculator";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        GenericEdgeArrowCalculator edgeCalc = (GenericEdgeArrowCalculator)eac.getEdgeTargetArrowCalculator();
        System.out.println("Got edge target arrow calculator: " + edgeCalc);
        if (edgeCalc == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor: no edge arrow calculator";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        Vector edgeMappings = edgeCalc.getMappings();
        DiscreteMapping dArrow = null;
        for (int i = 0; i < edgeMappings.size(); ++i) {
            DiscreteMapping dArrowCandidate = (DiscreteMapping)edgeMappings.get(i);
            String attr = dArrowCandidate.getControllingAttributeName();
            System.out.println("checking attribute: " + attr + " against controlling attribute: " + controllingEdgeAttribute);
            if (!attr.equals(controllingEdgeAttribute)) continue;
            dArrow = dArrowCandidate;
            System.out.println("Got edge mapping: " + dArrow);
            break;
        }
        if (dArrow == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
            String title = "Cannot build palette for SimpleBioMoleculeEditor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        System.out.println("adding edge arrows to palette");
        String[] EdgeTypes = new String[]{ACTIVATION, INHIBITION, CATALYSIS};
        for (int i = 0; i < EdgeTypes.length; ++i) {
            System.out.println("getting map value for edge type: " + EdgeTypes[i]);
            Arrow edgeTargetArrow = dArrow.getMapValue((Object)EdgeTypes[i]) != null ? (Arrow)dArrow.getMapValue((Object)EdgeTypes[i]) : eac.getDefaultEdgeTargetArrow();
            System.out.println("Addng shape for EdgeType " + EdgeTypes[i] + " = " + edgeTargetArrow);
            this.shapePalette.addShape(EDGE_TYPE, EdgeTypes[i], new CytoShapeIcon(edgeTargetArrow), EdgeTypes[i]);
        }
        byte nodeShape = (Byte)dshape.getMapValue((Object)"protein");
        Color nodeColor = (Color)dfill.getMapValue((Object)"protein");
        this.shapePalette.addShape(NODE_TYPE, "protein", new CytoShapeIcon(nodeShape, nodeColor), "Protein");
        nodeShape = (Byte)dshape.getMapValue((Object)"smallMolecule");
        nodeColor = (Color)dfill.getMapValue((Object)"smallMolecule");
        this.shapePalette.addShape(NODE_TYPE, "smallMolecule", new CytoShapeIcon(nodeShape, nodeColor), "Small Molecule");
        nodeShape = (Byte)dshape.getMapValue((Object)"biochemicalReaction");
        nodeColor = (Color)dfill.getMapValue((Object)"biochemicalReaction");
        this.shapePalette.addShape(NODE_TYPE, "biochemicalReaction", new CytoShapeIcon(nodeShape, nodeColor), "Biochemical Reaction");
        this.shapePalette.showPalette();
        super.initializeControls(null);
    }

    public void disableControls(List args) {
        if (this.shapePalette != null) {
            this.shapePalette.setVisible(false);
        }
    }

    public void enableControls(List args) {
        this.shapePalette.showPalette();
        this.shapePalette.setVisible(true);
    }
}

