/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.editors;

import cytoscape.Cytoscape;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;

public class MapBioMoleculeEditorToVisualStyle {
    public static final String BIOMOLECULE_VISUAL_STYLE = "BioMoleculeEditor";
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String EDGE_TYPE = "EDGE_TYPE";
    public static final String ACTIVATION = "Activation";
    public static final String INHIBITION = "Inhibition";
    public static final String CATALYSIS = "Catalysis";

    public void createVizMapper() {
        VisualMappingManager manager = Cytoscape.getDesktop().getVizMapManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        VisualStyle existingStyle = catalog.getVisualStyle(BIOMOLECULE_VISUAL_STYLE);
        if (existingStyle == null) {
            VisualStyle bpVisualStyle = new VisualStyle(BIOMOLECULE_VISUAL_STYLE);
            this.defineVisualStyle(bpVisualStyle, manager, catalog);
            manager.setVisualStyle(bpVisualStyle);
            catalog.addVisualStyle(bpVisualStyle);
            Cytoscape.getDesktop().setVisualStyle(bpVisualStyle);
        }
    }

    public void defineVisualStyle(VisualStyle bpVisualStyle, VisualMappingManager manager, CalculatorCatalog catalog) {
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator();
        nac.setDefaultNodeLabelColor(Color.BLACK);
        EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator();
        GlobalAppearanceCalculator gac = new GlobalAppearanceCalculator();
        gac.setDefaultBackgroundColor(new Color(204, 204, 255));
        this.createNodeShape(nac);
        this.createNodeLabel(nac);
        this.createNodeColor(nac);
        this.createTargetArrows(eac);
        bpVisualStyle.setNodeAppearanceCalculator(nac);
        bpVisualStyle.setEdgeAppearanceCalculator(eac);
        bpVisualStyle.setGlobalAppearanceCalculator(gac);
    }

    private void createTargetArrows(EdgeAppearanceCalculator eac) {
        DiscreteMapping discreteMapping = new DiscreteMapping((Object)Arrow.NONE, EDGE_TYPE, 0);
        discreteMapping.putMapValue((Object)ACTIVATION, (Object)Arrow.COLOR_DELTA);
        discreteMapping.putMapValue((Object)CATALYSIS, (Object)Arrow.BLACK_CIRCLE);
        discreteMapping.putMapValue((Object)INHIBITION, (Object)Arrow.BLACK_T);
        GenericEdgeArrowCalculator edgeTargetArrowCalculator = new GenericEdgeArrowCalculator("BioMoleculeEditor target arrows", (ObjectMapping)discreteMapping);
        eac.setEdgeTargetArrowCalculator((EdgeArrowCalculator)edgeTargetArrowCalculator);
        System.out.println("Set edge target arrow calculator to " + edgeTargetArrowCalculator);
    }

    private void createEdgeLabel(EdgeAppearanceCalculator eac) {
        PassThroughMapping passThroughMapping = new PassThroughMapping((Object)"", 0);
        passThroughMapping.setControllingAttributeName(EDGE_TYPE, null, false);
        GenericEdgeLabelCalculator edgeLabelCalculator = new GenericEdgeLabelCalculator("BioMoleculeEditor Edge Label Passthrough", (ObjectMapping)passThroughMapping);
        eac.setEdgeLabelCalculator((EdgeLabelCalculator)edgeLabelCalculator);
    }

    private void createNodeLabel(NodeAppearanceCalculator nac) {
        PassThroughMapping passThroughMapping = new PassThroughMapping((Object)"", 1);
        passThroughMapping.setControllingAttributeName("canonicalName", null, false);
        GenericNodeLabelCalculator nodeLabelCalculator = new GenericNodeLabelCalculator("BioMoleculeEditor ID Label", (ObjectMapping)passThroughMapping);
        nac.setNodeLabelCalculator((NodeLabelCalculator)nodeLabelCalculator);
    }

    private void createNodeShape(NodeAppearanceCalculator nac) {
        DiscreteMapping discreteMapping = new DiscreteMapping((Object)new Byte(0), NODE_TYPE, 1);
        discreteMapping.putMapValue((Object)"biochemicalReaction", (Object)new Byte(8));
        discreteMapping.putMapValue((Object)"protein", (Object)new Byte(0));
        discreteMapping.putMapValue((Object)"smallMolecule", (Object)new Byte(7));
        GenericNodeShapeCalculator nodeShapeCalculator = new GenericNodeShapeCalculator("BioMoleculeEditor Node Type Shape Calculator", (ObjectMapping)discreteMapping);
        nac.setNodeShapeCalculator((NodeShapeCalculator)nodeShapeCalculator);
    }

    private void createNodeColor(NodeAppearanceCalculator nac) {
        DiscreteMapping discreteMapping = new DiscreteMapping((Object)Color.WHITE, NODE_TYPE, 1);
        discreteMapping.putMapValue((Object)"biochemicalReaction", (Object)new Color(204, 0, 61));
        discreteMapping.putMapValue((Object)"protein", (Object)new Color(0, 102, 255));
        discreteMapping.putMapValue((Object)"smallMolecule", (Object)new Color(193, 249, 36));
        GenericNodeColorCalculator nodeColorCalculator = new GenericNodeColorCalculator("BioMoleculeEditor Node Color Calculator", (ObjectMapping)discreteMapping);
        nac.setNodeFillColorCalculator((NodeColorCalculator)nodeColorCalculator);
    }
}

