/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.editors;

import cytoscape.Cytoscape;
import cytoscape.editor.editors.BasicCytoscapeEditor;
import cytoscape.editor.impl.CytoShapeIcon;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import ding.view.DGraphView;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;

public class DefaultCytoscapeEditor
extends BasicCytoscapeEditor {
    private ShapePalette shapePalette;
    private static final String ICONS_REL_LOC = "images/";
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String EDGE_TYPE = "EDGE_TYPE";

    public void initializeControls(List args) {
        this.shapePalette = new ShapePalette();
        VisualMappingManager manager = Cytoscape.getDesktop().getVizMapManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        VisualStyle vizStyle = manager.getVisualStyle();
        NodeAppearanceCalculator nac = vizStyle.getNodeAppearanceCalculator();
        if (nac == null) {
            String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to NODE_TYPE attribute.";
            String title = "Cannot build palette for Default Cytoscape Editor";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return;
        }
        Color defaultNodeColor = nac.getDefaultNodeFillColor();
        byte defaultNodeShape = nac.getDefaultNodeShape();
        this.shapePalette.addShape(EDGE_TYPE, "DirectedEdge", new CytoShapeIcon(Arrow.BLACK_DELTA), "Directed Edge");
        this.shapePalette.addShape(NODE_TYPE, "DefaultNode", new CytoShapeIcon(defaultNodeShape, defaultNodeColor), "Add a Node");
        this.shapePalette.showPalette();
        ((DGraphView)Cytoscape.getCurrentNetworkView()).addNodeContextMenuListener(this);
        super.initializeControls(null);
    }

    public void disableControls(List args) {
        if (this.shapePalette != null) {
            this.shapePalette.setVisible(false);
        }
    }

    public void enableControls(List args) {
        this.shapePalette.showPalette();
        this.shapePalette.setVisible(true);
    }
}

