/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.editors;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeModifiedNetworkManager;
import cytoscape.data.CyAttributes;
import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.actions.DeleteAction;
import cytoscape.editor.event.BasicNetworkEditEventHandler;
import cytoscape.giny.PhoebeNetworkView;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.CytoscapeToolBar;
import cytoscape.view.CyMenus;
import cytoscape.view.CyNetworkView;
import ding.view.NodeContextMenuListener;
import giny.model.Edge;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class BasicCytoscapeEditor
implements CytoscapeEditor,
FlagEventListener,
NodeContextMenuListener {
    protected String editorName;
    CyMenus _cyMenus;
    CytoscapeToolBar _toolBar;
    CyNetworkView view;
    boolean DEBUG = false;
    Cursor _edgeCursor;
    Cursor _nodeCursor;
    Cursor _labelCursor;
    Image _nodeCursorImage;
    Image _connectionCursorImage;
    Cursor _originalCursor;
    JButton _addNodeButton;
    JButton _addEdgeButton;
    JButton _resetCursorButton;
    JButton _addLabelButton;
    private static final String ICONS_REL_LOC = "images/";
    public static final String BIOPAX_NAME_ATTRIBUTE = "BIOPAX_NAME";

    public CyNode addNode(String nodeName, String attribute, String value) {
        int iteration_limit;
        CyNode cn = Cytoscape.getCyNode((String)nodeName, (boolean)false);
        for (iteration_limit = 100; cn != null && iteration_limit > 0; --iteration_limit) {
            Date d1 = new Date();
            long t1 = d1.getTime();
            String s1 = Long.toString(t1);
            nodeName = nodeName + "_" + s1.substring(s1.length() - 3);
            cn = Cytoscape.getCyNode((String)nodeName, (boolean)false);
        }
        if (iteration_limit <= 0) {
            String expDescript = "Cytoscape Editor cannot generate a unique node for this network.  A serious internal error has occurred.  Please file a bug report at http://www.cytoscape.org.";
            String title = "Cannot generate a unique node";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
            return null;
        }
        cn = Cytoscape.getCyNode((String)nodeName, (boolean)true);
        CyNetwork net = Cytoscape.getCurrentNetwork();
        if (attribute != null) {
            CytoscapeEditorManager.nodeAttribs.setAttribute(cn.getIdentifier(), attribute, value);
            if (attribute != "NODE_TYPE") {
                CytoscapeEditorManager.nodeAttribs.setAttribute(cn.getIdentifier(), "NODE_TYPE", value);
            }
            CytoscapeEditorManager.nodeAttribs.setAttribute(cn.getIdentifier(), "BIOPAX_NODE_TYPE", value);
            CytoscapeEditorManager.nodeAttribs.setAttribute(cn.getIdentifier(), BIOPAX_NAME_ATTRIBUTE, cn.getIdentifier());
            net.restoreNode((Node)cn);
        }
        net.unFlagAllNodes();
        net.setFlagged((Node)cn, true);
        CytoscapeEditorManager.manager.setupUndoableAdditionEdit(net, cn, null);
        Cytoscape.firePropertyChange((String)"NETWORK_MODIFIED", null, (Object)net);
        return cn;
    }

    public void onFlagEvent(FlagEvent e) {
        Object obj = e.getTarget();
        if (obj instanceof NodeView) {
            NodeView nv = (NodeView)obj;
            CyNode myNode = (CyNode)nv.getNode();
            CyAttributes attribs = Cytoscape.getNodeAttributes();
            String canonicalName = attribs.getStringAttribute(myNode.getIdentifier(), "canonicalName");
            System.out.println("Got target: " + canonicalName);
        }
    }

    public void addNodeContextMenuItems(Point pt, Object nodeView, JPopupMenu menu) {
        if (nodeView instanceof NodeView) {
            final NodeView nv = (NodeView)nodeView;
            if (!this.menuItemExists(menu, "Rename (reset identifier)")) {
                menu.add(new AbstractAction("Rename (reset identifier)"){

                    public void actionPerformed(ActionEvent e) {
                        Node node = nv.getNode();
                        String oldId = node.getIdentifier();
                        String newId = JOptionPane.showInputDialog((Component)Cytoscape.getDesktop(), "Please enter a new identifier for this node", oldId);
                        if (newId != null && !newId.equals(oldId)) {
                            node.setIdentifier(newId);
                            CytoscapeEditorManager.resetAttributes(oldId, newId, CytoscapeEditorManager.nodeAttribs);
                            CytoscapeEditorManager.nodeAttribs.setAttribute(newId, "canonicalName", newId);
                            CytoscapeEditorManager.nodeAttribs.setAttribute(newId, "commonName", newId);
                            Cytoscape.firePropertyChange((String)"NETWORK_MODIFIED", null, (Object)Cytoscape.getCurrentNetwork());
                        }
                    }
                });
                menu.addSeparator();
            }
            if (!this.menuItemExists(menu, "Delete Selected Nodes and Edges")) {
                menu.add(new DeleteAction(null, "Delete"));
            }
        }
    }

    public boolean menuItemExists(JPopupMenu menu, String label) {
        boolean itemExists = false;
        MenuElement[] elements = menu.getSubElements();
        for (int i = 0; i < elements.length; ++i) {
            JMenuItem item;
            MenuElement elem = elements[i];
            if (!(elem instanceof JMenuItem) || !(item = (JMenuItem)elem).getText().equals(label)) continue;
            itemExists = true;
            break;
        }
        return itemExists;
    }

    public CyNode addNode(String nodeName, String nodeType) {
        return this.addNode(nodeName, "NODE_TYPE", nodeType);
    }

    public CyNode addNode(String nodeName, boolean create) {
        return this.addNode(nodeName, null);
    }

    public CyNode addNode(String nodeName) {
        return this.addNode(nodeName, null);
    }

    public CyEdge addEdge(Node node_1, Node node_2, String attribute, Object attribute_value, boolean create, String edgeType) {
        CyEdge edge = Cytoscape.getCyEdge((Node)node_1, (Node)node_2, (String)attribute, (Object)attribute_value, (boolean)create);
        if (edge != null) {
            CyNetwork net = Cytoscape.getCurrentNetwork();
            net.restoreEdge((Edge)edge);
            if (edgeType != null) {
                CytoscapeEditorManager.edgeAttribs.setAttribute(edge.getIdentifier(), "EDGE_TYPE", edgeType);
            }
            CytoscapeEditorManager.manager.setupUndoableAdditionEdit(net, null, edge);
            Cytoscape.firePropertyChange((String)"NETWORK_MODIFIED", null, (Object)net);
        }
        return edge;
    }

    public CyEdge addEdge(Node node_1, Node node_2, String attribute, Object attribute_value) {
        return this.addEdge(node_1, node_2, attribute, attribute_value, true, null);
    }

    public CyEdge addEdge(Node node_1, Node node_2, String attribute, Object attribute_value, String edgeType) {
        return this.addEdge(node_1, node_2, attribute, attribute_value, true, edgeType);
    }

    public CyEdge addEdge(Node node_1, Node node_2, String attribute, Object attribute_value, boolean create) {
        return this.addEdge(node_1, node_2, attribute, attribute_value, create, null);
    }

    public void deleteNode(Node node) {
        CyNetwork net = Cytoscape.getCurrentNetwork();
        net.hideNode(node);
        CytoscapeModifiedNetworkManager.setModified((CyNetwork)net, (String)"Modified");
    }

    public void deleteEdge(CyEdge edge) {
        CyNetwork net = Cytoscape.getCurrentNetwork();
        net.hideEdge((Edge)edge);
        CytoscapeModifiedNetworkManager.setModified((CyNetwork)net, (String)"Modified");
    }

    public void initializeControls(List args) {
        JMenu editMenu = Cytoscape.getDesktop().getCyMenus().getEditMenu();
        boolean foundConnectSelected = false;
        System.out.println("item count = " + editMenu.getItemCount());
        for (int i = 0; i < editMenu.getItemCount(); ++i) {
            String name;
            JMenuItem jIt = editMenu.getItem(i);
            if (jIt == null || !(name = jIt.getText()).equals("Connect Selected Nodes")) continue;
            foundConnectSelected = true;
            break;
        }
        if (!foundConnectSelected) {
            ConnectSelectedNodesAction connectAction = new ConnectSelectedNodesAction();
            connectAction.setPreferredMenu("Edit");
            Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)connectAction);
        }
        this._cyMenus = Cytoscape.getDesktop().getCyMenus();
        this._originalCursor = Cytoscape.getDesktop().getCursor();
    }

    public void disableControls(List args) {
        if (this._addNodeButton != null) {
            this._addNodeButton.setVisible(false);
        }
        if (this._addEdgeButton != null) {
            this._addEdgeButton.setVisible(false);
        }
        if (this._resetCursorButton != null) {
            this._resetCursorButton.setVisible(false);
        }
    }

    public void enableControls(List args) {
        System.out.println("enabling controls for " + this);
        this._addNodeButton.setVisible(true);
        this._addEdgeButton.setVisible(true);
        this._resetCursorButton.setVisible(true);
    }

    public String getEditorName() {
        return this.editorName;
    }

    public void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    class ConnectSelectedNodesAction
    extends CytoscapeAction {
        public ConnectSelectedNodesAction() {
            super("Connect Selected Nodes");
            this.setPreferredMenu("Edit");
        }

        public ConnectSelectedNodesAction(boolean label) {
        }

        public String getName() {
            return "Connect Selected Nodes";
        }

        public void actionPerformed(ActionEvent e) {
            CyNetworkView view = Cytoscape.getCurrentNetworkView();
            List nodes = view.getSelectedNodes();
            for (int i = 0; i < nodes.size() - 1; ++i) {
                NodeView nv = (NodeView)nodes.get(i);
                CyNode firstCyNode = (CyNode)nv.getNode();
                for (int j = i + 1; j < nodes.size(); ++j) {
                    NodeView nv2 = (NodeView)nodes.get(j);
                    CyNode secondCyNode = (CyNode)nv2.getNode();
                    BasicCytoscapeEditor.this.addEdge((Node)firstCyNode, (Node)secondCyNode, "interaction", "default", true, "DefaultEdge");
                }
            }
        }
    }

    class ResetCursorAction
    extends CytoscapeAction {
        public ResetCursorAction() {
            super("");
        }

        public void actionPerformed(ActionEvent ae) {
            CyNetworkView view = Cytoscape.getCurrentNetworkView();
            ((PhoebeNetworkView)Cytoscape.getCurrentNetworkView()).getCanvas().setCursor(BasicCytoscapeEditor.this._originalCursor);
            BasicNetworkEditEventHandler event = (BasicNetworkEditEventHandler)CytoscapeEditorManager.getViewNetworkEditEventAdapter(view);
            if (event == null) {
                System.out.println("Error: cannot find event handler for view: " + view);
            }
        }
    }

    class AddEdgeAction
    extends CytoscapeAction {
        public AddEdgeAction() {
            super("");
        }

        public void actionPerformed(ActionEvent ae) {
            CyNetworkView view = Cytoscape.getCurrentNetworkView();
            ((PhoebeNetworkView)Cytoscape.getCurrentNetworkView()).getCanvas().setCursor(BasicCytoscapeEditor.this._edgeCursor);
            BasicNetworkEditEventHandler event = (BasicNetworkEditEventHandler)CytoscapeEditorManager.getViewNetworkEditEventAdapter(view);
            if (event == null) {
                System.out.println("Error: cannot find event handler for view: " + view);
            }
        }
    }

    class AddLabelAction
    extends CytoscapeAction {
        public AddLabelAction() {
            super("");
        }

        public void actionPerformed(ActionEvent ae) {
            CyNetworkView view = Cytoscape.getCurrentNetworkView();
            ((PhoebeNetworkView)Cytoscape.getCurrentNetworkView()).getCanvas().setCursor(BasicCytoscapeEditor.this._nodeCursor);
            BasicNetworkEditEventHandler event = (BasicNetworkEditEventHandler)CytoscapeEditorManager.getViewNetworkEditEventAdapter(view);
            if (event == null) {
                System.out.println("Error: cannot find event handler for view: " + view);
            }
        }
    }

    class AddNodeAction
    extends CytoscapeAction {
        public AddNodeAction() {
            super("");
        }

        public void actionPerformed(ActionEvent ae) {
            CyNetworkView view = Cytoscape.getCurrentNetworkView();
            ((PhoebeNetworkView)Cytoscape.getCurrentNetworkView()).getCanvas().setCursor(BasicCytoscapeEditor.this._nodeCursor);
            BasicNetworkEditEventHandler event = (BasicNetworkEditEventHandler)CytoscapeEditorManager.getViewNetworkEditEventAdapter(view);
            if (event == null) {
                System.out.println("Error: cannot find event handler for view: " + view);
            }
        }
    }
}

