/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.actions;

import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.actions.RedoAction;
import cytoscape.editor.impl.ShapePalette;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class UndoAction
extends AbstractAction {
    UndoManager undo;
    RedoAction redoAction;

    public UndoAction(UndoManager undo) {
        super("");
        this.undo = undo;
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            UndoManager undoMgr = CytoscapeEditorManager.getUndoManagerForView(Cytoscape.getCurrentNetworkView());
            undoMgr.undo();
        }
        catch (CannotUndoException ex) {
            System.out.println("Unable to undo: " + ex);
        }
        this.update();
        System.out.println("updating redoAction for" + this + " = " + this.redoAction);
        this.redoAction.update();
    }

    public void update() {
        UndoManager undoMgr = CytoscapeEditorManager.getUndoManagerForView(Cytoscape.getCurrentNetworkView());
        ShapePalette palette = CytoscapeEditorManager.getShapePaletteForView(Cytoscape.getCurrentNetworkView());
        if (undoMgr.canUndo()) {
            this.setEnabled(true);
            if (palette != null) {
                palette.getUndoButton().setEnabled(true);
            }
        } else {
            this.setEnabled(false);
            if (palette != null) {
                palette.getUndoButton().setEnabled(false);
            }
        }
    }

    public void setRedoAction(RedoAction redoAction) {
        System.out.println("Setting redo action for undo action: " + this + " = " + redoAction);
        this.redoAction = redoAction;
    }
}

