/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.CytoscapeEditorFactory;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.InvalidEditorException;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import java.awt.event.ActionEvent;

public class SetEditorAction
extends CytoscapeAction {
    private String editorName;
    private CytoscapeEditorFactory factory;

    public SetEditorAction(String editorName, CytoscapeEditorFactory factory) {
        super(editorName);
        this.editorName = editorName;
        this.factory = factory;
        this.setPreferredMenu("File.SetEditor");
        System.out.println("Set editor action for editor name: " + editorName);
    }

    public void actionPerformed(ActionEvent e) {
        CytoscapeEditorManager.setEditingEnabled(true);
        CytoscapeEditor oldEditor = CytoscapeEditorManager.getCurrentEditor();
        if (oldEditor != null) {
            oldEditor.disableControls(null);
        }
        try {
            CytoscapeEditorManager.setSettingUpEditor(true);
            CytoscapeEditor cyEditor = this.factory.getEditor(this.editorName);
            CyNetworkView view = Cytoscape.getCurrentNetworkView();
            String viewTitle = "null";
            if (view != null) {
                viewTitle = view.getTitle();
            }
            if (viewTitle.equals("null")) {
                CyNetwork newNet = Cytoscape.createNetwork((String)("Net:" + CytoscapeEditorManager.getNetworkNameCounter()));
                CytoscapeEditorManager.incrementNetworkNameCounter();
                view = Cytoscape.createNetworkView((CyNetwork)newNet);
                CytoscapeEditorManager.setEditorForNetwork(newNet, cyEditor);
                CytoscapeEditorManager.setEditorForView(view, cyEditor);
            }
            String visualStyleName = CytoscapeEditorManager.getVisualStyleForEditorType(this.editorName);
            System.out.println("getting visual style for: " + visualStyleName);
            if (visualStyleName != null && !visualStyleName.equals("ANY_VISUAL_STYLE")) {
                VisualMappingManager manager = Cytoscape.getDesktop().getVizMapManager();
                CalculatorCatalog catalog = manager.getCalculatorCatalog();
                VisualStyle existingStyle = catalog.getVisualStyle(visualStyleName);
                System.out.println("Got visual style: " + existingStyle);
                System.out.println("getting visual style for editor: " + this.editorName);
                if (existingStyle != null) {
                    manager.setVisualStyle(existingStyle);
                    CytoscapeEditorManager.setEditorForVisualStyle(existingStyle, cyEditor);
                }
            }
            CytoscapeEditorManager.setCurrentEditor(cyEditor);
            cyEditor.initializeControls(null);
            ShapePalette palette = CytoscapeEditorManager.getShapePaletteForView(view);
            if (palette != null) {
                // empty if block
            }
            CytoscapeEditorManager.setEventHandlerForView(view);
            CytoscapeEditorManager.setSettingUpEditor(false);
            Cytoscape.getDesktop().getCyMenus().getMenuBar().getMenu("File.New").setEnabled(true);
        }
        catch (InvalidEditorException ex) {
            CytoscapeEditorManager.setSettingUpEditor(false);
            ex.printStackTrace();
        }
        Cytoscape.getCurrentNetworkView().redrawGraph(true, true);
    }
}

