/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.actions;

import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.actions.UndoAction;
import cytoscape.editor.impl.ShapePalette;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;

public class RedoAction
extends AbstractAction {
    UndoManager undo;
    UndoAction undoAction;

    public RedoAction(UndoManager undo) {
        super("");
        this.undo = undo;
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            UndoManager undoMgr = CytoscapeEditorManager.getUndoManagerForView(Cytoscape.getCurrentNetworkView());
            undoMgr.redo();
        }
        catch (CannotRedoException ex) {
            System.out.println("Unable to redo: " + ex);
        }
        this.update();
        this.undoAction.update();
    }

    public void update() {
        UndoManager undoMgr = CytoscapeEditorManager.getUndoManagerForView(Cytoscape.getCurrentNetworkView());
        ShapePalette palette = CytoscapeEditorManager.getShapePaletteForView(Cytoscape.getCurrentNetworkView());
        System.out.println("for redo: " + this);
        System.out.println("REDO: " + this.undo.canRedo());
        if (undoMgr.canRedo()) {
            this.setEnabled(true);
            if (palette != null) {
                palette.getRedoButton().setEnabled(true);
            }
        } else {
            this.setEnabled(false);
            if (palette != null) {
                palette.getRedoButton().setEnabled(false);
            }
        }
    }

    public void update(boolean redoFlag) {
        UndoManager undoMgr = CytoscapeEditorManager.getUndoManagerForView(Cytoscape.getCurrentNetworkView());
        ShapePalette palette = CytoscapeEditorManager.getShapePaletteForView(Cytoscape.getCurrentNetworkView());
        System.out.println("for redo: " + this);
        System.out.println("REDO: " + this.undo.canRedo());
        if (undoMgr.canRedo() || redoFlag) {
            this.setEnabled(true);
            if (palette != null) {
                palette.getRedoButton().setEnabled(true);
            }
        } else {
            this.setEnabled(false);
            if (palette != null) {
                palette.getRedoButton().setEnabled(false);
            }
        }
    }

    public void setUndoAction(UndoAction undoAction) {
        this.undoAction = undoAction;
    }
}

