/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.CytoscapeEditorFactory;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class NewNetworkAction
extends CytoscapeAction {
    private String editorName;
    private CytoscapeEditorFactory factory;
    private static int counter = 0;

    public NewNetworkAction(String editorName, CytoscapeEditorFactory factory) {
        super(editorName);
        this.editorName = editorName;
        this.factory = factory;
        this.setPreferredMenu("File.New");
    }

    public NewNetworkAction(boolean label) {
    }

    public void actionPerformed(ActionEvent e) {
        CytoscapeEditor cyEditor = CytoscapeEditorManager.getCurrentEditor();
        if (cyEditor == null) {
            String expDescript = "You must first set up an editor for Cytoscape via the File->SetEditor menu item.";
            String title = "Cytoscape Editor not yet set";
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), expDescript, title, -1);
        } else {
            CyNetwork _newNet = Cytoscape.createNetwork((String)("Net:" + CytoscapeEditorManager.getNetworkNameCounter()));
            CytoscapeEditorManager.incrementNetworkNameCounter();
            CyNetworkView newView = Cytoscape.createNetworkView((CyNetwork)_newNet);
            CytoscapeEditorManager.setEditorForNetwork(_newNet, cyEditor);
            CytoscapeEditorManager.setEditorForView(newView, cyEditor);
        }
    }
}

