/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor.actions;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import edu.umd.cs.piccolo.PNode;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;

public class DeleteAction
extends AbstractAction {
    private static Image _my_icon;
    private Object _cyObj = null;
    private String _label = null;

    public DeleteAction() {
        super("Delete Selected Nodes and Edges");
    }

    public DeleteAction(Object obj) {
        super("Delete Selected Nodes and Edges");
        this._cyObj = obj;
    }

    public DeleteAction(Object obj, String label) {
        super("Delete Selected Nodes and Edges");
        this._cyObj = obj;
        this._label = label;
    }

    public static String getTitle(Object[] args, PNode node) {
        return "Delete Selected Nodes and Edges";
    }

    public void actionPerformed(ActionEvent ae) {
        CyNetworkView myView = Cytoscape.getCurrentNetworkView();
        List edgeViews = myView.getSelectedEdges();
        List nodeViews = myView.getSelectedNodes();
        CyNetwork cyNet = myView.getNetwork();
        int[] nodes = new int[nodeViews.size() + 1];
        int[] allEdges = new int[]{};
        for (int i = 0; i < nodeViews.size(); ++i) {
            int nodeIdx;
            NodeView nview = (NodeView)nodeViews.get(i);
            CyNode cyNode = (CyNode)nview.getNode();
            nodes[i] = nodeIdx = cyNode.getRootGraphIndex();
            int[] edgesList = cyNet.getAdjacentEdgeIndicesArray(nodeIdx, true, true, true);
            int[] bigEdges = new int[allEdges.length + edgesList.length];
            for (int m = 0; m < allEdges.length; ++m) {
                bigEdges[m] = allEdges[m];
            }
            for (int p = 0; p < edgesList.length; ++p) {
                bigEdges[allEdges.length + p] = edgesList[p];
            }
            allEdges = bigEdges;
        }
        for (int j = 0; j < edgeViews.size(); ++j) {
            EdgeView eview = (EdgeView)edgeViews.get(j);
            CyEdge cyEdge = (CyEdge)eview.getEdge();
            int edgeIdx = cyEdge.getRootGraphIndex();
            int[] bigEdges = new int[allEdges.length + 1];
            for (int m = 0; m < allEdges.length; ++m) {
                bigEdges[m] = allEdges[m];
            }
            bigEdges[allEdges.length] = edgeIdx;
            allEdges = bigEdges;
        }
        if (this._cyObj instanceof Node) {
            int nodeIdx;
            CyNode cyNode = (CyNode)this._cyObj;
            nodes[nodeViews.size()] = nodeIdx = cyNode.getRootGraphIndex();
            int[] edgesList = cyNet.getAdjacentEdgeIndicesArray(nodeIdx, true, true, true);
            int[] bigEdges = new int[allEdges.length + edgesList.length];
            for (int m = 0; m < allEdges.length; ++m) {
                bigEdges[m] = allEdges[m];
            }
            for (int p = 0; p < edgesList.length; ++p) {
                bigEdges[allEdges.length + p] = edgesList[p];
            }
            allEdges = bigEdges;
        }
        if (this._cyObj instanceof Edge) {
            CyEdge myEdge = (CyEdge)this._cyObj;
            int edgeIdx = myEdge.getRootGraphIndex();
            int[] bigEdges = new int[allEdges.length + 1];
            for (int m = 0; m < allEdges.length; ++m) {
                bigEdges[m] = allEdges[m];
            }
            bigEdges[allEdges.length] = edgeIdx;
            allEdges = bigEdges;
        }
        int[] edges = allEdges;
        cyNet.hideNodes(nodes);
        cyNet.hideEdges(edges);
        Cytoscape.firePropertyChange((String)"NETWORK_MODIFIED", null, (Object)cyNet);
    }
}

