/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.CytoscapeEditorFactory;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.InvalidEditorException;
import cytoscape.plugin.CytoscapePlugin;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class CytoscapeEditorPlugin
extends CytoscapePlugin {
    private static final String ICONS_REL_LOC = "images/";
    private static final String BIO_PAX_VISUAL_STYLE = "BioPAX_editor";

    public CytoscapeEditorPlugin() {
        System.out.println("CytoscapeEditor loaded ");
        MainPluginAction mpa = new MainPluginAction();
        CytoscapeEditorManager.setRunningEditorFramework(true);
        System.out.println("Setting up CytoscapeEditor");
        mpa.enableCytoscapeEditor();
    }

    public class MainPluginAction
    extends AbstractAction {
        public MainPluginAction() {
            super("Cytoscape Editor");
        }

        public String describe() {
            StringBuffer sb = new StringBuffer();
            sb.append("Add nodes and edges to a Cytoscape Network. ");
            return sb.toString();
        }

        public void actionPerformed(ActionEvent ae) {
            this.enableCytoscapeEditor();
        }

        public void enableCytoscapeEditor() {
            String[] cytoscapeArgs = CytoscapeInit.getArgs();
            for (int i = 0; i < cytoscapeArgs.length; ++i) {
                String arg = cytoscapeArgs[i];
                if (!arg.equals("--EditorFramework")) continue;
                CytoscapeEditorManager.setRunningEditorFramework(true);
                break;
            }
            CytoscapeEditorManager.initialize();
            System.out.println("Registering editor: DefaultCytoscapeEditor with visual style:  ANY_VISUAL_STYLE");
            CytoscapeEditorManager.register("DefaultCytoscapeEditor", "cytoscape.editor.event.PaletteNetworkEditEventHandler", "NODE_TYPE", "EDGE_TYPE", "ANY_VISUAL_STYLE");
            CytoscapeEditorManager.setVisualStyleNameForEditorType("DefaultCytoscapeEditor", "ANY_VISUAL_STYLE");
            CytoscapeEditorManager.register("SimpleBioMoleculeEditor", "cytoscape.editor.event.PaletteNetworkEditEventHandler", "NODE_TYPE", "EDGE_TYPE", "BioMoleculeEditor");
            CytoscapeEditorManager.setVisualStyleNameForEditorType("SimpleBioMoleculeEditor", "BioMoleculeEditor");
            String editorName = "DefaultCytoscapeEditor";
            try {
                CytoscapeEditor cyEditor = CytoscapeEditorFactory.INSTANCE.getEditor(editorName);
                CytoscapeEditorManager.setCurrentEditor(cyEditor);
                CytoscapeEditorManager.setDefaultEditor(cyEditor);
            }
            catch (InvalidEditorException ex) {
                System.out.println("Error: cannot set up Cytoscape Editor: " + editorName);
            }
            Cytoscape.getDesktop().setVisualStyle(Cytoscape.getDesktop().getVizMapManager().getCalculatorCatalog().getVisualStyle(CytoscapeInit.getDefaultVisualStyle()));
        }
    }
}

