/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.editor;

import cern.colt.list.IntArrayList;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.CytoscapeModifiedNetworkManager;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.MultiHashMapListener;
import cytoscape.editor.CytoscapeEditor;
import cytoscape.editor.CytoscapeEditorFactory;
import cytoscape.editor.actions.NewNetworkAction;
import cytoscape.editor.actions.RedoAction;
import cytoscape.editor.actions.RestoreAction;
import cytoscape.editor.actions.SetEditorAction;
import cytoscape.editor.actions.UndoAction;
import cytoscape.editor.event.NetworkEditEventAdapter;
import cytoscape.editor.impl.CytoscapeEditorManagerSupport;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.visual.VisualStyle;
import ding.view.DGraphView;
import ding.view.InnerCanvas;
import giny.model.GraphPerspective;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import phoebe.PhoebeCanvas;

public abstract class CytoscapeEditorManager {
    private static IntArrayList nodeClipBoard;
    private static IntArrayList edgeClipBoard;
    private static String networkClipBoard;
    private static UndoManager undo;
    private static UndoManager currentUndoManager;
    private PhoebeCanvas canvas;
    static float defaultBorderWidth;
    public static CytoscapeEditorManagerSupport manager;
    protected static CytoscapeEditor currentEditor;
    protected static boolean runningEditorFramework;
    private static boolean settingUpEditor;
    protected static HashMap editorViewMap;
    protected static boolean editingEnabled;
    protected static CytoscapeEditor defaultEditor;
    protected static ShapePalette currentShapePalette;
    protected static HashMap undoManagerViewMap;
    protected static HashMap undoActionViewMap;
    protected static HashMap redoActionViewMap;
    protected static HashMap editorNetworkMap;
    protected static HashMap editorTypeEventAdapterMap;
    protected static HashMap viewNetworkEditEventAdapterMap;
    protected static HashMap editorControllingNodeAttributeMap;
    protected static HashMap editorControllingEdgeAttributeMap;
    private static int networkNameCounter;
    protected static HashMap editorTypeVisualStyleNameMap;
    protected static HashMap viewShapePaletteMap;
    protected static HashMap visualStyleEditorMap;
    protected static HashMap visualStyleNameEditorTypeMap;
    protected static HashMap networkHiddenNodesMap;
    protected static HashMap networkHiddenEdgesMap;
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String BIOPAX_NODE_TYPE = "BIOPAX_NODE_TYPE";
    public static final String EDGE_TYPE = "EDGE_TYPE";
    public static final String ANY_VISUAL_STYLE = "ANY_VISUAL_STYLE";
    public static final String DEFAULT_EDITOR_TYPE = "DefaultCytoscapeEditor";
    public static CyAttributes nodeAttribs;
    public static CyAttributes edgeAttribs;

    public static void initialize() {
        manager = new CytoscapeEditorManagerSupport();
        CytoscapeModifiedNetworkManager modifiedManager = new CytoscapeModifiedNetworkManager();
        NewNetworkAction newNetwork = new NewNetworkAction("Network", CytoscapeEditorFactory.INSTANCE);
        Cytoscape.getDesktop().getCyMenus().getMenuBar().getMenu("File.New");
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)newNetwork);
        Cytoscape.getDesktop().getCyMenus().getMenuBar().getMenu("File.New").setEnabled(false);
        RestoreAction restoreAction = new RestoreAction();
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)restoreAction);
    }

    public static void register(String editorName) {
        CytoscapeEditorManager.register(editorName, "BasicNetworkEventHandler");
    }

    public static void register(String editorName, String networkEditAdapterName) {
        SetEditorAction editNetwork = new SetEditorAction(editorName, CytoscapeEditorFactory.INSTANCE);
        Cytoscape.getDesktop().getCyMenus().getMenuBar().getMenu("File.SetEditor");
        Cytoscape.getDesktop().getCyMenus().getMenuBar().getMenu("File.SetEditor").setEnabled(true);
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)editNetwork);
        CytoscapeEditorManager.setNetworkEditEventAdapterType(editorName, networkEditAdapterName);
    }

    public static void register(String editorName, String networkEditAdapterName, String visualStyleName) {
        CytoscapeEditorManager.register(editorName, networkEditAdapterName);
        System.out.println("Setting editor type: " + editorName + " for visual style: " + visualStyleName);
        CytoscapeEditorManager.setEditorTypeForVisualStyleName(visualStyleName, editorName);
    }

    public static void register(String editorName, String networkEditAdapterName, String controllingNodeAttribute, String controllingEdgeAttribute) {
        CytoscapeEditorManager.register(editorName, networkEditAdapterName);
        CytoscapeEditorManager.setControllingNodeAttribute(editorName, controllingNodeAttribute);
        CytoscapeEditorManager.setControllingEdgeAttribute(editorName, controllingEdgeAttribute);
    }

    public static void register(String editorName, String networkEditAdapterName, String controllingNodeAttribute, String controllingEdgeAttribute, String visualStyleName) {
        CytoscapeEditorManager.register(editorName, networkEditAdapterName);
        CytoscapeEditorManager.setControllingNodeAttribute(editorName, controllingNodeAttribute);
        CytoscapeEditorManager.setControllingEdgeAttribute(editorName, controllingEdgeAttribute);
        CytoscapeEditorManager.setEditorTypeForVisualStyleName(visualStyleName, editorName);
    }

    public static boolean hasContextMethods(CyNetworkView view) {
        Object[] methods = view.getContextMethods("class ding.view.DNodeView", false);
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                Object[] methodObj = (Object[])methods[i];
                String methodClassName = methodObj[0].toString();
                if (methodClassName == null || !methodClassName.equals("cytoscape.editor.actions.NodeAction")) continue;
                return true;
            }
        }
        return false;
    }

    public static void setupNewNetworkView(CyNetworkView newView) {
        if (!CytoscapeEditorManager.hasContextMethods(newView)) {
            newView.addContextMethod("class ding.view.DNodeView", "cytoscape.editor.actions.NodeAction", "getContextMenuItem", new Object[]{newView}, (ClassLoader)CytoscapeInit.getClassLoader());
        }
        CytoscapeEditor cyEditor = CytoscapeEditorManager.getCurrentEditor();
        GraphPerspective wiw = newView.getGraphPerspective();
        DGraphView wiwx = (DGraphView)newView;
        InnerCanvas canvas = wiwx.getCanvas();
        NetworkEditEventAdapter event = CytoscapeEditorManager.getViewNetworkEditEventAdapter(newView);
        if (event == null) {
            event = CytoscapeEditorFactory.INSTANCE.getNetworkEditEventAdapter(cyEditor);
            CytoscapeEditorManager.setViewNetworkEditEventAdapter(newView, event);
            canvas.addPhoebeCanvasDropListener(event);
            CyNetwork net = newView.getNetwork();
            nodeAttribs.getMultiHashMap().addDataListener((MultiHashMapListener)event);
            edgeAttribs.getMultiHashMap().addDataListener((MultiHashMapListener)event);
        }
        canvas.getBounds();
        Color myColor = new Color(225, 250, 200);
        canvas.setEnabled(true);
    }

    public static void resetEventHandlerForExistingViews() {
        Map viewMap = Cytoscape.getNetworkViewMap();
        Set keySet = viewMap.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object entryObj = viewMap.get(key);
            DGraphView entryView = (DGraphView)entryObj;
            InnerCanvas canvas = entryView.getCanvas();
            NetworkEditEventAdapter oldEvent = CytoscapeEditorManager.getViewNetworkEditEventAdapter((CyNetworkView)entryView);
            if (oldEvent != null) {
                canvas.removeMouseListener(oldEvent);
                canvas.removeMouseMotionListener(oldEvent);
                canvas.removePhoebeCanvasDropListener(oldEvent);
            }
            CytoscapeEditor cyEditor = CytoscapeEditorManager.getCurrentEditor();
            NetworkEditEventAdapter newEvent = CytoscapeEditorFactory.INSTANCE.getNetworkEditEventAdapter(cyEditor);
            CytoscapeEditorManager.setViewNetworkEditEventAdapter((CyNetworkView)entryView, newEvent);
            newEvent.start(entryView);
            canvas.addPhoebeCanvasDropListener(newEvent);
            canvas.addMouseListener(newEvent);
            canvas.addMouseMotionListener(newEvent);
            System.out.println("Mouse and MotionListeners added to " + canvas);
            System.out.println("Canvas has total number of Listeners = " + canvas.getMouseListeners().length);
        }
    }

    public static void setEventHandlerForView(CyNetworkView view) {
        DGraphView thisView = (DGraphView)view;
        InnerCanvas canvas = thisView.getCanvas();
        NetworkEditEventAdapter oldEvent = CytoscapeEditorManager.getViewNetworkEditEventAdapter((CyNetworkView)thisView);
        if (oldEvent != null) {
            canvas.removeMouseListener(oldEvent);
            canvas.removeMouseMotionListener(oldEvent);
            canvas.removePhoebeCanvasDropListener(oldEvent);
        }
        CytoscapeEditor cyEditor = CytoscapeEditorManager.getCurrentEditor();
        NetworkEditEventAdapter newEvent = CytoscapeEditorFactory.INSTANCE.getNetworkEditEventAdapter(cyEditor);
        CytoscapeEditorManager.setViewNetworkEditEventAdapter((CyNetworkView)thisView, newEvent);
        newEvent.setView((DGraphView)view);
        newEvent.start(thisView);
        canvas.addPhoebeCanvasDropListener(newEvent);
        canvas.addMouseListener(newEvent);
        canvas.addMouseMotionListener(newEvent);
        System.out.println("Mouse and MotionListeners added to " + canvas);
        System.out.println("Canvas has total number of Listeners = " + canvas.getMouseListeners().length);
    }

    public static void setNetworkEditEventAdapterType(String editorType, String event) {
        editorTypeEventAdapterMap.put(editorType, event);
    }

    public static String getNetworkEditEventAdapterType(String editorType) {
        Object obj = editorTypeEventAdapterMap.get(editorType);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static void setViewNetworkEditEventAdapter(CyNetworkView view, NetworkEditEventAdapter event) {
        viewNetworkEditEventAdapterMap.put(view, event);
    }

    public static NetworkEditEventAdapter getViewNetworkEditEventAdapter(CyNetworkView view) {
        Object obj = viewNetworkEditEventAdapterMap.get(view);
        if (obj != null && obj instanceof NetworkEditEventAdapter) {
            return (NetworkEditEventAdapter)obj;
        }
        return null;
    }

    public static HashMap getEditorTypeEventAdapterMap() {
        return editorTypeEventAdapterMap;
    }

    public static HashMap getEditorNetworkMap() {
        return editorNetworkMap;
    }

    public static HashMap getEditorViewMap() {
        return editorViewMap;
    }

    public static CytoscapeEditor getEditorForNetwork(CyNetwork net) {
        Object obj = editorNetworkMap.get(net);
        if (obj != null && obj instanceof CytoscapeEditor) {
            return (CytoscapeEditor)obj;
        }
        return null;
    }

    public static void setEditorForNetwork(CyNetwork net, CytoscapeEditor editor) {
        editorNetworkMap.put(net, editor);
    }

    public static CytoscapeEditor getEditorForView(CyNetworkView view) {
        Object obj = editorViewMap.get(view);
        if (obj != null && obj instanceof CytoscapeEditor) {
            return (CytoscapeEditor)obj;
        }
        return null;
    }

    public static ShapePalette getShapePaletteForView(CyNetworkView view) {
        return (ShapePalette)viewShapePaletteMap.get(view);
    }

    public static void setShapePaletteForView(CyNetworkView view, ShapePalette shape) {
        viewShapePaletteMap.put(view, shape);
    }

    public static String getVisualStyleForEditorType(String editorType) {
        Object obj = editorTypeVisualStyleNameMap.get(editorType);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static void setVisualStyleNameForEditorType(String editorType, String vizStyle) {
        editorTypeVisualStyleNameMap.put(editorType, vizStyle);
    }

    public static CytoscapeEditor getEditorForVisualStyle(VisualStyle style) {
        return (CytoscapeEditor)visualStyleEditorMap.get(style);
    }

    public static void setEditorForVisualStyle(VisualStyle style, CytoscapeEditor editor) {
        visualStyleEditorMap.put(style, editor);
    }

    public static String getEditorTypeForVisualStyleName(String styleName) {
        Object editorType = visualStyleNameEditorTypeMap.get(styleName);
        if (editorType != null) {
            return editorType.toString();
        }
        return null;
    }

    public static void setEditorTypeForVisualStyleName(String styleName, String editorType) {
        visualStyleNameEditorTypeMap.put(styleName, editorType);
    }

    public static int[] getHiddenNodesForNetwork(CyNetwork net) {
        List hiddenNodesList = (List)networkHiddenNodesMap.get(net);
        if (hiddenNodesList == null) {
            return new int[0];
        }
        int[] nodeIndices = new int[hiddenNodesList.size()];
        for (int i = 0; i < hiddenNodesList.size(); ++i) {
            nodeIndices[i] = (Integer)hiddenNodesList.get(i);
        }
        return nodeIndices;
    }

    public static int[] getHiddenEdgesForNetwork(CyNetwork net) {
        List hiddenEdgesList = (List)networkHiddenEdgesMap.get(net);
        if (hiddenEdgesList == null) {
            return new int[0];
        }
        int[] edgeIndices = new int[hiddenEdgesList.size()];
        for (int i = 0; i < hiddenEdgesList.size(); ++i) {
            edgeIndices[i] = (Integer)hiddenEdgesList.get(i);
        }
        return edgeIndices;
    }

    public static void addHiddenNodeForNetwork(CyNetwork net, int nodeIdx) {
        ArrayList<Integer> hiddenNodesList = (ArrayList<Integer>)networkHiddenNodesMap.get(net);
        if (hiddenNodesList == null) {
            hiddenNodesList = new ArrayList<Integer>();
        }
        hiddenNodesList.add(new Integer(nodeIdx));
        networkHiddenNodesMap.put(net, hiddenNodesList);
    }

    public static void addHiddenEdgeForNetwork(CyNetwork net, int edgeIdx) {
        ArrayList<Integer> hiddenEdgesList = (ArrayList<Integer>)networkHiddenEdgesMap.get(net);
        if (hiddenEdgesList == null) {
            hiddenEdgesList = new ArrayList<Integer>();
        }
        hiddenEdgesList.add(new Integer(edgeIdx));
        networkHiddenEdgesMap.put(net, hiddenEdgesList);
    }

    public static String getControllingNodeAttribute(CytoscapeEditor editor) {
        String editorName = editor.getEditorName();
        Object obj = editorControllingNodeAttributeMap.get(editorName);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static String getControllingEdgeAttribute(CytoscapeEditor editor) {
        System.out.println("get controlling edge attribute for editor: " + editor);
        String editorName = editor.getEditorName();
        Object obj = editorControllingEdgeAttributeMap.get(editorName);
        System.out.println("returned: " + obj);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static void setControllingNodeAttribute(String editorName, String attribute) {
        editorControllingNodeAttributeMap.put(editorName, attribute);
    }

    public static void setControllingEdgeAttribute(String editorName, String attribute) {
        System.out.println("Setting controlling edge attribute: " + attribute + " for editor: " + editorName);
        editorControllingEdgeAttributeMap.put(editorName, attribute);
    }

    public static void setEditorForView(CyNetworkView view, CytoscapeEditor editor) {
        editorViewMap.put(view, editor);
    }

    public static UndoManager getUndoManagerForView(CyNetworkView view) {
        Object obj = undoManagerViewMap.get(view);
        if (obj != null && obj instanceof UndoManager) {
            return (UndoManager)obj;
        }
        return null;
    }

    public static void setUndoManagerForView(CyNetworkView view, UndoManager undo) {
        undoManagerViewMap.put(view, undo);
    }

    public static void setUndoActionForView(CyNetworkView view, UndoAction undo) {
        undoActionViewMap.put(view, undo);
    }

    public static UndoAction getUndoActionForView(CyNetworkView view) {
        Object obj = undoActionViewMap.get(view);
        if (obj != null && obj instanceof UndoAction) {
            return (UndoAction)obj;
        }
        return null;
    }

    public static RedoAction getRedoActionForView(CyNetworkView view) {
        Object obj = redoActionViewMap.get(view);
        if (obj != null && obj instanceof RedoAction) {
            return (RedoAction)obj;
        }
        return null;
    }

    public static void setRedoActionForView(CyNetworkView view, RedoAction redo) {
        redoActionViewMap.put(view, redo);
    }

    public static void addEdit(UndoableEdit edit) {
        Cytoscape.getDesktop();
        CytoscapeDesktop.undo.addEdit(edit);
    }

    public static String getNetworkClipBoard() {
        return networkClipBoard;
    }

    public static void setNetworkClipBoard(String id) {
        networkClipBoard = id;
    }

    public static IntArrayList getNodeClipBoard() {
        if (nodeClipBoard == null) {
            nodeClipBoard = new IntArrayList();
        }
        return nodeClipBoard;
    }

    public static IntArrayList getEdgeClipBoard() {
        if (edgeClipBoard == null) {
            edgeClipBoard = new IntArrayList();
        }
        return edgeClipBoard;
    }

    public static int getNetworkNameCounter() {
        return networkNameCounter;
    }

    public static void incrementNetworkNameCounter() {
        ++networkNameCounter;
    }

    public static CytoscapeEditor getCurrentEditor() {
        return currentEditor;
    }

    public static void setCurrentEditor(CytoscapeEditor currentEditor) {
        CytoscapeEditorManager.currentEditor = currentEditor;
    }

    public static float getDefaultBorderWidth() {
        return defaultBorderWidth;
    }

    public static void setDefaultBorderWidth(float defaultBorderWidth) {
        CytoscapeEditorManager.defaultBorderWidth = defaultBorderWidth;
    }

    public static boolean isRunningEditorFramework() {
        return runningEditorFramework;
    }

    public static void setRunningEditorFramework(boolean runningEditorFramework) {
        CytoscapeEditorManager.runningEditorFramework = runningEditorFramework;
    }

    public static UndoManager getCurrentUndoManager() {
        return CytoscapeEditorManager.getUndoManagerForView(Cytoscape.getCurrentNetworkView());
    }

    public static void setCurrentUndoManager(UndoManager currentUndoManager) {
        CytoscapeEditorManager.currentUndoManager = currentUndoManager;
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        if (view != null) {
            CytoscapeEditorManager.setUndoManagerForView(view, currentUndoManager);
        }
    }

    public static boolean isEditingEnabled() {
        return editingEnabled;
    }

    public static void setEditingEnabled(boolean editingEnabled) {
        CytoscapeEditorManager.editingEnabled = editingEnabled;
    }

    public static ShapePalette getCurrentShapePalette() {
        return currentShapePalette;
    }

    public static void setCurrentShapePalette(ShapePalette currentShapePalette) {
        CytoscapeEditorManager.currentShapePalette = currentShapePalette;
    }

    public static CytoscapeEditor getDefaultEditor() {
        return defaultEditor;
    }

    public static void setDefaultEditor(CytoscapeEditor defaultEditor) {
        CytoscapeEditorManager.defaultEditor = defaultEditor;
    }

    public static boolean isSettingUpEditor() {
        return settingUpEditor;
    }

    public static void setSettingUpEditor(boolean settingUpEditor) {
        CytoscapeEditorManager.settingUpEditor = settingUpEditor;
    }

    public static void resetAttributes(String oldId, String newId, CyAttributes attrs) {
        String[] attrNames = attrs.getAttributeNames();
        for (int i = 0; i < attrNames.length; ++i) {
            byte type = attrs.getType(attrNames[i]);
            if (!attrs.hasAttribute(oldId, attrNames[i])) continue;
            if (type == -2) {
                List l = attrs.getAttributeList(oldId, attrNames[i]);
                if (l == null || l.size() <= 0) continue;
                attrs.setAttributeList(newId, attrNames[i], l);
                continue;
            }
            if (type == -3) {
                Map m = attrs.getAttributeMap(oldId, attrNames[i]);
                if (m == null) continue;
                attrs.setAttributeMap(newId, attrNames[i], m);
                continue;
            }
            if (type == 1) {
                attrs.setAttribute(newId, attrNames[i], attrs.getBooleanAttribute(oldId, attrNames[i]));
                continue;
            }
            if (type == 3) {
                attrs.setAttribute(newId, attrNames[i], attrs.getIntegerAttribute(oldId, attrNames[i]));
                continue;
            }
            if (type == 2) {
                attrs.setAttribute(newId, attrNames[i], attrs.getDoubleAttribute(oldId, attrNames[i]));
                continue;
            }
            if (type != 4) continue;
            attrs.setAttribute(newId, attrNames[i], attrs.getStringAttribute(oldId, attrNames[i]));
        }
    }

    static {
        defaultBorderWidth = Float.NaN;
        currentEditor = null;
        runningEditorFramework = false;
        settingUpEditor = false;
        editorViewMap = new HashMap();
        editingEnabled = false;
        undoManagerViewMap = new HashMap();
        undoActionViewMap = new HashMap();
        redoActionViewMap = new HashMap();
        editorNetworkMap = new HashMap();
        editorTypeEventAdapterMap = new HashMap();
        viewNetworkEditEventAdapterMap = new HashMap();
        editorControllingNodeAttributeMap = new HashMap();
        editorControllingEdgeAttributeMap = new HashMap();
        networkNameCounter = 0;
        editorTypeVisualStyleNameMap = new HashMap();
        viewShapePaletteMap = new HashMap();
        visualStyleEditorMap = new HashMap();
        visualStyleNameEditorTypeMap = new HashMap();
        networkHiddenNodesMap = new HashMap();
        networkHiddenEdgesMap = new HashMap();
        nodeAttribs = Cytoscape.getNodeAttributes();
        edgeAttribs = Cytoscape.getEdgeAttributes();
    }
}

