/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class NeighborNodeSelection
extends CytoscapePlugin {
    public NeighborNodeSelection() {
        NeighborNodeSelectionAction neighborNodeSelectionAction = new NeighborNodeSelectionAction();
        neighborNodeSelectionAction.setPreferredMenu("Plugins");
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)neighborNodeSelectionAction);
    }

    public String describe() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("For every currently selected node in the graph view, this ");
        stringBuffer.append("plugin additionally selects each neighbor of that node if ");
        stringBuffer.append("the canonical names of the two nodes have the same last letter.");
        return stringBuffer.toString();
    }

    public class NeighborNodeSelectionAction
    extends CytoscapeAction {
        public NeighborNodeSelectionAction() {
            super("NeighborNodeSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CyNode cyNode;
            NodeView nodeView;
            CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
            CyNetworkView cyNetworkView = Cytoscape.getCurrentNetworkView();
            if (cyNetwork == null || cyNetworkView == null) {
                return;
            }
            if (cyNetworkView.getSelectedNodes().size() == 0) {
                JOptionPane.showMessageDialog(cyNetworkView.getComponent(), "Please select one or more nodes.");
            }
            HashSet<NodeView> hashSet = new HashSet<NodeView>();
            Iterator iterator = cyNetworkView.getSelectedNodes().iterator();
            while (iterator.hasNext()) {
                nodeView = (NodeView)iterator.next();
                cyNode = (CyNode)nodeView.getNode();
                List list = cyNetwork.neighborsList((Node)cyNode);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    CyNode cyNode2 = (CyNode)iterator2.next();
                    NodeView nodeView2 = cyNetworkView.getNodeView((Node)cyNode2);
                    hashSet.add(nodeView2);
                }
            }
            nodeView = hashSet.iterator();
            while (nodeView.hasNext()) {
                cyNode = (NodeView)nodeView.next();
                cyNode.setSelected(true);
            }
            cyNetworkView.redrawGraph(false, true);
        }

        private String getLastLetter(CyNetwork cyNetwork, CyNode cyNode) {
            String string = (String)cyNetwork.getNodeAttributeValue((Node)cyNode, "canonicalName");
            if (string == null || string.length() == 0) {
                return null;
            }
            int n = string.length();
            String string2 = string.substring(n - 1);
            return string2;
        }
    }
}

