/*
	
	MultiLevelLayoutPlugin for Cytoscape (http://www.cytoscape.org/) 
	Copyright (C) 2007 Pekka Salmela

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	
 */

package multilevelLayoutPlugin;

/**
 * Configuration class for the multilevel layout algorithm.
 * @author Pekka Salmela
 *
 */
public class MultilevelConfig {
	/**
	 * Constant multiplier used in calculation of repulsive forces.
	 */
	public static double C = 0.2;
	
	/**
	 * Constant multiplier used in calculation of attractive forces.
	 */
	public static double A = 1.0;
	
	/**
	 * Constant multiplier used in calculating the cooling schedule.
	 */
	public static double T = 0.9;
	
	/**
	 * Cooling parameter.
	 */
	public static double tolerance = 0.01;
}