/*
 * Decompiled with CFR 0.152.
 */
package multilevelLayoutPlugin;

import java.awt.geom.Point2D;
import java.util.HashMap;

public class NodePositionManager {
    private HashMap<Integer, Point2D> positions;

    public NodePositionManager() {
        this.positions = new HashMap();
    }

    public NodePositionManager(int initialCapacity) throws IllegalArgumentException {
        this.positions = new HashMap(initialCapacity);
    }

    public void addNode(int id, double x, double y) throws IllegalStateException {
        if (x == Double.NaN || y == Double.NaN) {
            throw new IllegalStateException();
        }
        this.positions.put(new Integer(id), new Point2D.Double(x, y));
    }

    public void setPosition(int id, double x, double y) throws NullPointerException, IllegalStateException {
        if (x == Double.NaN || y == Double.NaN) {
            throw new IllegalStateException();
        }
        this.positions.get(new Integer(id)).setLocation(x, y);
    }

    public void setX(int id, double x) throws NullPointerException, IllegalStateException {
        if (x == Double.NaN) {
            throw new IllegalStateException();
        }
        Point2D node = this.positions.get(new Integer(id));
        node.setLocation(x, node.getY());
    }

    public void setY(int id, double y) throws NullPointerException, IllegalStateException {
        if (y == Double.NaN) {
            throw new IllegalStateException();
        }
        Point2D node = this.positions.get(new Integer(id));
        node.setLocation(node.getX(), y);
    }

    public double getX(int id) throws NullPointerException {
        return this.positions.get(new Integer(id)).getX();
    }

    public double getY(int id) throws NullPointerException {
        return this.positions.get(new Integer(id)).getY();
    }

    public void removeNode(int id) {
        this.positions.remove(new Integer(id));
    }
}

