/*
 * Decompiled with CFR 0.152.
 */
package multilevelLayoutPlugin;

import csplugins.layout.AbstractLayout;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.NodeView;
import java.util.Iterator;
import java.util.Vector;
import multilevelLayoutPlugin.EnhancedForceDirectedLayout;
import multilevelLayoutPlugin.MaximalIndependentSetFinder;
import multilevelLayoutPlugin.NodePositionManager;

public class MultilevelLayout
extends AbstractLayout {
    private NodePositionManager posManager;
    private double level;
    protected TaskMonitor taskMonitor;
    protected boolean cancel = false;

    public MultilevelLayout(CyNetworkView networkView) {
        super(networkView);
    }

    public Object construct() {
        this.taskMonitor.setStatus("Initializing");
        this.initialize();
        this.layout();
        this.networkView.fitContent();
        this.networkView.updateView();
        return null;
    }

    public void setTaskMonitor(TaskMonitor t) {
        this.taskMonitor = t;
    }

    public void setCancel() {
        this.cancel = true;
    }

    protected void initialize_local() {
        this.posManager = new NodePositionManager(this.networkView.getNetwork().getNodeCount());
        this.level = 0.0;
    }

    public void layout() {
        Node n;
        long start = System.currentTimeMillis();
        CyNetwork cn = this.networkView.getNetwork();
        if (this.cancel) {
            return;
        }
        this.taskMonitor.setStatus("Finding independent sets...");
        this.taskMonitor.setPercentCompleted(5);
        Vector<CyNetwork> networkSet = new Vector<CyNetwork>((int)Math.sqrt(cn.getNodeCount()), 5);
        networkSet.add(cn);
        boolean goOn = true;
        int nodeCount = cn.getNodeCount();
        while (goOn) {
            CyNetwork next = MaximalIndependentSetFinder.findMaximalIndependentSet((CyNetwork)networkSet.lastElement(), this.level);
            if (nodeCount != next.getNodeCount()) {
                nodeCount = next.getNodeCount();
                if (nodeCount == 2) {
                    goOn = false;
                }
                networkSet.add(next);
                this.level += 1.0;
                continue;
            }
            goOn = false;
        }
        if (this.cancel) {
            int i = 1;
            while (i < networkSet.size()) {
                Cytoscape.destroyNetwork((CyNetwork)((CyNetwork)networkSet.elementAt(i)));
                ++i;
            }
            return;
        }
        this.taskMonitor.setStatus("Calculating the layout...");
        this.taskMonitor.setPercentCompleted(10);
        CyNetwork currentNetwork = null;
        double previousNaturalSpringLength = 0.0;
        while (networkSet.size() > 1) {
            CyNode n2;
            if (this.cancel) {
                int i = 1;
                while (i < networkSet.size()) {
                    Cytoscape.destroyNetwork((CyNetwork)((CyNetwork)networkSet.elementAt(i)));
                    ++i;
                }
                return;
            }
            this.level -= 1.0;
            this.taskMonitor.setStatus("Calculating the layout on level " + (int)this.level + "...");
            this.taskMonitor.setPercentCompleted((int)(80.0 / (this.level + 2.0) + 10.0));
            if (currentNetwork == null) {
                currentNetwork = (CyNetwork)networkSet.lastElement();
                double max = 10.0 / Math.pow(Math.sqrt(0.5714285714285714), this.level + 1.0);
                Iterator iter = currentNetwork.nodesIterator();
                n2 = (CyNode)iter.next();
                this.posManager.addNode(n2.getRootGraphIndex(), max, 0.0);
                n2 = (CyNode)iter.next();
                this.posManager.addNode(n2.getRootGraphIndex(), 0.0, max);
                previousNaturalSpringLength = Math.sqrt(2.0) * max;
            }
            CyNetwork nextNetwork = (CyNetwork)networkSet.elementAt(networkSet.size() - 2);
            this.doOneLevelPlacement(currentNetwork, nextNetwork, previousNaturalSpringLength);
            EnhancedForceDirectedLayout e = new EnhancedForceDirectedLayout(previousNaturalSpringLength, this.level, nextNetwork, this.posManager);
            e.doLayout();
            previousNaturalSpringLength = e.getK();
            networkSet.remove(networkSet.size() - 1);
            Iterator i1 = currentNetwork.nodesIterator();
            while (i1.hasNext()) {
                n2 = (CyNode)i1.next();
                this.posManager.removeNode(n2.getRootGraphIndex());
                Cytoscape.getRootGraph().removeNode((Node)n2);
            }
            Iterator i2 = currentNetwork.edgesIterator();
            while (i2.hasNext()) {
                Cytoscape.getRootGraph().removeEdge((Edge)i2.next());
            }
            currentNetwork = nextNetwork;
        }
        this.taskMonitor.setStatus("Updating node positions...");
        this.taskMonitor.setPercentCompleted(95);
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        Iterator iter = currentNetwork.nodesIterator();
        while (iter.hasNext()) {
            n = (Node)iter.next();
            if (this.posManager.getX(n.getRootGraphIndex()) < minX) {
                minX = this.posManager.getX(n.getRootGraphIndex());
            }
            if (this.posManager.getY(n.getRootGraphIndex()) < minY) {
                minY = this.posManager.getY(n.getRootGraphIndex());
            }
            if (this.posManager.getX(n.getRootGraphIndex()) > maxX) {
                maxX = this.posManager.getX(n.getRootGraphIndex());
            }
            if (!(this.posManager.getY(n.getRootGraphIndex()) > maxY)) continue;
            maxY = this.posManager.getY(n.getRootGraphIndex());
        }
        iter = currentNetwork.nodesIterator();
        while (iter.hasNext()) {
            n = (Node)iter.next();
            this.posManager.setX(n.getRootGraphIndex(), 300.0 * Math.sqrt(currentNetwork.getNodeCount()) * (this.posManager.getX(n.getRootGraphIndex()) - minX) / (maxX - minX));
            this.posManager.setY(n.getRootGraphIndex(), 300.0 * Math.sqrt(currentNetwork.getNodeCount()) * (this.posManager.getY(n.getRootGraphIndex()) - minY) / (maxY - minY));
        }
        this.taskMonitor.setStatus("Laying out the graph...");
        this.taskMonitor.setPercentCompleted(99);
        CyNetworkView finalView = Cytoscape.getCurrentNetworkView();
        iter = currentNetwork.nodesIterator();
        while (iter.hasNext()) {
            Node n3 = (Node)iter.next();
            NodeView nv = finalView.getNodeView(n3);
            nv.setXPosition(this.posManager.getX(n3.getRootGraphIndex()));
            nv.setYPosition(this.posManager.getY(n3.getRootGraphIndex()));
        }
        networkSet = null;
        this.posManager = null;
        System.out.println("Calculating the layout took " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds.");
        this.taskMonitor.setStatus("Layout complete");
        this.taskMonitor.setPercentCompleted(100);
    }

    private void doOneLevelPlacement(CyNetwork coarser, CyNetwork finer, double k) {
        Iterator nodesIterator = coarser.nodesIterator();
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        while (nodesIterator.hasNext()) {
            CyNode n = (CyNode)nodesIterator.next();
            double nX = this.posManager.getX(n.getRootGraphIndex());
            double nY = this.posManager.getY(n.getRootGraphIndex());
            if (nodesAttributes.getIntegerAttribute(n.getIdentifier(), "ml_previous") != null) {
                Integer pre = nodesAttributes.getIntegerAttribute(n.getIdentifier(), "ml_previous");
                this.posManager.addNode(pre, nX, nY);
                continue;
            }
            Integer anc1 = nodesAttributes.getIntegerAttribute(n.getIdentifier(), "ml_ancestor1");
            Integer anc2 = nodesAttributes.getIntegerAttribute(n.getIdentifier(), "ml_ancestor2");
            this.posManager.addNode(anc1, nX, nY);
            this.posManager.addNode(anc2, nX + this.plusOrMinusOne() * 0.001 * k, nY + this.plusOrMinusOne() * 0.001 * k);
        }
    }

    private double plusOrMinusOne() {
        if (Math.random() < 0.5) {
            return 1.0;
        }
        return -1.0;
    }
}

