/*
 * Decompiled with CFR 0.152.
 */
package multilevelLayoutPlugin;

import cytoscape.CyNetwork;
import giny.model.Edge;
import giny.model.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ClusteringCoefficientManager {
    private CyNetwork network;
    private HashMap<Integer, Double> ccValues;

    public ClusteringCoefficientManager(CyNetwork network) {
        this.network = network;
        this.ccValues = new HashMap();
    }

    public void setAllCCs() {
        if (this.network == null) {
            return;
        }
        Iterator iter = this.network.nodesIterator();
        HashSet<Node> checked = new HashSet<Node>();
        HashSet<Node> neighbours = new HashSet<Node>();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            int[] adjacentEdges = this.network.getAdjacentEdgeIndicesArray(n.getRootGraphIndex(), true, true, true);
            neighbours.clear();
            int i = 0;
            while (i < adjacentEdges.length) {
                Edge e = this.network.getEdge(adjacentEdges[i]);
                if (e.getSource() != n) {
                    neighbours.add(e.getSource());
                }
                if (e.getTarget() != n) {
                    neighbours.add(e.getTarget());
                }
                ++i;
            }
            double numberOfNeighbours = neighbours.size();
            if (numberOfNeighbours > 1.0) {
                double links = 0.0;
                checked.clear();
                for (Node m : neighbours) {
                    int[] adjacentEdges2 = this.network.getAdjacentEdgeIndicesArray(m.getRootGraphIndex(), true, true, true);
                    int i2 = 0;
                    while (i2 < adjacentEdges2.length) {
                        Node target;
                        Edge e = this.network.getEdge(adjacentEdges2[i2]);
                        Node source = e.getSource();
                        if (source != m && neighbours.contains(source) && !checked.contains(source)) {
                            links += 1.0;
                            checked.add(source);
                        }
                        if ((target = e.getTarget()) != m && neighbours.contains(target) && !checked.contains(target)) {
                            links += 1.0;
                            checked.add(target);
                        }
                        ++i2;
                    }
                }
                this.addCC(n.getRootGraphIndex(), links / (numberOfNeighbours * (numberOfNeighbours - 1.0)));
                continue;
            }
            this.addCC(n.getRootGraphIndex(), 0.0);
        }
    }

    private void addCC(int id, double x) throws IllegalStateException {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalStateException("Value tried was " + x);
        }
        this.ccValues.put(id, x);
    }

    public double getCC(int id) throws NullPointerException {
        return this.ccValues.get(id);
    }
}

