/*
 * Decompiled with CFR 0.152.
 */
package multilevelLayoutPlugin;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import multilevelLayoutPlugin.GraphConnectivityChecker;
import multilevelLayoutPlugin.MultilevelLayout;

public class MultilevelLayoutPlugin
extends CytoscapePlugin {
    public MultilevelLayoutPlugin() {
        MultilevelLayoutSelectionAction action = new MultilevelLayoutSelectionAction();
        action.setPreferredMenu("Plugins");
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)action);
    }

    public String describe() {
        StringBuffer sb = new StringBuffer();
        sb.append("Calculates a nice layout for the network using multilevel");
        sb.append("force-directed algorithm by C. Walshaw.");
        return sb.toString();
    }

    public class MultilevelLayoutSelectionAction
    extends CytoscapeAction
    implements Task {
        private TaskMonitor taskMonitor;
        private MultilevelLayout algObj;
        private CyNetwork network;
        private CyNetworkView view;
        private static final long serialVersionUID = -4840201619467047796L;
        private boolean ready;

        public MultilevelLayoutSelectionAction() {
            super("Multilevel Layout");
            this.ready = false;
        }

        public void actionPerformed(ActionEvent ae) {
            System.out.println("Start MultiLevelPlugin");
            this.network = Cytoscape.getCurrentNetwork();
            this.view = Cytoscape.getCurrentNetworkView();
            if (this.network == null || this.view == null) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "There was no graph or graph view available, layout calculation aborted.", "Error: No graph or graph view available", 0);
                return;
            }
            if (this.network.getNodeCount() == 0) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Current graph contains 0 nodes, calculation aborted.", "Error: Zero nodes in current graph", 0);
                return;
            }
            if (!GraphConnectivityChecker.graphIsConnected(this.network)) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "The graph is not connected. This version of MultiLevelLayout plugin only supports connected graphs.");
                return;
            }
            this.ready = true;
            JTaskConfig taskConfig = this.getNewDefaultTaskConfig();
            TaskManager.executeTask((Task)this, (JTaskConfig)taskConfig);
            CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
            nodesAttributes.deleteAttribute("ml_previous");
            nodesAttributes.deleteAttribute("ml_ancestor1");
            nodesAttributes.deleteAttribute("ml_ancestor2");
            nodesAttributes.deleteAttribute("ml_weight");
            nodesAttributes.deleteAttribute("mllp_partition");
            System.out.println("Stop MultiLevelPlugin");
        }

        public void run() {
            if (this.ready) {
                this.algObj = new MultilevelLayout(this.view);
                this.algObj.setTaskMonitor(this.taskMonitor);
                this.algObj.construct();
                this.algObj = null;
                System.gc();
            }
        }

        public void setTaskMonitor(TaskMonitor _monitor) {
            this.taskMonitor = _monitor;
        }

        public String getTitle() {
            return "Performing MultiLevelLayout";
        }

        public void halt() {
            this.algObj.setCancel();
        }

        private JTaskConfig getNewDefaultTaskConfig() {
            JTaskConfig result = new JTaskConfig();
            result.displayCancelButton(true);
            result.displayCloseButton(true);
            result.displayStatus(true);
            result.displayTimeElapsed(true);
            result.setAutoDispose(false);
            result.setModal(true);
            result.setOwner((Container)Cytoscape.getDesktop());
            return result;
        }
    }
}

