/*
 * Decompiled with CFR 0.152.
 */
package multilevelLayoutPlugin;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import giny.model.Edge;
import giny.model.Node;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import multilevelLayoutPlugin.MultilevelConfig;
import multilevelLayoutPlugin.NodePositionManager;

public class EnhancedForceDirectedLayout {
    private double k;
    private int R;
    private CyNetwork network;
    private NodePositionManager posManager;
    private double CTimesKSquared;

    public EnhancedForceDirectedLayout(double previousNaturalSpringLength, double level, CyNetwork network, NodePositionManager posManager) {
        this.k = Math.sqrt(0.5714285714285714) * previousNaturalSpringLength;
        this.R = (int)(2.0 * (level + 1.0) * this.k);
        this.network = network;
        this.posManager = posManager;
        this.CTimesKSquared = MultilevelConfig.C * this.k * this.k;
    }

    public void doLayout() {
        boolean converged = false;
        double t = this.k;
        int hashSize = (int)Math.sqrt(this.network.getNodeCount());
        HashMap xMapping = new HashMap(hashSize);
        HashMap yMapping = new HashMap(hashSize);
        HashSet<Node> neighboringNodesOfV = new HashSet<Node>();
        HashSet<Edge> edgesConnectedToV = new HashSet<Edge>();
        HashSet<Node> closeNodes = new HashSet<Node>(100);
        HashSet xPossible = new HashSet(150);
        HashSet yPossible = new HashSet(150);
        while (!converged) {
            int bucketY;
            int bucketX;
            converged = true;
            xMapping.clear();
            yMapping.clear();
            Iterator iterator = this.network.nodesIterator();
            while (iterator.hasNext()) {
                Node n = (Node)iterator.next();
                bucketX = (int)(Math.abs(this.posManager.getX(n.getRootGraphIndex())) / (double)this.R) % hashSize;
                bucketY = (int)(Math.abs(this.posManager.getY(n.getRootGraphIndex())) / (double)this.R) % hashSize;
                if (!xMapping.containsKey(new Integer(bucketX))) {
                    xMapping.put(new Integer(bucketX), new HashSet(hashSize));
                }
                ((HashSet)xMapping.get(new Integer(bucketX))).add(n);
                if (!yMapping.containsKey(new Integer(bucketY))) {
                    yMapping.put(new Integer(bucketY), new HashSet(hashSize));
                }
                ((HashSet)yMapping.get(new Integer(bucketY))).add(n);
            }
            iterator = this.network.nodesIterator();
            while (iterator.hasNext()) {
                double newY;
                double newX;
                double diffLength;
                Point2D.Double DiffVector;
                Node v = (Node)iterator.next();
                closeNodes.clear();
                xPossible.clear();
                yPossible.clear();
                bucketX = (int)(Math.abs(this.posManager.getX(v.getRootGraphIndex())) / (double)this.R) % hashSize;
                bucketY = (int)(Math.abs(this.posManager.getY(v.getRootGraphIndex())) / (double)this.R) % hashSize;
                if (bucketX == 0) {
                    if (xMapping.containsKey(new Integer(hashSize - 1))) {
                        xPossible.addAll((Collection)xMapping.get(hashSize - 1));
                    }
                    if (xMapping.containsKey(new Integer(0))) {
                        xPossible.addAll((Collection)xMapping.get(0));
                    }
                    if (xMapping.containsKey(new Integer(1))) {
                        xPossible.addAll((Collection)xMapping.get(1));
                    }
                } else if (bucketX == hashSize - 1) {
                    if (xMapping.containsKey(new Integer(hashSize - 2))) {
                        xPossible.addAll((Collection)xMapping.get(hashSize - 2));
                    }
                    if (xMapping.containsKey(new Integer(hashSize - 1))) {
                        xPossible.addAll((Collection)xMapping.get(hashSize - 1));
                    }
                    if (xMapping.containsKey(new Integer(0))) {
                        xPossible.addAll((Collection)xMapping.get(0));
                    }
                } else {
                    if (xMapping.containsKey(new Integer(bucketX - 1))) {
                        xPossible.addAll((Collection)xMapping.get(bucketX - 1));
                    }
                    if (xMapping.containsKey(new Integer(bucketX))) {
                        xPossible.addAll((Collection)xMapping.get(bucketX));
                    }
                    if (xMapping.containsKey(new Integer(bucketX + 1))) {
                        xPossible.addAll((Collection)xMapping.get(bucketX + 1));
                    }
                }
                if (bucketY == 0) {
                    if (yMapping.containsKey(new Integer(hashSize - 1))) {
                        yPossible.addAll((Collection)yMapping.get(hashSize - 1));
                    }
                    if (yMapping.containsKey(new Integer(0))) {
                        yPossible.addAll((Collection)yMapping.get(0));
                    }
                    if (yMapping.containsKey(new Integer(1))) {
                        yPossible.addAll((Collection)yMapping.get(1));
                    }
                } else if (bucketY == hashSize - 1) {
                    if (yMapping.containsKey(new Integer(hashSize - 2))) {
                        yPossible.addAll((Collection)yMapping.get(hashSize - 2));
                    }
                    if (yMapping.containsKey(new Integer(hashSize - 1))) {
                        yPossible.addAll((Collection)yMapping.get(hashSize - 1));
                    }
                    if (yMapping.containsKey(new Integer(0))) {
                        yPossible.addAll((Collection)yMapping.get(0));
                    }
                } else {
                    if (yMapping.containsKey(new Integer(bucketY - 1))) {
                        yPossible.addAll((Collection)yMapping.get(bucketY - 1));
                    }
                    if (yMapping.containsKey(new Integer(bucketY))) {
                        yPossible.addAll((Collection)yMapping.get(bucketY));
                    }
                    if (yMapping.containsKey(new Integer(bucketY + 1))) {
                        yPossible.addAll((Collection)yMapping.get(bucketY + 1));
                    }
                }
                for (Node n : xPossible) {
                    if (!yPossible.contains(n)) continue;
                    closeNodes.add(n);
                }
                Point2D.Double DispVector = new Point2D.Double(0.0, 0.0);
                CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
                for (Node u : closeNodes) {
                    if (u == v) continue;
                    DiffVector = EnhancedForceDirectedLayout.getDifferenceVector(u, v, this.posManager);
                    diffLength = EnhancedForceDirectedLayout.getVectorLength(DiffVector);
                    if (!(EnhancedForceDirectedLayout.getVectorLength(DiffVector) <= (double)this.R)) continue;
                    if (diffLength == 0.0) {
                        this.posManager.setPosition(u.getRootGraphIndex(), this.posManager.getX(u.getRootGraphIndex()) + this.plusOrMinusOne() * 0.001 * this.k, this.posManager.getY(u.getRootGraphIndex()) + this.plusOrMinusOne() * 0.001 * this.k);
                        DiffVector = EnhancedForceDirectedLayout.getDifferenceVector(u, v, this.posManager);
                        diffLength = EnhancedForceDirectedLayout.getVectorLength(DiffVector);
                    }
                    double uWeight = 1.0;
                    if (nodeAttributes.getIntegerAttribute(u.getIdentifier(), "ml_weight") != null) {
                        uWeight = nodeAttributes.getIntegerAttribute(u.getIdentifier(), "ml_weight").intValue();
                    }
                    double fRep = this.forceRepulsive(diffLength, uWeight);
                    newX = DispVector.getX() + DiffVector.getX() / diffLength * fRep;
                    newY = DispVector.getY() + DiffVector.getY() / diffLength * fRep;
                    DispVector.setLocation(newX, newY);
                }
                edgesConnectedToV.clear();
                int[] edgeIndices = this.network.getAdjacentEdgeIndicesArray(v.getRootGraphIndex(), true, true, true);
                int i = 0;
                while (i < edgeIndices.length) {
                    edgesConnectedToV.add(this.network.getEdge(edgeIndices[i]));
                    ++i;
                }
                neighboringNodesOfV.clear();
                for (Edge e : edgesConnectedToV) {
                    if (e.getSource() != v) {
                        neighboringNodesOfV.add(e.getSource());
                    }
                    if (e.getTarget() == v) continue;
                    neighboringNodesOfV.add(e.getTarget());
                }
                for (Node n : neighboringNodesOfV) {
                    DiffVector = EnhancedForceDirectedLayout.getDifferenceVector(n, v, this.posManager);
                    diffLength = EnhancedForceDirectedLayout.getVectorLength(DiffVector);
                    if (diffLength == 0.0) {
                        this.posManager.setPosition(n.getRootGraphIndex(), this.posManager.getX(n.getRootGraphIndex()) + this.plusOrMinusOne() * 0.001 * this.k, this.posManager.getY(n.getRootGraphIndex()) + this.plusOrMinusOne() * 0.001 * this.k);
                        DiffVector = EnhancedForceDirectedLayout.getDifferenceVector(n, v, this.posManager);
                        diffLength = EnhancedForceDirectedLayout.getVectorLength(DiffVector);
                    }
                    double fAttr = this.forceAttractive(diffLength);
                    newX = DispVector.getX() + DiffVector.getX() / diffLength * fAttr;
                    newY = DispVector.getY() + DiffVector.getY() / diffLength * fAttr;
                    DispVector.setLocation(newX, newY);
                }
                Point2D.Double vOldPosition = new Point2D.Double(this.posManager.getX(v.getRootGraphIndex()), this.posManager.getY(v.getRootGraphIndex()));
                double dispLength = EnhancedForceDirectedLayout.getVectorLength(DispVector);
                if (dispLength != 0.0) {
                    this.posManager.setX(v.getRootGraphIndex(), this.posManager.getX(v.getRootGraphIndex()) + DispVector.getX() / dispLength * Math.min(t, dispLength));
                    this.posManager.setY(v.getRootGraphIndex(), this.posManager.getY(v.getRootGraphIndex()) + DispVector.getY() / dispLength * Math.min(t, dispLength));
                }
                if (!(EnhancedForceDirectedLayout.getVectorLength(DiffVector = new Point2D.Double(vOldPosition.getX() - this.posManager.getX(v.getRootGraphIndex()), vOldPosition.getY() - this.posManager.getY(v.getRootGraphIndex()))) > this.k * MultilevelConfig.tolerance)) continue;
                converged = false;
            }
            t = this.cool(t);
        }
    }

    private static Point2D.Double getDifferenceVector(Node u, Node v, NodePositionManager pm) {
        return new Point2D.Double(pm.getX(u.getRootGraphIndex()) - pm.getX(v.getRootGraphIndex()), pm.getY(u.getRootGraphIndex()) - pm.getY(v.getRootGraphIndex()));
    }

    private static double getVectorLength(Point2D.Double p) {
        return p.distance(0.0, 0.0);
    }

    private double cool(double previous) {
        return MultilevelConfig.T * previous;
    }

    private double forceRepulsive(double x, double w) {
        if (x == Double.NaN) {
            throw new IllegalStateException("Parameter x was NaN");
        }
        if (x == 0.0) {
            throw new IllegalStateException("Parameter x was 0");
        }
        return -1.0 * (w * this.CTimesKSquared / x);
    }

    private double forceAttractive(double x) throws IllegalStateException {
        if (x == Double.NaN) {
            throw new IllegalStateException("Parameter x was NaN");
        }
        return MultilevelConfig.A * (x * x) / this.k;
    }

    public double getK() {
        return this.k;
    }

    private double plusOrMinusOne() {
        if (Math.random() < 0.5) {
            return 1.0;
        }
        return -1.0;
    }
}

