/*
 * Decompiled with CFR 0.152.
 */
package multilevelLayoutPlugin;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import giny.model.Edge;
import giny.model.Node;
import java.util.HashSet;
import java.util.Iterator;

public class MaximalIndependentSetFinder {
    public static CyNetwork findMaximalIndependentSet(CyNetwork previous, double level) {
        Iterator nodesIterator = previous.nodesIterator();
        Iterator edgesIterator = previous.edgesIterator();
        HashSet<CyNode> nodesList = new HashSet<CyNode>(previous.getNodeCount());
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        int[] empty = new int[]{};
        CyNetwork next = Cytoscape.getRootGraph().createNetwork(empty, empty);
        while (nodesIterator.hasNext()) {
            CyNode n = (CyNode)nodesIterator.next();
            next.addNode((Node)n);
            nodesList.add(n);
        }
        while (edgesIterator.hasNext()) {
            CyEdge e = (CyEdge)edgesIterator.next();
            if (e.getTarget() == e.getSource()) continue;
            next.addEdge((Edge)e);
        }
        while (!nodesList.isEmpty()) {
            CyEdge e;
            Iterator iteraattori = nodesList.iterator();
            Node pair1 = (Node)iteraattori.next();
            HashSet<Edge> edgesConnectedToPair1 = new HashSet<Edge>();
            int[] edgeIndices1 = next.getAdjacentEdgeIndicesArray(pair1.getRootGraphIndex(), true, true, true);
            int i = 0;
            while (i < edgeIndices1.length) {
                edgesConnectedToPair1.add(next.getEdge(edgeIndices1[i]));
                ++i;
            }
            HashSet<Node> potentialPairsForPair1 = new HashSet<Node>();
            HashSet<Node> neighboringNodesOfPair1 = new HashSet<Node>();
            for (Edge e2 : edgesConnectedToPair1) {
                if (e2.getSource() != pair1 && nodesList.contains(e2.getSource()) && !potentialPairsForPair1.contains(e2.getSource())) {
                    potentialPairsForPair1.add(e2.getSource());
                }
                if (e2.getSource() != pair1 && !neighboringNodesOfPair1.contains(e2.getSource())) {
                    neighboringNodesOfPair1.add(e2.getSource());
                }
                if (e2.getTarget() != pair1 && nodesList.contains(e2.getTarget()) && !potentialPairsForPair1.contains(e2.getTarget())) {
                    potentialPairsForPair1.add(e2.getTarget());
                }
                if (e2.getTarget() == pair1 || neighboringNodesOfPair1.contains(e2.getTarget())) continue;
                neighboringNodesOfPair1.add(e2.getTarget());
            }
            if (potentialPairsForPair1.isEmpty()) {
                CyNode newNode = Cytoscape.getCyNode((String)(String.valueOf(pair1.getIdentifier()) + "-" + (level + 1.0)), (boolean)true);
                nodesAttributes.setAttribute(newNode.getIdentifier(), "ml_previous", new Integer(pair1.getRootGraphIndex()));
                next.addNode((Node)newNode);
                nodesList.remove(pair1);
                next.removeNode(pair1.getRootGraphIndex(), false);
                for (Node n : neighboringNodesOfPair1) {
                    CyEdge e3 = Cytoscape.getCyEdge((Node)n, (Node)newNode, (String)"interaction", (Object)"", (boolean)true, (boolean)false);
                    next.addEdge((Edge)e3);
                }
                for (Edge e4 : edgesConnectedToPair1) {
                    next.removeEdge(e4.getRootGraphIndex(), false);
                }
                continue;
            }
            Node pair2 = null;
            int nWeight = 1;
            int pair2Weight = 1;
            for (Node n : potentialPairsForPair1) {
                if (pair2 == null) {
                    pair2 = n;
                    continue;
                }
                if (nodesAttributes.getIntegerAttribute(n.getIdentifier(), "ml_weight") != null) {
                    nWeight = nodesAttributes.getIntegerAttribute(n.getIdentifier(), "ml_weight");
                }
                if (nodesAttributes.getIntegerAttribute(pair2.getIdentifier(), "ml_weight") != null) {
                    pair2Weight = nodesAttributes.getIntegerAttribute(pair2.getIdentifier(), "ml_weight");
                }
                if (nWeight + next.getDegree(n) >= pair2Weight + next.getDegree(pair2)) continue;
                pair2 = n;
            }
            HashSet<Edge> edgesConnectedToPair2 = new HashSet<Edge>();
            int[] edgeIndices2 = next.getAdjacentEdgeIndicesArray(pair2.getRootGraphIndex(), true, true, true);
            int i2 = 0;
            while (i2 < edgeIndices2.length) {
                edgesConnectedToPair2.add(next.getEdge(edgeIndices2[i2]));
                ++i2;
            }
            HashSet<Node> neighboringNodesOfPair2 = new HashSet<Node>();
            for (Edge e5 : edgesConnectedToPair2) {
                if (e5.getSource() != pair1 & e5.getSource() != pair2) {
                    neighboringNodesOfPair2.add(e5.getSource());
                }
                if (!(e5.getTarget() != pair1 & e5.getTarget() != pair2)) continue;
                neighboringNodesOfPair2.add(e5.getTarget());
            }
            for (Edge e5 : edgesConnectedToPair1) {
                next.removeEdge(e5.getRootGraphIndex(), false);
            }
            for (Edge e5 : edgesConnectedToPair2) {
                next.removeEdge(e5.getRootGraphIndex(), false);
            }
            nodesList.remove(pair1);
            nodesList.remove(pair2);
            next.removeNode(pair1.getRootGraphIndex(), false);
            next.removeNode(pair2.getRootGraphIndex(), false);
            CyNode combinedNode = Cytoscape.getCyNode((String)(String.valueOf(pair1.getIdentifier()) + "+" + pair2.getIdentifier()), (boolean)true);
            int weight1 = 1;
            int weight2 = 1;
            if (nodesAttributes.getIntegerAttribute(pair1.getIdentifier(), "ml_weight") != null) {
                weight1 = nodesAttributes.getIntegerAttribute(pair1.getIdentifier(), "ml_weight");
            }
            if (nodesAttributes.getIntegerAttribute(pair2.getIdentifier(), "ml_weight") != null) {
                weight2 = nodesAttributes.getIntegerAttribute(pair2.getIdentifier(), "ml_weight");
            }
            nodesAttributes.setAttribute(combinedNode.getIdentifier(), "ml_weight", new Integer(weight1 + weight2));
            nodesAttributes.setAttribute(combinedNode.getIdentifier(), "ml_ancestor1", new Integer(pair1.getRootGraphIndex()));
            nodesAttributes.setAttribute(combinedNode.getIdentifier(), "ml_ancestor2", new Integer(pair2.getRootGraphIndex()));
            next.addNode((Node)combinedNode);
            neighboringNodesOfPair1.remove(pair2);
            for (Node n : neighboringNodesOfPair1) {
                e = Cytoscape.getCyEdge((Node)n, (Node)combinedNode, (String)"interaction", (Object)"", (boolean)true, (boolean)false);
                next.addEdge((Edge)e);
            }
            neighboringNodesOfPair2.remove(pair1);
            for (Node n : neighboringNodesOfPair2) {
                e = Cytoscape.getCyEdge((Node)n, (Node)combinedNode, (String)"interaction", (Object)"", (boolean)true, (boolean)false);
                next.addEdge((Edge)e);
            }
        }
        return next;
    }
}

