/*
 * Decompiled with CFR 0.152.
 */
package csplugins.mac;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import cytoscape.data.FlagFilter;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import giny.model.Edge;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MultiNetworkNodeSelection
extends CytoscapePlugin
implements PropertyChangeListener,
GraphPerspectiveChangeListener,
FlagEventListener {
    CytoscapeAction activateAction = new ActivateMultiNetworkNodeSelectionAction();
    CytoscapeAction deactivateAction;
    boolean working = false;

    public MultiNetworkNodeSelection() {
        this.activateAction.setPreferredMenu("Plugins");
        this.deactivateAction = new DeactivateMultiNetworkNodeSelectionAction();
        this.deactivateAction.setPreferredMenu("Plugins");
        Cytoscape.getDesktop().getCyMenus().addAction(this.activateAction);
        Cytoscape.getDesktop().getCyMenus().addAction(this.deactivateAction);
        this.activateNetworkLinker();
    }

    public void activateNetworkLinker() {
        Set set = this.getAllFlaggedNodes();
        Set set2 = this.getAllFlaggedEdges();
        Iterator iterator = Cytoscape.getNetworkSet().iterator();
        while (iterator.hasNext()) {
            CyNetwork cyNetwork = (CyNetwork)iterator.next();
            cyNetwork.setFlaggedNodes((Collection)set, true);
            cyNetwork.setFlaggedEdges((Collection)set2, true);
            cyNetwork.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
            cyNetwork.addFlagEventListener((FlagEventListener)this);
        }
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.activateAction.setEnabled(false);
        this.deactivateAction.setEnabled(true);
    }

    public void deactivateNetworkLinker() {
        Iterator iterator = Cytoscape.getNetworkSet().iterator();
        while (iterator.hasNext()) {
            CyNetwork cyNetwork = (CyNetwork)iterator.next();
            cyNetwork.removeGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
            cyNetwork.removeFlagEventListener((FlagEventListener)this);
        }
        Cytoscape.getSwingPropertyChangeSupport().removePropertyChangeListener(this);
        this.activateAction.setEnabled(true);
        this.deactivateAction.setEnabled(false);
    }

    public Set getAllFlaggedNodes() {
        HashSet hashSet = new HashSet();
        Iterator iterator = Cytoscape.getNetworkSet().iterator();
        while (iterator.hasNext()) {
            CyNetwork cyNetwork = (CyNetwork)iterator.next();
            Set set = cyNetwork.getFlaggedNodes();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public Set getAllFlaggedEdges() {
        HashSet hashSet = new HashSet();
        Iterator iterator = Cytoscape.getNetworkSet().iterator();
        while (iterator.hasNext()) {
            CyNetwork cyNetwork = (CyNetwork)iterator.next();
            Set set = cyNetwork.getFlaggedEdges();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == Cytoscape.NETWORK_CREATED) {
            String string = (String)propertyChangeEvent.getNewValue();
            CyNetwork cyNetwork = Cytoscape.getNetwork((String)string);
            if (cyNetwork != null) {
                Set set = this.getAllFlaggedNodes();
                cyNetwork.setFlaggedNodes((Collection)set, true);
                Set set2 = this.getAllFlaggedEdges();
                cyNetwork.setFlaggedEdges((Collection)set2, true);
                cyNetwork.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
                cyNetwork.addFlagEventListener((FlagEventListener)this);
            } else {
                String string2 = System.getProperty("line.separator");
                String string3 = "In MultiNetworkNodeSelection.propertyChange: " + string2 + "  unexpected null network processing NETWORK_CREATED event";
                System.err.println(string3);
            }
        }
    }

    public void onFlagEvent(FlagEvent flagEvent) {
        if (this.working) {
            return;
        }
        this.working = true;
        FlagFilter flagFilter = flagEvent.getSource();
        Iterator iterator = Cytoscape.getNetworkSet().iterator();
        while (iterator.hasNext()) {
            CyNetwork cyNetwork = (CyNetwork)iterator.next();
            FlagFilter flagFilter2 = cyNetwork.getFlagger();
            if (flagFilter == flagFilter2) continue;
            this.handleFlagEvent(flagEvent, cyNetwork);
        }
        this.working = false;
    }

    private void handleFlagEvent(FlagEvent flagEvent, CyNetwork cyNetwork) {
        boolean bl = flagEvent.getEventType();
        if (flagEvent.getTargetType() == 0) {
            cyNetwork.setFlagged((Node)flagEvent.getTarget(), bl);
        } else if (flagEvent.getTargetType() == 1) {
            cyNetwork.setFlagged((Edge)flagEvent.getTarget(), bl);
        } else if (flagEvent.getTargetType() == 2) {
            cyNetwork.setFlaggedNodes((Collection)((Set)flagEvent.getTarget()), bl);
        } else if (flagEvent.getTargetType() == 3) {
            cyNetwork.setFlaggedEdges((Collection)((Set)flagEvent.getTarget()), bl);
        }
    }

    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent graphPerspectiveChangeEvent) {
        CyNetwork cyNetwork;
        Iterator iterator;
        Node node;
        int n;
        Node[] nodeArray;
        this.working = true;
        CyNetwork cyNetwork2 = (CyNetwork)graphPerspectiveChangeEvent.getSource();
        if (graphPerspectiveChangeEvent.isNodesRestoredType()) {
            nodeArray = graphPerspectiveChangeEvent.getRestoredNodes();
            block0: for (n = 0; n < nodeArray.length; ++n) {
                node = nodeArray[n];
                iterator = Cytoscape.getNetworkSet().iterator();
                while (iterator.hasNext()) {
                    cyNetwork = (CyNetwork)iterator.next();
                    if (cyNetwork == cyNetwork2 || !cyNetwork.isFlagged(node)) continue;
                    cyNetwork2.setFlagged(node, true);
                    continue block0;
                }
            }
        }
        if (graphPerspectiveChangeEvent.isEdgesRestoredType()) {
            nodeArray = graphPerspectiveChangeEvent.getRestoredEdges();
            block2: for (n = 0; n < nodeArray.length; ++n) {
                node = nodeArray[n];
                iterator = Cytoscape.getNetworkSet().iterator();
                while (iterator.hasNext()) {
                    cyNetwork = (CyNetwork)iterator.next();
                    if (cyNetwork == cyNetwork2 || !cyNetwork.isFlagged((Edge)node)) continue;
                    cyNetwork2.setFlagged((Edge)node, true);
                    continue block2;
                }
            }
        }
        this.working = false;
    }

    private class DeactivateMultiNetworkNodeSelectionAction
    extends CytoscapeAction {
        public DeactivateMultiNetworkNodeSelectionAction() {
            super("Deactivate Multi-Network Selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiNetworkNodeSelection.this.deactivateNetworkLinker();
        }
    }

    private class ActivateMultiNetworkNodeSelectionAction
    extends CytoscapeAction {
        public ActivateMultiNetworkNodeSelectionAction() {
            super("Activate Multi-Network Selection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiNetworkNodeSelection.this.activateNetworkLinker();
        }
    }
}

