/*
 * Created on Sep 17, 2005
 *
 */
package cytoscape.editor.editors;

import java.awt.Color;
import java.util.List;
import java.util.Vector;

import javax.swing.JOptionPane;

import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.event.PaletteNetworkEditEventHandler;
import cytoscape.editor.impl.CytoShapeIcon;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.mappings.DiscreteMapping;

/**
* An example "BioPAX-like" editor that extends the basic Cytoscape editor and is based upon
 * a drag-and-drop and palette framework into which developers plug in semantics. The framework consists of
 * <ul> 
 * <li> a palette, from which the user drags and drops shapes onto the canvas
 * <li> an extensible shape class for the palette, 
 * <li> a drawing canvas upon which shapes are dropped, and
 * <li> event handlers which respond to drop events generated by the canvas. 
 * </ul>
 * <p>
 * The dropping of shapes onto the canvas results in the addition of nodes and edges to the current Cytoscape 
 * network, as defined by the behavior of the event handler that responds to the drop events.  In the 
 * simple "BioPAX-like" editor, there are node types for proteins, catalysis, small molecules, and biochemical 
 * reactions, as well as several directed edge types.
 * <p>
 * 
 *
 * @author Allan Kuchinsky
 * @version 1.0
 * @see PaletteNetworkEditEventHandler
 */
public class SimpleBioPAX_Editor extends BasicCytoscapeEditor {

	/**
	 * 
	 */
	public SimpleBioPAX_Editor() {
		super();
	}

	private ShapePalette shapePalette;

	public static final String NODE_TYPE = "NODE_TYPE";
	
	/**
	 * specialized initialization code for editor, called by
	 * CytoscapeEditorManager when a new editor is built.
	 * @param args an arbitrary list of arguments passed to initialization routine.  Not used in this editor
	 */
	public void initializeControls(List args)
	{
		String controllingNodeAttribute = this.getControllingNodeAttribute();
		String controllingEdgeAttribute = this.getControllingEdgeAttribute();
		
		// AJK: 06/10/06 BEGIN
		//     no longer rebuilding shape palette, just its shape pane
//		shapePalette = new ShapePalette();
		shapePalette = 
			CytoscapeEditorManager.getCurrentShapePalette();
			shapePalette.clear();
		// AJK: 06/10/06 END
		
		// TODO: need to ensure that we have BioPAX visual style loaded
        VisualMappingManager manager =
            Cytoscape.getVisualMappingManager();
    
        VisualStyle vizStyle = manager.getVisualStyle();
        System.out.println ("Got visual style: " + vizStyle);
        

		// first do edges
        EdgeAppearanceCalculator eac = vizStyle.getEdgeAppearanceCalculator();
        System.out.println ("Got edgeAppearanceCalculator: " + eac);
        if (eac == null)
        {
    		String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
			String title = "Cannot build palette for SimpleBioPAXEditor: no edge appearance calculator";
			JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript,
					title, JOptionPane.PLAIN_MESSAGE);
        	return;
        }
        GenericEdgeArrowCalculator edgeCalc = (GenericEdgeArrowCalculator) eac.getEdgeTargetArrowCalculator();
        System.out.println("Got edge target arrow calculator: " + edgeCalc);
        if (edgeCalc == null)
        {
    		String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
			String title = "Cannot build palette for SimpleBioPAXEditor: no edge arrow calculator";
			JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript,
					title, JOptionPane.PLAIN_MESSAGE);
        	return;
        }        
        Vector edgeMappings = edgeCalc.getMappings();

        DiscreteMapping dArrow = null;
        for (int i = 0; i < edgeMappings.size(); i++)
        {
        	DiscreteMapping dArrowCandidate = (DiscreteMapping) edgeMappings.get(i);
        	String attr = dArrowCandidate.getControllingAttributeName();
        	System.out.println ("checking attribute: " + attr + " against controlling attribute: " + controllingEdgeAttribute);
        	if (attr.equals(controllingEdgeAttribute))
        	{
        		dArrow = dArrowCandidate;
        		break;
        	}       	
        }
        if (dArrow == null)
        {
    		String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Edge Target Arrow to an attribute.";
			String title = "Cannot build palette for SimpleBioPAXEditor";
			JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript,
					title, JOptionPane.PLAIN_MESSAGE);
        	return;
        }
        
        Arrow arrowType;
        
    	arrowType = (Arrow) dArrow.getMapValue("ACTIVATION");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "ACTIVATION",
				new CytoShapeIcon(arrowType), "ACTIVATION");
		
    	arrowType = (Arrow) dArrow.getMapValue("ACTIVATION-NONALLOSTERIC");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "ACTIVATION-NONALLOSTERIC",
				new CytoShapeIcon(arrowType), "ACTIVATION-NONALLOSTERIC");
		
    	arrowType = (Arrow) dArrow.getMapValue("COFACTOR");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "COFACTOR",
				new CytoShapeIcon(arrowType), "COFACTOR");
		
    	arrowType = (Arrow) dArrow.getMapValue("CONTAINS");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "CONTAINS",
				new CytoShapeIcon(arrowType), "CONTAINS");
		
    	arrowType = (Arrow) dArrow.getMapValue("CONTROLLED");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "CONTROLLED",
				new CytoShapeIcon(arrowType), "CONTROLLED");
		
    	arrowType = (Arrow) dArrow.getMapValue("CONTROLLER");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "CONTROLLER",
				new CytoShapeIcon(arrowType), "CONTROLLER");
		
    	arrowType = (Arrow) dArrow.getMapValue("INHIBITION");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "INHIBITION",
				new CytoShapeIcon(arrowType), "INHIBITION");
		
    	arrowType = (Arrow) dArrow.getMapValue("LEFT");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "LEFT",
				new CytoShapeIcon(arrowType), "LEFT");
		
    	arrowType = (Arrow) dArrow.getMapValue("RIGHT");
		shapePalette.addShape("BIOPAX_EDGE_TYPE", "RIGHT",
				new CytoShapeIcon(arrowType), "RIGHT");			
        
        
        
        // then add nodes
		
	    Color nodeColor = null;
	    byte nodeShape;
	    DiscreteMapping dfill = null;
	        
	        
        NodeAppearanceCalculator nac = vizStyle.getNodeAppearanceCalculator();
        System.out.println ("Got NodeAppearanceCalculator: " + nac);
        if (nac == null)
        {
        	
    		String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to a aNODE_TYPE attribute.";
			String title = "Cannot build palette for SimpleBioPAXEditor";
			JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript,
					title, JOptionPane.PLAIN_MESSAGE);
        	return;
        }
        
        GenericNodeColorCalculator nfill = (GenericNodeColorCalculator) nac.getNodeFillColorCalculator();
      
        if (nfill == null)
        {
        	nodeColor = nac.getDefaultNodeFillColor();
        }
        else
        {
            Vector mappings = nfill.getMappings();
            dfill = null;
            for (int i = 0; i < mappings.size(); i++)
            {
            	DiscreteMapping dfillCandidate = (DiscreteMapping) mappings.get(i);
            	String attr = dfillCandidate.getControllingAttributeName();
            	System.out.println ("checking attribute: " + attr + " against controlling attribute: " + controllingNodeAttribute);
            	if (attr.equals(controllingNodeAttribute))
            	{
            		dfill = dfillCandidate;
            		break;
            	}       	
            }
            if (dfill == null)
            {
        		String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Shape to a ODE_TYPE attribute.";
    			String title = "Cannot build palette for SimpleBioPAXEditor";
    			JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript,
    					title, JOptionPane.PLAIN_MESSAGE);
            	return;
            }        	
        }
 
 
        GenericNodeShapeCalculator nshape = (GenericNodeShapeCalculator) nac.getNodeShapeCalculator();       
        if (nshape == null)
        {
    		String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Color to a NODE_TYPE attribute.";
			String title = "Cannot build palette for SimpleBioPAXEditor";
			JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript,
					title, JOptionPane.PLAIN_MESSAGE);
        	return;
        }        
        Vector mappings = nshape.getMappings();
        DiscreteMapping dshape = null;
        for (int i = 0; i < mappings.size(); i++)
        {
        	DiscreteMapping dshapeCandidate = (DiscreteMapping) mappings.get(i);
        	String attr = dshapeCandidate.getControllingAttributeName();
        	if (attr.equals(controllingNodeAttribute))
        	{
        		dshape = dshapeCandidate;
        		break;
        	}       	
        }
        if (dshape == null)
        {
    		String expDescript = "Cannot build palette.  You need to set up a Visual Style that maps Node Shape to NODE_TYPE attribute.";
			String title = "Cannot build palette for SimpleBioPAXEditor";
			JOptionPane.showMessageDialog(Cytoscape.getDesktop(), expDescript,
					title, JOptionPane.PLAIN_MESSAGE);
        	return;
        }
                
        
 
            if (nodeColor == null)
            {
            	nodeColor = nac.getDefaultNodeFillColor();
            }
 
		nodeShape = ((Byte) dshape.getMapValue("protein")).byteValue();
//		System.out.println ("Got mapping for nodeShape: " + nodeObj.getClass());
		
		if (dfill != null)
		{
			nodeColor = (Color) dfill.getMapValue("protein");
		}
	
		shapePalette.addShape("NODE_TYPE", "protein", 
//               new CytoShapeIcon(CytoShapeIcon.RECTANGLE, Color.BLUE), // hard code for first pass
	            new CytoShapeIcon(nodeShape, nodeColor), 
			   "Protein");

		nodeShape = ((Byte) dshape.getMapValue("catalysis")).byteValue();
		if (dfill != null)
		{
			nodeColor = (Color) dfill.getMapValue("catalysis");
		}
		shapePalette.addShape("NODE_TYPE", "catalysis", 
//               new CytoShapeIcon(CytoShapeIcon.ROUNDED_RECTANGLE, Color.YELLOW), "Catalysis");
	              new CytoShapeIcon(nodeShape, nodeColor), "Catalysis");

		nodeShape = ((Byte) dshape.getMapValue("smallMolecule")).byteValue();
		if (dfill != null)
		{
			nodeColor = (Color) dfill.getMapValue("smallMolecule");
		}			
		shapePalette.addShape("NODE_TYPE", "smallMolecule", 
//               new CytoShapeIcon (CytoShapeIcon.DIAMOND, Color.MAGENTA), "Small Molecule");
	              new CytoShapeIcon (nodeShape, nodeColor), "Small Molecule");

		nodeShape = ((Byte) dshape.getMapValue("biochemicalReaction")).byteValue();
		if (dfill != null)
		{
			nodeColor = (Color) dfill.getMapValue("biochemicalReaction");
		}
		shapePalette.addShape("NODE_TYPE", "biochemicalReaction",
				new CytoShapeIcon(nodeShape, nodeColor), "Biochemical Reaction");

		nodeShape = ((Byte) dshape.getMapValue("complex")).byteValue();
		if (dfill != null)
		{
			nodeColor = (Color) dfill.getMapValue("complex");
		}
		shapePalette.addShape("NODE_TYPE", "complex",
				new CytoShapeIcon(nodeShape, nodeColor), "Complex");

		nodeShape = ((Byte) dshape.getMapValue("modulation")).byteValue();
		if (dfill != null)
		{
			nodeColor = (Color) dfill.getMapValue("modulation");
		}
		shapePalette.addShape("NODE_TYPE", "modulation",
				new CytoShapeIcon(nodeShape, nodeColor), "Modulation");
		
		nodeShape = ((Byte) dshape.getMapValue("physicalEntity")).byteValue();
		if (dfill != null)
		{
			nodeColor = (Color) dfill.getMapValue("physicalEntity");
		}	
		shapePalette.addShape("NODE_TYPE", "physicalEntity",
				new CytoShapeIcon(nodeShape, nodeColor), "Physical Entity");
				
		shapePalette.showPalette();						
	}

	/**
	 * sets controls invisible when editor type is switched
	 * @param args args an arbitrary list of arguments (not used in this editor)
	 */
	public void disableControls (List args)
	{
//		super.disableControls(args);
		shapePalette.setVisible(false);	
	}
	
	/**
	 * sets controls visible when editor type is switched back to this editor
	 * @param args args an arbitrary list of arguments (not used in this editor)	 * 
	 */
	public void enableControls (List args)
	{
//		super.enableControls(args);
		shapePalette.showPalette();
		shapePalette.setVisible(true);
		
	}	
}
