/*
 * Created on Oct 4, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package cytoscape.editor.editors;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import cytoscape.Cytoscape;
import cytoscape.editor.CytoscapeEditorManager;
import cytoscape.editor.event.PaletteNetworkEditEventHandler;
import cytoscape.editor.impl.CytoShapeIcon;
import cytoscape.editor.impl.ShapePalette;
import cytoscape.visual.Arrow;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.GenericEdgeArrowCalculator;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.mappings.DiscreteMapping;

/**
 * /** An example editor that extends the basic Cytoscape editor and is based
 * upon a drag-and-drop and palette framework into which developers plug in
 * semantics. The framework consists of
 * <ul>
 * <li> a palette, from which the user drags and drops shapes onto the canvas
 * <li> an extensible shape class for the palette,
 * <li> a drawing canvas upon which shapes are dropped, and
 * <li> event handlers which respond to drop events generated by the canvas.
 * </ul>
 * <p>
 * The dropping of shapes onto the canvas results in the addition of nodes and
 * edges to the current Cytoscape network, as defined by the behavior of the
 * event handler that responds to the drop events.
 * <p>
 * 
 * 
 * @author Allan Kuchinsky
 * @version 1.0
 * @see PaletteNetworkEditEventHandler
 * 
 */

public class DefaultCytoscapeEditor extends BasicCytoscapeEditor implements
		ChangeListener {


	private ShapePalette shapePalette;

	public static final String NODE_TYPE = "NODE_TYPE";

	public static final String EDGE_TYPE = "EDGE_TYPE";

	/**
	 * main data structures for all node and edge attributes
	 */
	public static cytoscape.data.CyAttributes nodeAttribs = Cytoscape
			.getNodeAttributes();

	public static cytoscape.data.CyAttributes edgeAttribs = Cytoscape
			.getEdgeAttributes();

	/**
	 * 
	 */
	public DefaultCytoscapeEditor() {
		super();
	}


	/**
	 * specialized initialization code for editor, called by
	 * CytoscapeEditorManager when a new editor is built.
	 * draws shapes on the palette, based upon the visual style
	 * 
	 * @param args
	 *            an arbitrary list of arguments passed to initialization
	 *            routine. Not used in this editor
	 */
	public void initializeControls(List args) {
		String controllingNodeAttribute = this.getControllingNodeAttribute();
		String controllingEdgeAttribute = this.getControllingEdgeAttribute();

		shapePalette = 
		CytoscapeEditorManager.getCurrentShapePalette();
		shapePalette.clear();
		VisualMappingManager manager = Cytoscape.getVisualMappingManager();

		VisualStyle vizStyle = manager.getVisualStyle();
		System.out.println("Got visual style: " + vizStyle);

		// first do edges
		EdgeAppearanceCalculator eac = vizStyle.getEdgeAppearanceCalculator();
		System.out.println("Got edgeAppearanceCalculator: " + eac);		
		
		GenericEdgeArrowCalculator edgeCalc = null;
		if (eac != null) {
			edgeCalc = (GenericEdgeArrowCalculator) eac
					.getEdgeTargetArrowCalculator();
			System.out.println("Got edge target arrow calculator: " + edgeCalc);
			if (edgeCalc == null) {
			}
		}
		DiscreteMapping dArrow = null;

		if (edgeCalc != null) {
			Vector edgeMappings = edgeCalc.getMappings();

			for (int i = 0; i < edgeMappings.size(); i++) {
				if (edgeMappings.get(i) instanceof DiscreteMapping) {
					DiscreteMapping dArrowCandidate = (DiscreteMapping) edgeMappings
							.get(i);
					String attr = dArrowCandidate.getControllingAttributeName();
//					System.out.println("checking attribute: " + attr
//							+ " against controlling attribute: "
//							+ controllingEdgeAttribute);
					if (attr.equals(controllingEdgeAttribute)) {
						dArrow = dArrowCandidate;
						break;
					}
				}
			}
		}

		if (dArrow == null) {
			shapePalette.addShape(EDGE_TYPE, "DirectedEdge", new CytoShapeIcon(
					Arrow.BLACK_DELTA), "Directed Edge");
		} else {
			Arrow arrowType;
			Map edgeTargetArrows = dArrow.getAll();

			Set mapKeys = edgeTargetArrows.keySet();
			Iterator it = mapKeys.iterator();
			while (it.hasNext()) {
				Object arrowKey = it.next();
				String keyName = arrowKey.toString();
				arrowType = (Arrow) dArrow.getMapValue(arrowKey);
				shapePalette.addShape(EDGE_TYPE, keyName, new CytoShapeIcon(
						arrowType), keyName);

				// add this as a change listener. Make sure it's unique by
				// removing
				// any past listeners
				dArrow.removeChangeListener(this);
				dArrow.addChangeListener(this);
			}

		}

		// then add nodes

		Color nodeColor = null;
		byte nodeShape;
		DiscreteMapping dfill = null;
		DiscreteMapping dshape = null;

		NodeAppearanceCalculator nac = vizStyle.getNodeAppearanceCalculator();
//		System.out.println("Got NodeAppearanceCalculator: " + nac);

		GenericNodeColorCalculator nfill = null;
		if (nac != null) {
			nfill = (GenericNodeColorCalculator) nac
					.getNodeFillColorCalculator();
		}

		if (nfill == null) {
			nodeColor = nac.getDefaultNodeFillColor();
		} else {
			Vector mappings = nfill.getMappings();
			dfill = null;
			for (int i = 0; i < mappings.size(); i++) {
				if (mappings.get(i) instanceof DiscreteMapping) {
					DiscreteMapping dfillCandidate = (DiscreteMapping) mappings
							.get(i);
					String attr = dfillCandidate.getControllingAttributeName();
//					System.out.println("checking attribute: " + attr
//							+ " against controlling attribute: "
//							+ controllingNodeAttribute);
					if (attr.equals(controllingNodeAttribute)) {
						dfill = dfillCandidate;
						break;
					}
				}

			}
			if (dfill == null) {
				nodeColor = nac.getDefaultNodeFillColor();
			} else {
				// add this as a change listener. Make sure it's unique by
				// removing
				// any past listeners
				nfill.removeChangeListener(this);
				nfill.addChangeListener(this);
			}
		}

		GenericNodeShapeCalculator nshape = null;
		if (nac != null) {
			nshape = (GenericNodeShapeCalculator) nac.getNodeShapeCalculator();
		}

		if (nshape == null) {
			nodeShape = nac.getDefaultNodeShape();
		}
		else {
			Vector mappings = nshape.getMappings();

			for (int i = 0; i < mappings.size(); i++) {
				if (mappings.get(i) instanceof DiscreteMapping) {
					DiscreteMapping dshapeCandidate = (DiscreteMapping) mappings
							.get(i);
					String attr = dshapeCandidate.getControllingAttributeName();
					if (attr.equals(controllingNodeAttribute)) {
						dshape = dshapeCandidate;
						break;
					}
				}

			}
			if (dshape == null) {
				nodeShape = nac.getDefaultNodeShape();
			} else {
				nshape.removeChangeListener(this);
				nshape.addChangeListener(this);
			}
		}

		Color defaultNodeColor = nac.getDefaultNodeFillColor();
		byte defaultNodeShape = nac.getDefaultNodeShape();

		if ((dshape == null) && (dfill == null)) {

			shapePalette.addShape("NODE_TYPE", "DefaultNode",
					new CytoShapeIcon(defaultNodeShape, defaultNodeColor),
					"Add a Node");

		} else {
			Map nodeColorValues = (dfill == null) ? null : dfill.getAll();
			Map nodeShapeValues = (dshape == null) ? null : dshape.getAll();
			Set nodeColorKeys = (nodeColorValues == null) ? null
					: nodeColorValues.keySet();
			Set nodeShapeKeys = (nodeShapeValues == null) ? null
					: nodeShapeValues.keySet();
			Iterator nodeShapeIt = (nodeShapeKeys == null) ? null
					: nodeShapeKeys.iterator();
			Iterator nodeColorIt = (nodeColorKeys == null) ? null
					: nodeColorKeys.iterator();
			List keysVisited = new ArrayList();

			if (nodeShapeIt != null) {
				while (nodeShapeIt.hasNext()) {
					Object shapeKey = nodeShapeIt.next();
					if (!keysVisited.contains(shapeKey)) {
						keysVisited.add(shapeKey);
						String shapeKeyName = shapeKey.toString();
						nodeShape = ((Byte) dshape.getMapValue(shapeKey))
								.byteValue();
						if (dfill == null) {
							nodeColor = nac.getDefaultNodeFillColor();
						} else {
							nodeColor = (Color) dfill.getMapValue(shapeKey);
							if (nodeColor == null) {
								nodeColor = nac.getDefaultNodeFillColor();
							}
						}
						shapePalette.addShape("NODE_TYPE", shapeKeyName,
								new CytoShapeIcon(nodeShape, nodeColor),
								shapeKeyName);
					}
				}
			}
			if (nodeColorIt != null) {
				while (nodeColorIt.hasNext()) {
					Object colorKey = nodeColorIt.next();
					if (!keysVisited.contains(colorKey)) {
						keysVisited.add(colorKey);
						String colorKeyName = colorKey.toString();
						nodeColor = (Color) dfill.getMapValue(colorKey);
						// at this point, we will have visited all shape keys,
						// so shape key for this
						// color key would be null
						shapePalette.addShape("NODE_TYPE", colorKeyName,
								new CytoShapeIcon(defaultNodeShape, nodeColor),
								colorKeyName);
					}
				}
			}
		}

		shapePalette.showPalette();

		 super.initializeControls(null);

	}

	/**
	 * sets controls invisible when editor type is switched
	 * 
	 * @param args
	 *            args an arbitrary list of arguments (not used in this editor)
	 */
	public void disableControls(List args) {
		// super.disableControls(args);
		if (shapePalette != null) {
			shapePalette.setVisible(false);
		}
	}

	/**
	 * sets controls visible when editor type is switched back to this editor
	 * 
	 * @param args
	 *            args an arbitrary list of arguments (not used in this editor) *
	 */
	public void enableControls(List args) {
		// super.enableControls(args);
		shapePalette.showPalette();
		shapePalette.setVisible(true);

	}

	/**
	 * redraw palette when a shape, color, or arrow mapping changes
	 * 
	 * @param e
	 */
	public void stateChanged(ChangeEvent e) {
		initializeControls(null);
	}

}
