/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.plugins.communication;

import cytoscape.Cytoscape;
import cytoscape.util.plugins.communication.Message;
import cytoscape.util.plugins.communication.MessageListener;
import cytoscape.util.plugins.communication.ResponseMessage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginsCommunicationSupport {
    private static final String INTER_PLUGIN_COMMUNICATION = "INTER_PLUGIN_COMMUNICATION";
    private static final Map<MessageListener, PropertyChangeListener> listenerMap = new HashMap<MessageListener, PropertyChangeListener>();

    private PluginsCommunicationSupport() {
    }

    public static void sendMessage(String string, String string2, String string3, String string4) {
        PluginsCommunicationSupport.sendMessage(string, string2, string3, string4, null);
    }

    public static void sendMessage(String string, String string2, String string3, String string4, Object object) {
        PluginsCommunicationSupport.sendMessage(new Message(string, string2, string3, string4, object));
    }

    public static void sendMessage(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null.");
        }
        PropertyChangeSupport propertyChangeSupport = Cytoscape.getPropertyChangeSupport();
        propertyChangeSupport.firePropertyChange(INTER_PLUGIN_COMMUNICATION, null, message);
    }

    public static List<ResponseMessage> sendMessageAndGetResponses(String string, String string2, String string3, String string4, Object object) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Neither messade id ir sender can be null in order to get responses.");
        }
        return PluginsCommunicationSupport.sendMessageAndGetResponses(new Message(string, string2, string3, string4, object));
    }

    public static List<ResponseMessage> sendMessageAndGetResponses(Message message) {
        String string;
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null.");
        }
        Message message2 = new Message(message);
        final ArrayList<ResponseMessage> arrayList = new ArrayList<ResponseMessage>(1);
        final String string2 = message2.getSender();
        if (string2 == null) {
            PluginsCommunicationSupport.sendMessage(message2);
            return arrayList;
        }
        if (message2.getId() == null) {
            string = string2 + System.currentTimeMillis();
            message2.setId(string);
        } else {
            string = message2.getId();
        }
        MessageListener messageListener = new MessageListener(){

            public void messagedReceived(Message message) {
                if (!(message instanceof ResponseMessage)) {
                    return;
                }
                ResponseMessage responseMessage = (ResponseMessage)message;
                if (responseMessage.getReceiver().compareTo(string2) != 0) {
                    return;
                }
                if (responseMessage.getRespondToId().compareTo(string) != 0) {
                    return;
                }
                arrayList.add(responseMessage);
            }
        };
        PluginsCommunicationSupport.addMessageListener(string2, messageListener);
        PluginsCommunicationSupport.sendMessage(message2);
        PluginsCommunicationSupport.removeMessageListener(messageListener);
        return arrayList;
    }

    public static Set<String> getReceivers() {
        String string;
        long l = System.currentTimeMillis();
        String string2 = string = "PluginsCommunicationSupport." + l;
        String string3 = null;
        String string4 = "GET_RECEIVERS";
        List<ResponseMessage> list = PluginsCommunicationSupport.sendMessageAndGetResponses(string2, string, string3, string4, null);
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (ResponseMessage responseMessage : list) {
                String string5 = responseMessage.getSender();
                if (string5 == null) continue;
                hashSet.add(string5);
            }
        }
        return hashSet;
    }

    public static Set<String> getMessageTypes(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        long l = System.currentTimeMillis();
        String string3 = "PluginsCommunicationSupport." + l;
        String string4 = string3;
        List<ResponseMessage> list = PluginsCommunicationSupport.sendMessageAndGetResponses(string4, string3, string, string2 = "GET_MSG_TYPES", null);
        if (list != null) {
            for (ResponseMessage responseMessage : list) {
                Object object;
                if (responseMessage.getSender().compareTo(string) != 0 || (object = responseMessage.getContent()) == null || !(object instanceof Map)) continue;
                Map map = (Map)object;
                Object v = map.get("GET_MSG_TYPES");
                if (object == null || !(v instanceof Set)) continue;
                return (Set)v;
            }
        }
        return new HashSet<String>(0);
    }

    public static void addMessageListener(MessageListener messageListener) {
        PluginsCommunicationSupport.addMessageListener(null, messageListener);
    }

    public static void addMessageListener(final String string, final MessageListener messageListener) {
        if (messageListener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        PropertyChangeSupport propertyChangeSupport = Cytoscape.getPropertyChangeSupport();
        propertyChangeSupport.addPropertyChangeListener(INTER_PLUGIN_COMMUNICATION, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object == null) {
                    return;
                }
                if (!(object instanceof Message)) {
                    return;
                }
                Message message = (Message)object;
                String string2 = message.getReceiver();
                if (string != null && string2 != null && string2.compareTo(string) != 0) {
                    return;
                }
                messageListener.messagedReceived(message);
                listenerMap.put(messageListener, this);
            }
        });
    }

    public static void removeMessageListener(MessageListener messageListener) {
        PropertyChangeSupport propertyChangeSupport = Cytoscape.getPropertyChangeSupport();
        PropertyChangeListener propertyChangeListener = listenerMap.get(messageListener);
        if (propertyChangeListener != null) {
            propertyChangeSupport.removePropertyChangeListener(INTER_PLUGIN_COMMUNICATION, propertyChangeListener);
        }
    }
}

