/*
 * Decompiled with CFR 0.152.
 */
package projtester;

import cytoscape.Cytoscape;
import cytoscape.cythesaurus.service.CyThesaurusServiceClient;
import cytoscape.cythesaurus.service.CyThesaurusServiceMessageBasedClient;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class TestCyThesurrusServiceWrap
extends CytoscapePlugin {
    private CyThesaurusServiceClient client = new CyThesaurusServiceMessageBasedClient();

    public TestCyThesurrusServiceWrap() {
        JMenu pluginMenu = Cytoscape.getDesktop().getCyMenus().getOperationsMenu();
        JMenu testMenu = new JMenu("Test CyThesaurus Service wrapped");
        pluginMenu.add(testMenu);
        testMenu.add((Action)((Object)new CyThesurrusServiceTestAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceMappingDialogAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceConfigDialogAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceIDTypeAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceAttributeBasedIDMappingAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceGetMappersAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceGetSelectedMappersAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceRegisterMappersAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceUnregisterMappersAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceUnselectMappersAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceSelectMappersAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceIDMappingAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceIDExistsAction()));
    }

    private class CyThesurrusServiceIDExistsAction
    extends CytoscapeAction {
        public static final String actionName = "ID exists service example (See Tutorial)";

        public CyThesurrusServiceIDExistsAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String id = "YLR229C";
            String type = "ensembl_gene_id";
            if (TestCyThesurrusServiceWrap.this.client.idExists(id, type)) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "exist");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "not exist");
            }
        }
    }

    private class CyThesurrusServiceIDMappingAction
    extends CytoscapeAction {
        public static final String actionName = "ID mapping service example (See Tutorial)";

        public CyThesurrusServiceIDMappingAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            HashSet<String> srcIds = new HashSet<String>();
            srcIds.add("YLR229C");
            srcIds.add("YOR290C");
            srcIds.add("YGR058W");
            String srcIDType = "ensembl_gene_id";
            String tgtIDType = "entrezgene";
            Map<String, Set<String>> mapTypeAttr = TestCyThesurrusServiceWrap.this.client.mapID(srcIds, srcIDType, tgtIDType);
            if (mapTypeAttr != null) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), mapTypeAttr.toString());
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "failed");
            }
        }
    }

    private class CyThesurrusServiceAttributeBasedIDMappingAction
    extends CytoscapeAction {
        public static final String actionName = "Attribute ID mapping service example (See Tutorial)";

        public CyThesurrusServiceAttributeBasedIDMappingAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String srcAttrName = "ID";
            HashSet<String> srcIDTypes = new HashSet<String>();
            srcIDTypes.add("ensembl_gene_id");
            String tgtIDType = "entrezgene";
            String tgtAttrName = "entrezgene";
            boolean b = TestCyThesurrusServiceWrap.this.client.mapID(null, srcAttrName, tgtAttrName, srcIDTypes, tgtIDType);
            if (!b) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "failed");
            }
        }
    }

    private class CyThesurrusServiceIDTypeAction
    extends CytoscapeAction {
        public static final String actionName = "Get supported ID types";

        public CyThesurrusServiceIDTypeAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            Set<String> srcTypes = TestCyThesurrusServiceWrap.this.client.supportedSrcIDTypes();
            Set<String> tgtTypes = TestCyThesurrusServiceWrap.this.client.supportedTgtIDTypes();
            StringBuilder sb = new StringBuilder("ID types fectched:\n");
            sb.append("==Supported source ID types==\n");
            int count = 0;
            for (String type : srcTypes) {
                sb.append(type + ";");
                if (++count % 5 != 0) continue;
                sb.append("\n");
            }
            sb.append("\n");
            sb.append("==Supported target ID types==\n");
            count = 0;
            for (String type : tgtTypes) {
                sb.append(type + ";");
                if (++count % 5 != 0) continue;
                sb.append("\n");
            }
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), sb.toString());
        }
    }

    private class CyThesurrusServiceConfigDialogAction
    extends CytoscapeAction {
        public static final String actionName = "Config Dialog";

        public CyThesurrusServiceConfigDialogAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            boolean succ = TestCyThesurrusServiceWrap.this.client.openMappingResourceConfigDialog();
            if (succ) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping sources were configured successfully");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping sources were not configured or failed");
            }
        }
    }

    private class CyThesurrusServiceMappingDialogAction
    extends CytoscapeAction {
        public static final String actionName = "Main Dialog";

        public CyThesurrusServiceMappingDialogAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            boolean succ = TestCyThesurrusServiceWrap.this.client.openAttributeConfigDialog();
            if (succ) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping was performed successfully");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping was not performed or failed");
            }
        }
    }

    private class CyThesurrusServiceUnselectMappersAction
    extends CytoscapeAction {
        public static final String actionName = "Unselect ID mapper";

        public CyThesurrusServiceUnselectMappersAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String connStr = "idmapper-synergizer:http://llama.med.harvard.edu/cgi/synergizer/serv?authority=ensembl49&species=Saccharomyces cerevisiae";
            if (TestCyThesurrusServiceWrap.this.client.setIDMapperSelect(connStr, false)) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "unselected");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceSelectMappersAction
    extends CytoscapeAction {
        public static final String actionName = "Select ID mapper";

        public CyThesurrusServiceSelectMappersAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String connStr = "idmapper-synergizer:http://llama.med.harvard.edu/cgi/synergizer/serv?authority=ensembl49&species=Saccharomyces cerevisiae";
            if (TestCyThesurrusServiceWrap.this.client.setIDMapperSelect(connStr, true)) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "selected");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceUnregisterMappersAction
    extends CytoscapeAction {
        public static final String actionName = "Unregister ID mapper";

        public CyThesurrusServiceUnregisterMappersAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String connStr = "idmapper-synergizer:http://llama.med.harvard.edu/cgi/synergizer/serv?authority=ensembl49&species=Saccharomyces cerevisiae";
            if (TestCyThesurrusServiceWrap.this.client.unregisterIDMapper(connStr)) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Unregistered");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceRegisterMappersAction
    extends CytoscapeAction {
        public static final String actionName = "Register ID mapper";

        public CyThesurrusServiceRegisterMappersAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String connStr = "idmapper-synergizer:http://llama.med.harvard.edu/cgi/synergizer/serv?authority=ensembl49&species=Saccharomyces cerevisiae";
            String classPath = "org.bridgedb.webservice.synergizer.IDMapperSynergizer";
            String displayName = "Synergizer:authority=ensembl49&species=Saccharomyces cerevisiae";
            if (TestCyThesurrusServiceWrap.this.client.registerIDMapper(connStr, classPath, displayName)) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Registered");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceGetSelectedMappersAction
    extends CytoscapeAction {
        public static final String actionName = "List selected ID mappers";

        public CyThesurrusServiceGetSelectedMappersAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            Set<String> mappers = TestCyThesurrusServiceWrap.this.client.selectedIDMappers();
            if (mappers != null) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), mappers.toString());
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceGetMappersAction
    extends CytoscapeAction {
        public static final String actionName = "List ID mappers";

        public CyThesurrusServiceGetMappersAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            Set<String> mappers = TestCyThesurrusServiceWrap.this.client.allIDMappers();
            if (mappers != null) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), mappers.toString());
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceTestAction
    extends CytoscapeAction {
        public static final String actionName = "Check availability";

        public CyThesurrusServiceTestAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            if (TestCyThesurrusServiceWrap.this.client.isServiceAvailable()) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are available.");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }
}

