/*
 * Decompiled with CFR 0.152.
 */
package projtester;

import cytoscape.Cytoscape;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.plugins.communication.Message;
import cytoscape.util.plugins.communication.PluginsCommunicationSupport;
import cytoscape.util.plugins.communication.ResponseMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class TestCyThesurrusService
extends CytoscapePlugin {
    public TestCyThesurrusService() {
        JMenu pluginMenu = Cytoscape.getDesktop().getCyMenus().getOperationsMenu();
        JMenu testMenu = new JMenu("Test CyThesaurus Service");
        pluginMenu.add(testMenu);
        testMenu.add((Action)((Object)new CyThesurrusServiceGetReceiversAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceTestAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceGetIDMappingSupportedMsgTypesAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceMappingDialogAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceConfigDialogAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceIDTypeAction()));
        testMenu.add((Action)((Object)new CyThesurrusServiceIDMappingAction()));
    }

    private class CyThesurrusServiceIDMappingAction
    extends CytoscapeAction {
        public static final String actionName = "ID mapping service example (See Tutorial)";

        public CyThesurrusServiceIDMappingAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String receiver = "CyThesaurus";
            String msgType = "REQUEST_MAPPING";
            String msgId = receiver + System.currentTimeMillis();
            HashMap<String, String> content = new HashMap<String, String>();
            content.put("SOURCE_ATTR", "ID");
            content.put("SOURCE_ID_TYPE", "ensembl_gene_id");
            content.put("TARGET_ID_TYPE", "entrezgene");
            Message msg = new Message(msgId, actionName, receiver, msgType, content);
            List<ResponseMessage> response = PluginsCommunicationSupport.sendMessageAndGetResponses(msg);
            if (!response.isEmpty()) {
                Map repondContent = (Map)response.get(0).getContent();
                boolean succ = (Boolean)repondContent.get("SUCCESS");
                String report = (String)repondContent.get("REPORT");
                if (succ) {
                    String tgtAttr = (String)repondContent.get("TARGET_ATTR");
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Mapping IDs successfully to \"" + tgtAttr + "\"\n" + report);
                } else {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to map IDs.\n" + report);
                }
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable");
            }
        }
    }

    private class CyThesurrusServiceIDTypeAction
    extends CytoscapeAction {
        public static final String actionName = "Get supported ID types";

        public CyThesurrusServiceIDTypeAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String receiver = "CyThesaurus";
            String msgType = "REQUEST_SUPPORTED_ID_TYPE";
            String msgId = receiver + System.currentTimeMillis();
            Message msg = new Message(msgId, actionName, receiver, msgType, null);
            List<ResponseMessage> response = PluginsCommunicationSupport.sendMessageAndGetResponses(msg);
            if (!response.isEmpty()) {
                Map content = (Map)response.get(0).getContent();
                boolean succ = (Boolean)content.get("SUCCESS");
                String report = (String)content.get("REPORT");
                if (succ) {
                    String[] supportedSrcIDTypes = (String[])content.get("SRC_ID_TYPE");
                    String[] supportedTgtIDTypes = (String[])content.get("TGT_ID_TYPE");
                    StringBuilder sb = new StringBuilder("ID types fectched:\n");
                    sb.append("==Supported source ID types==\n");
                    int count = 0;
                    for (String type : supportedSrcIDTypes) {
                        sb.append(type + ";");
                        if (++count % 5 != 0) continue;
                        sb.append("\n");
                    }
                    sb.append("\n");
                    sb.append("==Supported target ID types==\n");
                    count = 0;
                    for (String type : supportedTgtIDTypes) {
                        sb.append(type + ";");
                        if (++count % 5 != 0) continue;
                        sb.append("\n");
                    }
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), sb.toString());
                } else {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to fetch supported ID types.\n" + report);
                }
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable");
            }
        }
    }

    private class CyThesurrusServiceConfigDialogAction
    extends CytoscapeAction {
        public static final String actionName = "Config Dialog";

        public CyThesurrusServiceConfigDialogAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String receiver = "CyThesaurus";
            String msgType = "MAPPING_SRC_CONFIG_DIALOG";
            String msgId = receiver + System.currentTimeMillis();
            Message msg = new Message(msgId, actionName, receiver, msgType, null);
            List<ResponseMessage> response = PluginsCommunicationSupport.sendMessageAndGetResponses(msg);
            if (!response.isEmpty()) {
                Map content = (Map)response.get(0).getContent();
                boolean succ = (Boolean)content.get("SUCCESS");
                if (succ) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping sources were configured successfully");
                } else {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping sources were not configured or failed");
                }
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable");
            }
        }
    }

    private class CyThesurrusServiceMappingDialogAction
    extends CytoscapeAction {
        public static final String actionName = "Main Dialog";

        public CyThesurrusServiceMappingDialogAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String receiver = "CyThesaurus";
            String msgType = "MAPPING_DIALOG";
            String msgId = receiver + System.currentTimeMillis();
            Message msg = new Message(msgId, actionName, receiver, msgType, null);
            List<ResponseMessage> response = PluginsCommunicationSupport.sendMessageAndGetResponses(msg);
            if (!response.isEmpty()) {
                Map content = (Map)response.get(0).getContent();
                boolean succ = (Boolean)content.get("SUCCESS");
                if (succ) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping was performed successfully");
                } else {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping was not performed or failed");
                }
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceGetIDMappingSupportedMsgTypesAction
    extends CytoscapeAction {
        public static final String actionName = "Get available ID mapping services";

        public CyThesurrusServiceGetIDMappingSupportedMsgTypesAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String receiver = "CyThesaurus";
            Set<String> types = PluginsCommunicationSupport.getMessageTypes(receiver);
            if (!types.isEmpty()) {
                StringBuilder sb = new StringBuilder("Availabe ID mapping services:\n");
                for (String type : types) {
                    sb.append(type + "\n");
                }
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), sb.toString());
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }

    private class CyThesurrusServiceGetReceiversAction
    extends CytoscapeAction {
        public static final String actionName = "Get receivers";

        public CyThesurrusServiceGetReceiversAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            Set<String> receivers = PluginsCommunicationSupport.getReceivers();
            if (!receivers.isEmpty()) {
                StringBuilder sb = new StringBuilder("Available ID mapping services:\n");
                for (String receiver : receivers) {
                    sb.append(receiver + "\n");
                }
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), sb.toString());
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "No plugin is listening.");
            }
        }
    }

    private class CyThesurrusServiceTestAction
    extends CytoscapeAction {
        public static final String actionName = "Check availability";

        public CyThesurrusServiceTestAction() {
            super(actionName);
        }

        public void actionPerformed(ActionEvent ae) {
            String receiver = "CyThesaurus";
            String msgType = "TEST";
            String msgId = receiver + "_" + System.currentTimeMillis();
            Message msg = new Message(msgId, actionName, receiver, msgType, null);
            List<ResponseMessage> response = PluginsCommunicationSupport.sendMessageAndGetResponses(msg);
            if (!response.isEmpty()) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are available.");
            } else {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "ID mapping services are unavailable.");
            }
        }
    }
}

