/*
 * Decompiled with CFR 0.152.
 */
package glay.util;

import cern.jet.random.Exponential;
import cern.jet.random.Poisson;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import giny.model.Edge;
import giny.model.Node;
import java.util.ArrayList;

public class RandomClusterModel {
    public static final int EXPONENTIAL_CSIZE_DIST = 2;
    public static final int POISSON_CSIZE_DIST = 1;
    public static final int UNIFORM_CSIZE_DIST = 0;
    public static final int NORMAL_CSIZE_DIST = 3;
    private double pIntra;
    private double pInter;
    private int csizeDist;
    private int csizeMean;
    private int clusterNum;
    private int[] clusterSize;
    private int nodeNum;
    private int intraEdgeNumTotal;
    private int interEdgeNumTotal;
    private int intraEdgeNum;
    private int interEdgeNum;
    private int[] nodeIdInterval;
    private CyNetwork network;

    public RandomClusterModel(double pIntra, double ratio, int csizeDist) {
        this.pIntra = pIntra;
        this.pInter = pIntra * ratio;
        this.csizeDist = csizeDist;
    }

    private void genClusterSize() {
        int i;
        this.clusterSize = new int[this.clusterNum];
        this.nodeNum = 0;
        this.intraEdgeNumTotal = 0;
        this.interEdgeNumTotal = 0;
        this.nodeIdInterval = new int[this.clusterNum];
        if (this.csizeDist == 2) {
            for (i = 0; i < this.clusterNum; ++i) {
                this.clusterSize[i] = new Double(Exponential.staticNextDouble((double)(1.0 / (double)this.csizeMean))).intValue();
                this.nodeNum += this.clusterSize[i];
                this.nodeIdInterval[i] = this.nodeNum;
                this.intraEdgeNumTotal += this.clusterSize[i] * (this.clusterSize[i] - 1) / 2;
            }
        } else if (this.csizeDist == 1) {
            for (i = 0; i < this.clusterNum; ++i) {
                this.clusterSize[i] = new Double(Poisson.staticNextInt((double)this.csizeMean)).intValue();
                this.nodeNum += this.clusterSize[i];
                this.nodeIdInterval[i] = this.nodeNum;
                this.intraEdgeNumTotal += this.clusterSize[i] * (this.clusterSize[i] - 1) / 2;
            }
        } else if (this.csizeDist == 0) {
            for (i = 0; i < this.clusterNum; ++i) {
                this.clusterSize[i] = this.csizeMean;
                this.nodeNum += this.clusterSize[i];
                this.nodeIdInterval[i] = this.nodeNum;
                this.intraEdgeNumTotal += this.clusterSize[i] * (this.clusterSize[i] - 1) / 2;
            }
        }
        for (i = 0; i < this.clusterNum; ++i) {
            for (int j = i + 1; j < this.clusterNum; ++j) {
                this.interEdgeNumTotal += this.clusterSize[i] * this.clusterSize[j];
            }
        }
        for (i = 0; i < this.clusterNum; ++i) {
            System.out.println(this.clusterSize[i] + " _ " + this.nodeIdInterval[i]);
        }
        this.interEdgeNum = new Double((double)this.interEdgeNumTotal * this.pInter).intValue();
        this.intraEdgeNum = new Double((double)this.intraEdgeNumTotal * this.pIntra).intValue();
        System.out.println("total Num of nodes:" + this.nodeNum);
        System.out.println("total Num of intra-cluster Edges:" + this.intraEdgeNumTotal);
        System.out.println("total Num of inter-cluster Edges:" + this.interEdgeNumTotal);
        System.out.println("total Num of edges:" + this.nodeNum * (this.nodeNum - 1) / 2);
        System.out.println("Edges need to be Gen intra" + this.intraEdgeNum);
        System.out.println("Edges need to be Gen inter" + this.interEdgeNum);
    }

    private void genNetwork() {
        this.network = Cytoscape.createNetwork((String)"Clustered Erdos-Renyi", (boolean)false);
        ArrayList<CyNode> nodes = new ArrayList<CyNode>(this.nodeNum);
        CyAttributes attrN = Cytoscape.getNodeAttributes();
        CyAttributes attrE = Cytoscape.getEdgeAttributes();
        for (int i = 0; i < this.nodeIdInterval.length; ++i) {
            int endId;
            int startId;
            ArrayList<CyNode> ids = new ArrayList<CyNode>();
            if (i == 0) {
                startId = 0;
                endId = this.nodeIdInterval[i];
            } else {
                startId = this.nodeIdInterval[i - 1];
                endId = this.nodeIdInterval[i];
            }
            for (int id = startId; id < endId; ++id) {
                CyNode node = Cytoscape.getCyNode((String)new Integer(id).toString(), (boolean)true);
                ids.add(node);
                this.network.addNode((Node)node);
                nodes.add(node);
                attrN.setAttribute(node.getIdentifier(), "membership", Integer.valueOf(i));
            }
            this.network.getIdentifier();
        }
        System.out.println("Created Nodes:" + nodes.size());
        int intraCounter = 0;
        for (int i = 0; i < this.nodeIdInterval.length; ++i) {
            int endId;
            int startId;
            if (i == 0) {
                startId = 0;
                endId = this.nodeIdInterval[i];
            } else {
                startId = this.nodeIdInterval[i - 1];
                endId = this.nodeIdInterval[i];
            }
            for (int source = startId; source < endId; ++source) {
                for (int target = source + 1; target < endId; ++target) {
                    CyEdge edge;
                    if (Math.random() > this.pIntra || (edge = Cytoscape.getCyEdge((Node)((Node)nodes.get(source)), (Node)((Node)nodes.get(target)), (String)"interaction", (Object)"default", (boolean)false, (boolean)false)) != null) continue;
                    edge = Cytoscape.getCyEdge((Node)((Node)nodes.get(source)), (Node)((Node)nodes.get(target)), (String)"interaction", (Object)"default", (boolean)true, (boolean)false);
                    this.network.addEdge((Edge)edge);
                    ++intraCounter;
                    attrE.setAttribute(edge.getIdentifier(), "class", Integer.valueOf(0));
                }
            }
        }
        System.out.println("Created " + intraCounter + " intra-cluster edges.");
        int interCounter = 0;
        for (int i = 0; i < this.nodeIdInterval.length - 1; ++i) {
            int endId1;
            int startId1;
            if (i == 0) {
                startId1 = 0;
                endId1 = this.nodeIdInterval[i];
            } else {
                startId1 = this.nodeIdInterval[i - 1];
                endId1 = this.nodeIdInterval[i];
            }
            for (int j = i + 1; j < this.nodeIdInterval.length; ++j) {
                int startId2 = this.nodeIdInterval[j - 1];
                int endId2 = this.nodeIdInterval[j];
                for (int source = startId1; source < endId1; ++source) {
                    for (int target = startId2; target < endId2; ++target) {
                        CyEdge edge;
                        if (Math.random() > this.pInter || (edge = Cytoscape.getCyEdge((Node)((Node)nodes.get(source)), (Node)((Node)nodes.get(target)), (String)"interaction", (Object)"default", (boolean)false, (boolean)false)) != null) continue;
                        edge = Cytoscape.getCyEdge((Node)((Node)nodes.get(source)), (Node)((Node)nodes.get(target)), (String)"interaction", (Object)"default", (boolean)true, (boolean)false);
                        attrE.setAttribute(edge.getIdentifier(), "class", Integer.valueOf(1));
                        this.network.addEdge((Edge)edge);
                        ++interCounter;
                    }
                }
            }
        }
        System.out.println("Created " + interCounter + " inter-cluster edges.");
    }

    public CyNetwork generateModel(int clusterNum, int clusterSizeMean) {
        this.csizeMean = clusterSizeMean;
        this.clusterNum = clusterNum;
        this.genClusterSize();
        this.genNetwork();
        return this.network;
    }

    public static void main(String[] args) {
        RandomClusterModel rcm = new RandomClusterModel(0.2, 0.1, 1);
        rcm.generateModel(4, 32);
    }
}

