/*
 * Decompiled with CFR 0.152.
 */
package glay;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.AbstractLayout;
import cytoscape.visual.VisualStyle;
import giny.view.EdgeView;
import giny.view.NodeView;
import glay.util.Cluster;
import glay.util.GLayVisualStyle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class GLayCluster
extends AbstractLayout {
    private Cluster clusterEngine = new Cluster();
    private CyAttributes cyNodeAttr = Cytoscape.getNodeAttributes();
    private CyAttributes cyEdgeAttr = Cytoscape.getEdgeAttributes();
    private String edgeMembershipAttr = "edgeMembership";

    public String toString() {
        return "G.Cluster";
    }

    public String getName() {
        return "GCluster";
    }

    public void construct() {
        NodeView nV;
        this.clusterEngine.randomMembership(this.networkView, 10);
        Iterator nI = this.networkView.getNodeViewsIterator();
        HashSet<Integer> clusterMembership = new HashSet<Integer>();
        while (nI.hasNext()) {
            nV = (NodeView)nI.next();
            int membership = this.cyNodeAttr.getIntegerAttribute(nV.getNode().getIdentifier(), this.clusterEngine.getAttrName());
            clusterMembership.add(membership);
            this.cyNodeAttr.setAttribute(nV.getNode().getIdentifier(), "Degree", Integer.valueOf(nV.getDegree()));
            this.cyNodeAttr.setAttribute(nV.getNode().getIdentifier(), "Opacity", Double.valueOf(Math.random()));
        }
        int clusterCount = clusterMembership.size();
        int[][] clusterCoord = new int[2][clusterCount];
        Random gen = new Random();
        int spacing = 1000;
        for (int i = 0; i < clusterCount; ++i) {
            clusterCoord[0][i] = (int)Math.round((double)spacing * Math.sin(gen.nextDouble() * 2.0 * Math.PI));
            clusterCoord[1][i] = (int)Math.round((double)spacing * Math.cos(gen.nextDouble() * 2.0 * Math.PI));
        }
        int spacingCluster = 200;
        nI = this.networkView.getNodeViewsIterator();
        while (nI.hasNext()) {
            nV = (NodeView)nI.next();
            int membership = this.cyNodeAttr.getIntegerAttribute(nV.getNode().getIdentifier(), this.clusterEngine.getAttrName());
            int xCoord = clusterCoord[0][membership] + (int)Math.round((double)spacingCluster * Math.sin(gen.nextDouble() * 2.0 * Math.PI));
            int yCoord = clusterCoord[1][membership] + (int)Math.round((double)spacingCluster * Math.sin(gen.nextDouble() * 2.0 * Math.PI));
            nV.setOffset((double)xCoord, (double)yCoord);
        }
        Iterator eI = this.networkView.getEdgeViewsIterator();
        int intraEdgeCount = 0;
        int interEdgeCount = 0;
        while (eI.hasNext()) {
            int membership2;
            EdgeView eV = (EdgeView)eI.next();
            int membership1 = this.cyNodeAttr.getIntegerAttribute(eV.getEdge().getSource().getIdentifier(), this.clusterEngine.getAttrName());
            if (membership1 == (membership2 = this.cyNodeAttr.getIntegerAttribute(eV.getEdge().getTarget().getIdentifier(), this.clusterEngine.getAttrName()).intValue())) {
                this.cyEdgeAttr.setAttribute(eV.getEdge().getIdentifier(), this.edgeMembershipAttr, "intra");
                ++intraEdgeCount;
                continue;
            }
            this.cyEdgeAttr.setAttribute(eV.getEdge().getIdentifier(), this.edgeMembershipAttr, "inter");
            ++interEdgeCount;
        }
        CyAttributes cyNodeAttrs = Cytoscape.getNodeAttributes();
        String[] names = cyNodeAttrs.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            System.out.println(names[i]);
        }
        System.out.println(intraEdgeCount + " " + interEdgeCount + " " + this.networkView.edgeCount());
        VisualStyle vs = GLayVisualStyle.createClusterVisualStyle(this.network);
        Cytoscape.getVisualMappingManager().setVisualStyle("TESTY");
    }
}

