/*
 * Decompiled with CFR 0.152.
 */
package metaNodePlugin2.model;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.groups.CyGroup;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class MetaNode {
    private static HashMap<CyNode, MetaNode> metaMap = new HashMap();
    private static HashMap<CyNode, Boolean> hiddenNodes = new HashMap();
    private static final boolean DEBUG = false;
    public static final String X_HINT_ATTR = "__metanodeHintX";
    public static final String Y_HINT_ATTR = "__metanodeHintY";
    public static final String CHILDREN_ATTR = "NumChildren";
    public static final String DESCENDENTS_ATTR = "NumDescendents";
    private CyGroup metaGroup = null;
    private CyNode groupNode = null;
    protected HashMap<CyEdge, List<CyEdge>> newEdgeMap = null;
    private HashMap<CyNode, CyEdge> metaEdgeMap = null;
    private List<MetaNode> childMetaNodes = null;
    private boolean multipleEdges = false;
    private boolean recursive = false;
    protected boolean isCollapsed = false;
    private CyAttributes edgeAttributes = null;
    private CyAttributes nodeAttributes = null;
    private CyNetworkView networkView = null;
    private CyNetwork network = null;
    private int nChildren = 0;
    private int nDescendents = 0;

    public static MetaNode getMetaNode(CyGroup metaGroup) {
        CyNode groupNode = metaGroup.getGroupNode();
        if (metaMap.containsKey(groupNode)) {
            return metaMap.get(groupNode);
        }
        return null;
    }

    public static MetaNode getMetaNode(CyNode groupNode) {
        if (metaMap.containsKey(groupNode)) {
            return metaMap.get(groupNode);
        }
        return null;
    }

    public static void removeMetaNode(CyNode groupNode) {
        if (metaMap.containsKey(groupNode)) {
            metaMap.remove(groupNode);
        }
    }

    public static void removeMetaNode(MetaNode metaNode) {
        if (metaNode == null) {
            return;
        }
        MetaNode.removeMetaNode(metaNode.getCyGroup().getGroupNode());
    }

    public static void expandAll() {
        CyNetworkView nView = Cytoscape.getCurrentNetworkView();
        Collection<MetaNode> metaNodes = metaMap.values();
        for (MetaNode mNode : metaNodes) {
            if (!mNode.isCollapsed) continue;
            mNode.expand(true, nView, false);
        }
        nView.updateView();
    }

    public static void collapseAll() {
        CyNetworkView nView = Cytoscape.getCurrentNetworkView();
        Collection<MetaNode> metaNodes = metaMap.values();
        for (MetaNode mNode : metaNodes) {
            if (mNode.isCollapsed) continue;
            mNode.collapse(true, true, false, nView);
        }
        nView.updateView();
    }

    public MetaNode(CyGroup group) {
        this.metaGroup = group;
        this.groupNode = group.getGroupNode();
        metaMap.put(this.groupNode, this);
        this.metaEdgeMap = new HashMap();
        this.newEdgeMap = new HashMap();
        this.update(null);
        ArrayList<CyEdge> newOuterEdges = new ArrayList<CyEdge>();
        List externalEdges = group.getOuterEdges();
        for (CyEdge edge : externalEdges) {
            List<CyEdge> edges;
            if (!this.isMetaEdge(edge) || (edges = this.getPartnerEdgeList(edge)) == null) continue;
            newOuterEdges.addAll(edges);
        }
        for (CyEdge edge : newOuterEdges) {
            if (externalEdges.contains(edge)) continue;
            group.addOuterEdge(edge);
        }
        hiddenNodes.put(this.groupNode, Boolean.TRUE);
        this.updateAttributes();
    }

    public CyGroup getCyGroup() {
        return this.metaGroup;
    }

    public void update(CyNetworkView view) {
        this.edgeAttributes = Cytoscape.getEdgeAttributes();
        this.nodeAttributes = Cytoscape.getNodeAttributes();
        if (view != null) {
            this.networkView = view;
            this.network = view.getNetwork();
        } else {
            this.networkView = Cytoscape.getCurrentNetworkView();
            this.network = Cytoscape.getCurrentNetwork();
        }
    }

    public void nodeAdded(CyNode node) {
        this.update(null);
        if (this.newEdgeMap != null) {
            if (this.metaEdgeMap.containsKey(node)) {
                CyEdge metaEdge = this.metaEdgeMap.get(node);
                this.network.removeEdge(metaEdge.getRootGraphIndex(), true);
                this.metaEdgeMap.remove(node);
                this.newEdgeMap.remove(metaEdge);
            }
            List edges = this.metaGroup.getOuterEdges();
            for (CyEdge edge : edges) {
                if (edge.getTarget() != node && edge.getSource() != node) continue;
                CyEdge newEdge = this.createMetaEdge(edge, null, false);
            }
        }
        if (!this.isCollapsed) {
            return;
        }
        NodeView nv = this.networkView.getNodeView((Node)this.groupNode);
        double metaX = nv.getXPosition();
        double metaY = nv.getYPosition();
        nv = this.networkView.getNodeView((Node)node);
        double X = nv.getXPosition();
        double Y = nv.getYPosition();
        String nodeName = node.getIdentifier();
        this.setXHintAttr(this.nodeAttributes, nodeName, metaX - X);
        this.setYHintAttr(this.nodeAttributes, nodeName, metaY - Y);
        if (metaMap.containsKey(node)) {
            MetaNode child = metaMap.get(node);
            child.collapse(this.recursive, this.multipleEdges, false, this.networkView);
        }
        this.hideNode(node);
        this.updateAttributes();
        this.updateDisplay();
    }

    public void nodeRemoved(CyNode node) {
        this.update(null);
        if (this.isCollapsed) {
            this.restoreNode(node, null);
        }
        ArrayList<CyEdge> removeEdges = new ArrayList<CyEdge>();
        for (CyEdge metaEdge : this.newEdgeMap.keySet()) {
            List<CyEdge> edgeList = this.newEdgeMap.get(metaEdge);
            ListIterator<CyEdge> edgeIter = edgeList.listIterator();
            while (edgeIter.hasNext()) {
                CyEdge edge = edgeIter.next();
                if (edge.getTarget() != node && edge.getSource() != node) continue;
                edgeIter.remove();
                if (!this.isCollapsed) continue;
                this.restoreEdge(edge);
            }
            if (edgeList.size() != 0) continue;
            removeEdges.add(metaEdge);
        }
        Iterator<Object> mEdge = removeEdges.iterator();
        while (mEdge.hasNext()) {
            this.newEdgeMap.remove(mEdge.next());
        }
        for (CyEdge edge : this.metaGroup.getOuterEdges()) {
            if (edge.getTarget() != node && edge.getSource() != node) continue;
            CyEdge metaEdge = this.createMetaEdge(edge, null, false);
            if (this.isCollapsed) continue;
            this.hideEdge(metaEdge);
        }
        this.updateAttributes();
        this.updateDisplay();
    }

    public void recollapse(boolean recursive, boolean multipleEdges, CyNetworkView view) {
        this.update(view);
        if (this.newEdgeMap == null) {
            this.createMetaEdges();
        }
        this.isCollapsed = true;
        this.expand(recursive, view, true);
        this.collapse(recursive, multipleEdges, false, view);
    }

    public void collapse(boolean recursive, boolean multipleEdges, boolean updateNetwork, CyNetworkView view) {
        if (this.isCollapsed) {
            return;
        }
        this.update(view);
        this.multipleEdges = multipleEdges;
        this.recursive = recursive;
        this.restoreNode(this.groupNode, this.hideNodes(recursive, multipleEdges));
        this.createMetaEdges();
        this.isCollapsed = true;
        this.metaGroup.setState(2);
        if (updateNetwork) {
            this.updateDisplay();
        }
    }

    public void expand(boolean recursive, CyNetworkView view, boolean update) {
        if (!this.isCollapsed) {
            return;
        }
        this.update(view);
        int[] edgeArray = this.network.getAdjacentEdgeIndicesArray(this.groupNode.getRootGraphIndex(), true, true, true);
        if (edgeArray != null) {
            for (int edgeIndex = 0; edgeIndex < edgeArray.length; ++edgeIndex) {
                CyEdge edge = (CyEdge)this.network.getEdge(edgeArray[edgeIndex]);
                if (!this.isMetaEdge(edge)) {
                    this.metaGroup.addOuterEdge(edge);
                }
                this.hideEdge(edge);
            }
        }
        this.restoreNodes();
        this.restoreEdges();
        this.network.hideNode((Node)this.groupNode);
        if (update) {
            this.updateDisplay();
        }
        this.isCollapsed = false;
        this.metaGroup.setState(1);
        this.restoreMetaNodes(true);
    }

    public CyEdge createMetaEdge(CyEdge edge, CyNode partner, boolean ignoreCollapsed) {
        CyNode source = (CyNode)edge.getSource();
        CyNode target = (CyNode)edge.getTarget();
        CyEdge newEdge = null;
        if (partner == null) {
            partner = this.getPartner(edge);
        }
        if (!ignoreCollapsed && this.isNodeHidden(partner)) {
            MetaNode parent = this.getParent(partner);
            if (parent == null) {
                return null;
            }
            if (!metaMap.containsKey(parent.groupNode) || this.isNodeHidden(parent.groupNode)) {
                return null;
            }
            if (!this.multipleEdges && this.metaEdgeMap.containsKey(parent.groupNode) && parent.isCollapsed) {
                return this.metaEdgeMap.get(parent.groupNode);
            }
            newEdge = this.getMetaEdge(this.groupNode, parent.groupNode, edge);
            this.addMetaEdge(newEdge, parent.groupNode, edge);
            parent.addMetaEdge(newEdge, this.groupNode, edge);
        } else if (!this.multipleEdges && this.metaEdgeMap.containsKey(partner)) {
            if (MetaNode.getMetaNode(partner) != null && !MetaNode.getMetaNode((CyNode)partner).isCollapsed) {
                return null;
            }
            newEdge = this.metaEdgeMap.get(partner);
            this.addMetaEdge(newEdge, partner, edge);
        } else {
            if (source == partner) {
                target = this.groupNode;
            } else {
                source = this.groupNode;
            }
            newEdge = this.getMetaEdge(source, target, edge);
            this.addMetaEdge(newEdge, partner, edge);
        }
        return newEdge;
    }

    public void addMetaEdge(CyEdge newEdge, CyNode partner, CyEdge edge) {
        if (!this.newEdgeMap.containsKey(newEdge)) {
            this.newEdgeMap.put(newEdge, new ArrayList());
        }
        this.newEdgeMap.get(newEdge).add(edge);
        this.metaEdgeMap.put(partner, newEdge);
    }

    public int getDescendentCount() {
        return this.nDescendents;
    }

    public void createNetworkFromGroup() {
        List nodes = this.metaGroup.getNodes();
        List edges = this.metaGroup.getInnerEdges();
        CyNetwork new_net = Cytoscape.createNetwork((Collection)nodes, (Collection)edges, (String)this.metaGroup.getGroupName(), (CyNetwork)Cytoscape.getCurrentNetwork());
        CyNetworkView new_view = Cytoscape.createNetworkView((CyNetwork)new_net, (String)"group");
        for (CyNode node : nodes) {
            double xValue = this.getXHintAttr(this.nodeAttributes, node.getIdentifier(), 0.0);
            double yValue = this.getYHintAttr(this.nodeAttributes, node.getIdentifier(), 0.0);
            NodeView v = new_view.getNodeView((Node)node);
            v.setXPosition(xValue);
            v.setYPosition(yValue);
        }
        new_view.setVisualStyle(Cytoscape.getCurrentNetworkView().getVisualStyle().getName());
        new_view.fitContent();
    }

    private CyEdge getMetaEdge(CyNode source, CyNode target, CyEdge edge) {
        String identifier = "meta-" + edge.getIdentifier();
        String interaction = this.edgeAttributes.getStringAttribute(edge.getIdentifier(), "interaction");
        CyEdge newEdge = Cytoscape.getCyEdge((String)source.getIdentifier(), (String)identifier, (String)target.getIdentifier(), (String)("meta-" + interaction));
        return newEdge;
    }

    private void createMetaEdges() {
        List nodes = this.metaGroup.getNodes();
        List edges = this.metaGroup.getOuterEdges();
        for (CyEdge edge : edges) {
            CyEdge newEdge = this.createMetaEdge(edge, null, false);
            if (newEdge == null) continue;
            this.network.addEdge((Edge)newEdge);
            if (this.networkView == null) continue;
            this.networkView.applyVizMap(newEdge);
        }
    }

    private void restoreEdges() {
        List edges = this.metaGroup.getOuterEdges();
        for (CyEdge edge : edges) {
            String identifier = edge.getIdentifier();
            CyNode partner = this.getPartner(edge);
            if (MetaNode.getMetaNode(partner) != null && !MetaNode.getMetaNode((CyNode)partner).isCollapsed) continue;
            if (this.isNodeHidden(partner)) {
                MetaNode parent = this.getParent(partner);
                this.restoreEdge(parent.createMetaEdge(edge, this.getLocalNode(edge), false));
                continue;
            }
            this.restoreEdge(edge);
        }
        edges = this.metaGroup.getInnerEdges();
        for (CyEdge edge : edges) {
            this.restoreEdge(edge);
        }
    }

    private void restoreEdge(CyEdge edge) {
        if (edge == null) {
            return;
        }
        CyNode partner = this.getPartner(edge);
        if (!this.isNodeHidden(partner)) {
            this.network.restoreEdge((Edge)edge);
            if (this.networkView != null) {
                this.networkView.applyVizMap(edge);
            }
        }
    }

    private void hideEdge(CyEdge edge) {
        this.network.hideEdge((Edge)edge);
    }

    private void restoreNodes() {
        NodeView metaNodeView = this.networkView.getNodeView((Node)this.groupNode);
        double xCenter = 0.0;
        double yCenter = 0.0;
        if (metaNodeView != null) {
            xCenter = metaNodeView.getXPosition();
            yCenter = metaNodeView.getYPosition();
        }
        double xOffset = 0.0;
        double yOffset = 0.0;
        List nodes = this.metaGroup.getNodes();
        for (CyNode node : nodes) {
            double xValue = this.getXHintAttr(this.nodeAttributes, node.getIdentifier(), xCenter);
            double yValue = this.getYHintAttr(this.nodeAttributes, node.getIdentifier(), yCenter);
            Dimension d = new Dimension();
            d.setSize(xValue, yValue);
            if (hiddenNodes.containsKey(node) && hiddenNodes.get(node) == Boolean.FALSE) continue;
            this.restoreNode(node, d);
        }
    }

    private void restoreMetaNodes(boolean update) {
        if (this.childMetaNodes == null) {
            return;
        }
        for (int i = this.childMetaNodes.size() - 1; i >= 0; --i) {
            MetaNode child = this.childMetaNodes.get(i);
            child.expand(true, this.networkView, update);
        }
        this.childMetaNodes = null;
    }

    private Dimension hideNodes(boolean recursive, boolean multipleEdges) {
        CyNode node;
        int i;
        List nodes = this.metaGroup.getNodes();
        Iterator nodeIter = nodes.iterator();
        double xCenter = 0.0;
        double yCenter = 0.0;
        Double[] xLocations = new Double[nodes.size()];
        Double[] yLocations = new Double[nodes.size()];
        int averageCount = 0;
        for (i = 0; i < nodes.size(); ++i) {
            NodeView nodeView;
            node = (CyNode)nodes.get(i);
            if (metaMap.containsKey(node)) {
                MetaNode child = metaMap.get(node);
                if (!child.isCollapsed) {
                    if (this.childMetaNodes == null) {
                        this.childMetaNodes = new ArrayList<MetaNode>();
                    }
                    this.childMetaNodes.add(child);
                    child.collapse(recursive, multipleEdges, false, this.networkView);
                }
            }
            if ((nodeView = this.networkView.getNodeView((Node)node)) != null && !this.isNodeHidden(node)) {
                ++averageCount;
                xLocations[i] = new Double(nodeView.getXPosition());
                yLocations[i] = new Double(nodeView.getYPosition());
                xCenter += xLocations[i].doubleValue();
                yCenter += yLocations[i].doubleValue();
                continue;
            }
            xLocations[i] = null;
            yLocations[i] = null;
        }
        xCenter /= (double)averageCount;
        yCenter /= (double)averageCount;
        for (i = 0; i < nodes.size(); ++i) {
            node = (CyNode)nodes.get(i);
            String nodeName = node.getIdentifier();
            if (xLocations[i] == null) {
                this.setXHintAttr(this.nodeAttributes, nodeName, 0.0);
            } else {
                this.setXHintAttr(this.nodeAttributes, nodeName, xCenter - xLocations[i]);
            }
            if (yLocations[i] == null) {
                this.setYHintAttr(this.nodeAttributes, nodeName, 0.0);
            } else {
                this.setYHintAttr(this.nodeAttributes, nodeName, yCenter - yLocations[i]);
            }
            this.hideNode(node);
        }
        Dimension dim = new Dimension();
        dim.setSize(xCenter, yCenter);
        return dim;
    }

    private void hideNode(CyNode node) {
        this.network.hideNode((Node)node);
        hiddenNodes.put(node, Boolean.TRUE);
    }

    private void restoreNode(CyNode node, Dimension center) {
        this.network.restoreNode((Node)node);
        hiddenNodes.put(node, Boolean.FALSE);
        if (center != null) {
            NodeView nv = this.networkView.getNodeView((Node)node);
            if (nv == null) {
                nv = this.networkView.addNodeView(node.getRootGraphIndex());
            }
            if (nv != null) {
                this.networkView.applyVizMap(node);
                nv.setXPosition(center.getWidth());
                nv.setYPosition(center.getHeight());
            }
        }
    }

    private boolean isNodeHidden(CyNode node) {
        return hiddenNodes.containsKey(node) && hiddenNodes.get(node) == Boolean.TRUE;
    }

    private CyNode getPartner(CyEdge edge) {
        CyNode source = (CyNode)edge.getSource();
        CyNode target = (CyNode)edge.getTarget();
        if (source == this.groupNode || this.metaGroup.getNodes().contains(source)) {
            return target;
        }
        return source;
    }

    private CyNode getLocalNode(CyEdge edge) {
        CyNode source = (CyNode)edge.getSource();
        CyNode target = (CyNode)edge.getTarget();
        if (source == this.groupNode || this.metaGroup.getNodes().contains(source)) {
            return source;
        }
        return target;
    }

    private List<CyEdge> getPartnerEdgeList(CyEdge metaEdge) {
        CyNode partner = this.getPartner(metaEdge);
        if (!metaMap.containsKey(partner)) {
            return new ArrayList<CyEdge>(0);
        }
        MetaNode metaPartner = metaMap.get(partner);
        return metaPartner.newEdgeMap.get(metaEdge);
    }

    private MetaNode getParent(CyNode node) {
        List groupList = node.getGroups();
        if (groupList == null) {
            return null;
        }
        for (CyGroup group : groupList) {
            MetaNode meta;
            if (!metaMap.containsKey(group.getGroupNode()) || (meta = metaMap.get(group.getGroupNode())) == this || !meta.isCollapsed) continue;
            return meta;
        }
        return null;
    }

    private boolean isMetaEdge(CyEdge edge) {
        String interaction = this.edgeAttributes.getStringAttribute(edge.getIdentifier(), "interaction");
        return interaction.startsWith("meta-");
    }

    private void updateDisplay() {
        this.networkView.updateView();
    }

    private void updateAttributes() {
        this.nDescendents = this.nChildren = this.metaGroup.getNodes().size();
        for (CyNode node : this.metaGroup.getNodes()) {
            if (!metaMap.containsKey(node)) continue;
            MetaNode mn = metaMap.get(node);
            this.nDescendents += mn.getDescendentCount() - 1;
        }
        this.nodeAttributes.setAttribute(this.groupNode.getIdentifier(), CHILDREN_ATTR, new Integer(this.nChildren));
        this.nodeAttributes.setAttribute(this.groupNode.getIdentifier(), DESCENDENTS_ATTR, new Integer(this.nDescendents));
    }

    private void setXHintAttr(CyAttributes nodeAttributes, String nodeName, double value) {
        String attr = this.metaGroup.getGroupName() + ":" + X_HINT_ATTR;
        nodeAttributes.setAttribute(nodeName, attr, Double.valueOf(value));
        nodeAttributes.setUserVisible(attr, false);
    }

    private void setYHintAttr(CyAttributes nodeAttributes, String nodeName, double value) {
        String attr = this.metaGroup.getGroupName() + ":" + Y_HINT_ATTR;
        nodeAttributes.setAttribute(nodeName, attr, Double.valueOf(value));
        nodeAttributes.setUserVisible(attr, false);
    }

    private double getXHintAttr(CyAttributes nodeAttributes, String nodeName, double center) {
        String attr = this.metaGroup.getGroupName() + ":" + X_HINT_ATTR;
        if (nodeAttributes.hasAttribute(nodeName, attr)) {
            return center - nodeAttributes.getDoubleAttribute(nodeName, attr);
        }
        if (nodeAttributes.hasAttribute(nodeName, X_HINT_ATTR)) {
            return center - nodeAttributes.getDoubleAttribute(nodeName, X_HINT_ATTR);
        }
        return center;
    }

    private double getYHintAttr(CyAttributes nodeAttributes, String nodeName, double center) {
        String attr = this.metaGroup.getGroupName() + ":" + Y_HINT_ATTR;
        if (nodeAttributes.hasAttribute(nodeName, attr)) {
            return center - nodeAttributes.getDoubleAttribute(nodeName, attr);
        }
        if (nodeAttributes.hasAttribute(nodeName, Y_HINT_ATTR)) {
            return center - nodeAttributes.getDoubleAttribute(nodeName, Y_HINT_ATTR);
        }
        return center;
    }
}

