/*
 * Decompiled with CFR 0.152.
 */
package glay.util;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.groups.CyGroupViewer;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.view.CyNetworkView;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SampleGroupViewer
extends CytoscapePlugin
implements CyGroupViewer {
    public static final String viewerName = "sampleGroupViewer";
    public static final double VERSION = 1.0;
    private static GroupPanel groupPanel = null;

    public SampleGroupViewer() {
        groupPanel = new GroupPanel(this);
        Cytoscape.getDesktop().getCytoPanel(7).add("GroupsTest", (Component)groupPanel);
        CyGroupManager.registerGroupViewer((CyGroupViewer)this);
    }

    public String getViewerName() {
        return viewerName;
    }

    public void groupCreated(CyGroup group) {
        groupPanel.groupCreated(group);
    }

    public void groupCreated(CyGroup group, CyNetworkView view) {
        CyNode node = group.getGroupNode();
        view.getNetwork().removeNode(node.getRootGraphIndex(), false);
        groupPanel.groupCreated(group);
    }

    public void groupWillBeRemoved(CyGroup group) {
        groupPanel.groupRemoved(group);
    }

    public void groupChanged(CyGroup group, CyNode node, CyGroupViewer.ChangeType change) {
        groupPanel.groupChanged(group);
    }

    public class GroupPanel
    extends JPanel
    implements ListSelectionListener {
        CyGroupViewer viewer;
        JList navList;
        DefaultListModel listModel;

        public GroupPanel(CyGroupViewer viewer) {
            this.viewer = viewer;
            this.listModel = new DefaultListModel();
            this.navList = new JList(this.listModel);
            this.navList.setSelectionMode(2);
            this.navList.setLayoutOrientation(0);
            this.navList.setVisibleRowCount(20);
            this.navList.addListSelectionListener(this);
            JScrollPane listView = new JScrollPane(this.navList);
            listView.setBorder(BorderFactory.createEtchedBorder());
            this.navList.setBackground(Cytoscape.getDesktop().getBackground());
            listView.setBackground(Cytoscape.getDesktop().getBackground());
            this.setPreferredSize(new Dimension(240, 600));
            this.navList.setPreferredSize(new Dimension(240, 580));
            this.add(listView);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                CyNetwork network = Cytoscape.getCurrentNetwork();
                for (int i = 0; i < this.listModel.getSize(); ++i) {
                    CyGroup group;
                    if (this.navList.getSelectionModel().isSelectedIndex(i)) {
                        group = (CyGroup)this.listModel.getElementAt(i);
                        network.setSelectedNodeState((Collection)group.getNodes(), true);
                        continue;
                    }
                    group = (CyGroup)this.listModel.getElementAt(i);
                    network.setSelectedNodeState((Collection)group.getNodes(), false);
                }
                Cytoscape.getCurrentNetworkView().updateView();
            }
        }

        public void groupCreated(CyGroup group) {
            this.listModel.addElement(group);
        }

        public void groupRemoved(CyGroup group) {
            this.listModel.removeElement(group);
        }

        public void groupChanged(CyGroup group) {
        }
    }
}

