/*
 * Decompiled with CFR 0.152.
 */
package glay.util;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import java.util.Random;

public class GLayVisualStyle {
    public static VisualStyle createClusterVisualStyle(CyNetwork network) {
        VisualMappingManager vmManager = Cytoscape.getVisualMappingManager();
        NodeAppearanceCalculator nodeAppCalc = new NodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeAppCalc = new EdgeAppearanceCalculator();
        CalculatorCatalog calculatorCatalog = vmManager.getCalculatorCatalog();
        if (calculatorCatalog.getVisualStyle("GLay") != null) {
            return calculatorCatalog.getVisualStyle("GLay");
        }
        DiscreteMapping edgeColorMapping = new DiscreteMapping((Object)Color.BLACK, 0);
        edgeColorMapping.setControllingAttributeName("class", network, false);
        edgeColorMapping.putMapValue((Object)0, (Object)Color.BLACK);
        edgeColorMapping.putMapValue((Object)1, (Object)Color.DARK_GRAY);
        DiscreteMapping edgeOpacityMapping = new DiscreteMapping((Object)255, 0);
        edgeOpacityMapping.setControllingAttributeName("class", network, false);
        edgeOpacityMapping.putMapValue((Object)0, (Object)220);
        edgeOpacityMapping.putMapValue((Object)1, (Object)120);
        DiscreteMapping edgeTypeMapping = new DiscreteMapping((Object)LineStyle.SOLID, 0);
        edgeTypeMapping.setControllingAttributeName("class", network, false);
        edgeTypeMapping.putMapValue((Object)0, (Object)LineStyle.SOLID);
        edgeTypeMapping.putMapValue((Object)1, (Object)LineStyle.LONG_DASH);
        BasicCalculator edgeColorCal = new BasicCalculator("Edge Color Calculator", (ObjectMapping)edgeColorMapping, VisualPropertyType.EDGE_COLOR);
        BasicCalculator edgeOpacityCal = new BasicCalculator("Edge Opacity Calculator", (ObjectMapping)edgeOpacityMapping, VisualPropertyType.EDGE_OPACITY);
        BasicCalculator edgeTypeCal = new BasicCalculator("Edge Opacity Calculator", (ObjectMapping)edgeTypeMapping, VisualPropertyType.EDGE_LINE_STYLE);
        edgeAppCalc.setCalculator((Calculator)edgeColorCal);
        edgeAppCalc.setCalculator((Calculator)edgeOpacityCal);
        edgeAppCalc.setCalculator((Calculator)edgeTypeCal);
        DiscreteMapping nodeLabelOpacityMapping = new DiscreteMapping((Object)255, 1);
        nodeLabelOpacityMapping.setControllingAttributeName("listActive", network, false);
        nodeLabelOpacityMapping.putMapValue((Object)0, (Object)70);
        nodeLabelOpacityMapping.putMapValue((Object)1, (Object)255);
        BasicCalculator nodeLabelOpacityCal = new BasicCalculator("Node Label Opacity Cal", (ObjectMapping)nodeLabelOpacityMapping, VisualPropertyType.NODE_LABEL_OPACITY);
        nodeAppCalc.setCalculator((Calculator)nodeLabelOpacityCal);
        DiscreteMapping nodeOpacityMapping = new DiscreteMapping((Object)255, 1);
        nodeOpacityMapping.setControllingAttributeName("listActive", network, false);
        nodeOpacityMapping.putMapValue((Object)0, (Object)70);
        nodeOpacityMapping.putMapValue((Object)1, (Object)240);
        BasicCalculator nodeOpacityCal = new BasicCalculator("Node Opacity cal", (ObjectMapping)nodeOpacityMapping, VisualPropertyType.NODE_OPACITY);
        nodeAppCalc.setCalculator((Calculator)nodeOpacityCal);
        DiscreteMapping nodeColorMapper = new DiscreteMapping((Object)Color.RED, "membership", 1);
        Random rand = new Random();
        float[] components = new float[3];
        for (int i = 0; i < 50; ++i) {
            components[0] = rand.nextFloat();
            components[1] = rand.nextFloat();
            components[2] = (float)((double)(rand.nextFloat() / 3.0f) + 0.66);
            int col = Color.HSBtoRGB(components[0], components[1], components[2]);
            nodeColorMapper.putMapValue((Object)i, (Object)new Color(col));
        }
        BasicCalculator nodeCal = new BasicCalculator("Membership Cal", (ObjectMapping)nodeColorMapper, VisualPropertyType.NODE_FILL_COLOR);
        nodeAppCalc.setCalculator((Calculator)nodeCal);
        DiscreteMapping nodeSizeMapper = new DiscreteMapping((Object)50, 1);
        nodeSizeMapper.setControllingAttributeName("type", network, false);
        nodeSizeMapper.putMapValue((Object)0, (Object)50);
        nodeSizeMapper.putMapValue((Object)1, (Object)100);
        nodeSizeMapper.putMapValue((Object)2, (Object)80);
        BasicCalculator nodeSizeCal = new BasicCalculator("Node Size Calculator", (ObjectMapping)nodeSizeMapper, VisualPropertyType.NODE_SIZE);
        nodeAppCalc.setCalculator((Calculator)nodeSizeCal);
        DiscreteMapping nodeShapeMapper = new DiscreteMapping((Object)NodeShape.ELLIPSE, 1);
        nodeShapeMapper.setControllingAttributeName("type", network, false);
        nodeShapeMapper.putMapValue((Object)1, (Object)NodeShape.ELLIPSE);
        nodeShapeMapper.putMapValue((Object)0, (Object)NodeShape.ELLIPSE);
        nodeShapeMapper.putMapValue((Object)2, (Object)NodeShape.ELLIPSE);
        BasicCalculator nodeShapeCal = new BasicCalculator("Node Shape Calculator", (ObjectMapping)nodeShapeMapper, VisualPropertyType.NODE_SHAPE);
        nodeAppCalc.setCalculator((Calculator)nodeShapeCal);
        PassThroughMapping nodeLabelMapper = new PassThroughMapping((Object)new String(), "ID");
        BasicCalculator nodeLabelCalculator = new BasicCalculator("ID", (ObjectMapping)nodeLabelMapper, VisualPropertyType.NODE_LABEL);
        nodeAppCalc.setCalculator((Calculator)nodeLabelCalculator);
        DiscreteMapping nodeLineWidthMapper = new DiscreteMapping((Object)4, 1);
        nodeLineWidthMapper.setControllingAttributeName("type", network, false);
        nodeLineWidthMapper.putMapValue((Object)1, (Object)10);
        nodeLineWidthMapper.putMapValue((Object)0, (Object)4);
        nodeLineWidthMapper.putMapValue((Object)2, (Object)8);
        BasicCalculator nodeLineWidthCal = new BasicCalculator("Node Line Width Calculator", (ObjectMapping)nodeLineWidthMapper, VisualPropertyType.NODE_LINE_WIDTH);
        nodeAppCalc.setCalculator((Calculator)nodeLineWidthCal);
        DiscreteMapping nodeBorderOpacityMapper = new DiscreteMapping((Object)200, 1);
        nodeBorderOpacityMapper.setControllingAttributeName("type", network, false);
        nodeBorderOpacityMapper.putMapValue((Object)1, (Object)150);
        BasicCalculator nodeBorderOpacityCal = new BasicCalculator("Node Border Opacity Calculator", (ObjectMapping)nodeBorderOpacityMapper, VisualPropertyType.NODE_BORDER_OPACITY);
        nodeAppCalc.setCalculator((Calculator)nodeBorderOpacityCal);
        GlobalAppearanceCalculator gac = vmManager.getVisualStyle().getGlobalAppearanceCalculator();
        NodeAppearanceCalculator nac = nodeAppCalc;
        EdgeAppearanceCalculator eac = edgeAppCalc;
        gac.setDefaultBackgroundColor(Color.white);
        VisualStyle visualStyle = new VisualStyle("GLay", nac, eac, gac);
        calculatorCatalog.addVisualStyle(visualStyle);
        VisualPropertyType.NODE_FILL_COLOR.setDefault(visualStyle, (Object)new Color(200, 200, 200));
        VisualPropertyType.NODE_SHAPE.setDefault(visualStyle, (Object)NodeShape.ELLIPSE);
        VisualPropertyType.EDGE_COLOR.setDefault(visualStyle, (Object)new Color(50, 150, 200));
        VisualPropertyType.EDGE_LINE_WIDTH.setDefault(visualStyle, (Object)4);
        VisualPropertyType.NODE_SIZE.setDefault(visualStyle, (Object)50);
        VisualPropertyType.NODE_BORDER_COLOR.setDefault(visualStyle, (Object)new Color(100, 100, 100));
        return visualStyle;
    }
}

