/*
 * Decompiled with CFR 0.152.
 */
package glay.util;

import cytoscape.Cytoscape;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public class GLayProgressMonitor
extends JPanel
implements PropertyChangeListener {
    private ProgressMonitor progressMonitor;
    private Task task;
    private JLabel jLabel1;
    private JProgressBar progressBar;

    public GLayProgressMonitor() {
        this.initComponents();
        System.out.println("Progress bar created.");
        this.progressMonitor = new ProgressMonitor((Component)Cytoscape.getDesktop(), "Executing", "exe...", 0, 100);
        this.progressMonitor.setProgress(0);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String progressString = new String("progress");
        if (progressString.equalsIgnoreCase(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            String message = String.format("Completed %d%%.\n", progress);
            this.progressMonitor.setNote(message);
        }
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Progress");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -1, 299, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(3, 3, 3).addComponent(this.progressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            try {
                Thread.sleep(1000L);
                System.out.println("Executing...");
                while (progress < 100 && !this.isCancelled()) {
                    Thread.sleep(random.nextInt(1000));
                    this.setProgress(Math.min(progress += random.nextInt(10), 100));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void done() {
            GLayProgressMonitor.this.progressMonitor.setProgress(0);
        }
    }
}

