/*
 * Decompiled with CFR 0.152.
 */
package glay.util;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import glay.util.CommunityAlgorithm;
import glay.util.MaxFunKW;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import metaNodePlugin2.model.MetaNode;

public class FastGreedy2
extends CommunityAlgorithm
implements Runnable {
    private double modularity = 0.0;
    private int mode;

    public void setMode(int mode) {
        this.mode = mode;
    }

    public double getModularity() {
        return this.modularity;
    }

    @Override
    public void execute() {
        int i;
        System.out.println(this.nodeCount);
        System.out.println(this.edgeCount);
        System.out.println(this.network.getNodeCount());
        System.out.println(this.network.getEdgeCount());
        this.progress = 0;
        double[] ai = new double[this.nodeCount];
        double qInitial = 0.0;
        int counter = 0;
        List nodeList = this.network.nodesList();
        int[] nodeIndexes = this.network.getNodeIndicesArray();
        Arrays.sort(nodeIndexes);
        int[] arr$ = nodeIndexes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int index;
            this.graphIndex[counter] = index = arr$[i$];
            this.graphNodeName[counter] = this.network.getNode(index).getIdentifier();
            this.membership[counter] = counter;
            ai[counter] = (double)this.network.getDegree(this.graphIndex[counter]) / (2.0 * (double)this.edgeCount);
            qInitial -= ai[counter] * ai[counter];
            ++counter;
        }
        SparseDoubleMatrix2D deltaQMx = new SparseDoubleMatrix2D(this.nodeCount, this.nodeCount);
        MaxFunKW func = new MaxFunKW(ai, this.mode);
        double maxDeltaQ = 0.0;
        double q = 0.0;
        int maxI = 0;
        int maxJ = 0;
        double deltaQ = 0.0;
        for (int i2 = 0; i2 < this.nodeCount; ++i2) {
            for (int j = 0; j < this.nodeCount; ++j) {
                if (i2 == j || this.network.getEdgeCount(this.network.getNode(this.graphIndex[i2]), this.network.getNode(this.graphIndex[j]), false) <= 0 && this.network.getEdgeCount(this.network.getNode(this.graphIndex[j]), this.network.getNode(this.graphIndex[i2]), false) <= 0) continue;
                deltaQ = (1.0 / (double)(2 * this.edgeCount) - (double)(this.network.getDegree(this.graphIndex[i2]) * this.network.getDegree(this.graphIndex[j])) / (4.0 * Math.pow(this.edgeCount, 2.0))) * 2.0;
                deltaQMx.setQuick(i2, j, deltaQ);
                if (!(maxDeltaQ <= deltaQ)) continue;
                maxDeltaQ = deltaQ;
                maxI = i2;
                maxJ = j;
            }
        }
        if (maxI > maxJ) {
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        q = qInitial;
        counter = 0;
        System.out.println("qInitial:" + qInitial);
        while (maxDeltaQ > 0.0) {
            this.progress = (int)(100.0 * (double)(++counter) / (double)this.nodeCount);
            q += maxDeltaQ;
            for (int k = 0; k < this.nodeCount; ++k) {
                if (k == maxJ || k == maxI) continue;
                if (deltaQMx.getQuick(maxI, k) != 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) + deltaQMx.getQuick(maxI, k));
                    continue;
                }
                if (deltaQMx.getQuick(maxI, k) == 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) - 2.0 * ai[maxI] * ai[k]);
                    continue;
                }
                if (deltaQMx.getQuick(maxJ, k) != 0.0 || deltaQMx.getQuick(maxI, k) == 0.0) continue;
                deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxI, k) - 2.0 * ai[maxJ] * ai[k]);
            }
            int membershipI = this.membership[maxI];
            int membershipJ = this.membership[maxJ];
            for (int k = 0; k < this.nodeCount; ++k) {
                deltaQMx.setQuick(k, maxJ, deltaQMx.getQuick(maxJ, k));
                deltaQMx.setQuick(maxI, k, 0.0);
                deltaQMx.setQuick(k, maxI, 0.0);
                if (this.membership[k] != membershipI) continue;
                this.membership[k] = membershipJ;
            }
            ai[maxJ] = ai[maxI] + ai[maxJ];
            ai[maxI] = 0.0;
            deltaQMx.trimToSize();
            maxDeltaQ = 0.0;
            maxI = 0;
            maxJ = 0;
            func.reset(ai);
            deltaQMx.forEachNonZero((IntIntDoubleFunction)func);
            maxDeltaQ = func.max;
            maxI = func.row;
            maxJ = func.column;
            if (maxI <= maxJ) continue;
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        HashMap<Integer, Integer> membershipMapping = new HashMap<Integer, Integer>();
        int index = 0;
        for (i = 0; i < this.membership.length; ++i) {
            if (membershipMapping.containsKey(new Integer(this.membership[i]))) continue;
            membershipMapping.put(new Integer(this.membership[i]), new Integer(index));
            ++index;
        }
        for (i = 0; i < this.membership.length; ++i) {
            this.membership[i] = membershipMapping.get(new Integer(this.membership[i]));
        }
        FastGreedy2.assignMembership(this.network, this.graphIndex, this.membership, membershipMapping);
        this.modularity = q;
        this.progress = 100;
    }

    private static void assignMembership(CyNetwork network, int[] graphIndex, int[] membership, HashMap<Integer, Integer> membershipMapping) {
        int i;
        CyAttributes attrN = Cytoscape.getNodeAttributes();
        CyAttributes attrE = Cytoscape.getEdgeAttributes();
        ArrayList nodeList = new ArrayList();
        for (i = 0; i < membershipMapping.size(); ++i) {
            nodeList.add(new ArrayList());
        }
        for (i = 0; i < network.getNodeCount(); ++i) {
            attrN.setAttribute(network.getNode(graphIndex[i]).getIdentifier(), "membership", Integer.valueOf(membership[i]));
            attrN.setAttribute(network.getNode(graphIndex[i]).getIdentifier(), "type", Integer.valueOf(0));
            attrN.setAttribute(network.getNode(graphIndex[i]).getIdentifier(), "listActive", Integer.valueOf(1));
            ((List)nodeList.get(membership[i])).add(network.getNode(graphIndex[i]));
        }
        for (i = 0; i < nodeList.size(); ++i) {
            CyGroup group = CyGroupManager.createGroup((String)(network.getIdentifier() + "_" + i + "[CLUSTER]"), (List)((List)nodeList.get(i)), (String)"metaNode");
            attrN.setAttribute(group.getGroupNode().getIdentifier(), "type", Integer.valueOf(1));
            CyGroupManager.setGroupViewer((CyGroup)group, (String)"metaNode", (CyNetworkView)Cytoscape.getCurrentNetworkView(), (boolean)true);
        }
        int intraEdge = 0;
        int interEdge = 0;
        boolean totalEdge = false;
        Iterator it = network.edgesIterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (attrN.getIntegerAttribute(e.getSource().getIdentifier(), "membership") == attrN.getIntegerAttribute(e.getTarget().getIdentifier(), "membership")) {
                attrE.setAttribute(e.getIdentifier(), "class", Integer.valueOf(0));
                ++intraEdge;
                continue;
            }
            attrE.setAttribute(e.getIdentifier(), "class", Integer.valueOf(1));
            ++interEdge;
        }
    }

    @Override
    public void run() {
        this.reset();
        this.execute();
    }

    public void reset() {
        MetaNode.expandAll();
        List grpList = CyGroupManager.getGroupList();
        for (int i = 0; i < grpList.size(); ++i) {
            CyGroup grp = (CyGroup)grpList.get(i);
            if (grp.getGroupName().startsWith(this.network.getIdentifier())) {
                CyGroupManager.removeGroup((CyGroup)grp);
                continue;
            }
            System.out.println("WTF");
        }
    }
}

