/*
 * Decompiled with CFR 0.152.
 */
package glay.util;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import csplugins.layout.algorithms.force.ForceDirectedLayout;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.Node;
import glay.util.Fun;
import glay.util.GLayVisualStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import metaNodePlugin2.model.MetaNode;

public class FastGreedy
implements Runnable {
    private volatile int progress;

    @Override
    public void run() {
        this.run_sm(Cytoscape.getCurrentNetwork());
        ForceDirectedLayout alg = new ForceDirectedLayout();
        for (int j = 0; j < CyGroupManager.getGroupList().size(); ++j) {
            int i;
            CyGroup grp = (CyGroup)CyGroupManager.getGroupList().get(j);
            List nodeList = grp.getNodes();
            List edgeList = grp.getInnerEdges();
            int[] nodes = new int[nodeList.size()];
            int[] edges = new int[edgeList.size()];
            for (i = 0; i < nodeList.size(); ++i) {
                nodes[i] = ((CyNode)nodeList.get(i)).getRootGraphIndex();
            }
            for (i = 0; i < edgeList.size(); ++i) {
                edges[i] = ((CyEdge)edgeList.get(i)).getRootGraphIndex();
            }
            System.out.println(nodes.length);
            System.out.println(edges.length);
            alg.unlockAllNodes();
            Cytoscape.getCurrentNetworkView().applyLayout((CyLayoutAlgorithm)alg, nodes, edges);
            alg.unlockAllNodes();
        }
        VisualStyle vs = GLayVisualStyle.createClusterVisualStyle(Cytoscape.getCurrentNetwork());
        Cytoscape.getVisualMappingManager().setVisualStyle("GLay Visual" + Cytoscape.getCurrentNetwork().getIdentifier());
    }

    public int getCurrentProgress() {
        return this.progress;
    }

    public static void run_hp(CyNetwork network) {
        int nodeCount = network.getNodeCount();
        int edgeCount = network.getEdgeCount();
        int[] graphIndex = new int[nodeCount];
        int[] membership = new int[nodeCount];
        String[] graphNodeName = new String[nodeCount];
        double[] ai = new double[nodeCount];
        double qInitial = 0.0;
        ArrayList<Integer> activeRows = new ArrayList<Integer>();
        int counter = 0;
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            graphIndex[counter] = node.getRootGraphIndex();
            graphNodeName[counter] = node.getIdentifier();
            membership[counter] = counter;
            ai[counter] = (double)network.getDegree(graphIndex[counter]) / (2.0 * (double)edgeCount);
            qInitial -= ai[counter] * ai[counter];
            activeRows.add(new Integer(counter));
            ++counter;
        }
        SparseDoubleMatrix2D deltaQMx = new SparseDoubleMatrix2D(nodeCount, nodeCount);
        SparseDoubleMatrix1D rowMaxHeap = new SparseDoubleMatrix1D(nodeCount);
        SparseDoubleMatrix1D rowMaxColHeap = new SparseDoubleMatrix1D(nodeCount);
        double maxDeltaQ = 0.0;
        double q = 0.0;
        int maxI = 0;
        int maxJ = 0;
        double deltaQ = 0.0;
        double rowMax = 0.0;
        for (int i = 0; i < nodeCount; ++i) {
            rowMax = 0.0;
            for (int j = 0; j < nodeCount; ++j) {
                if (i == j || network.getEdgeCount(network.getNode(graphIndex[i]), network.getNode(graphIndex[j]), false) <= 0 && network.getEdgeCount(network.getNode(graphIndex[j]), network.getNode(graphIndex[i]), false) <= 0) continue;
                deltaQ = (1.0 / (double)(2 * edgeCount) - (double)(network.getDegree(graphIndex[i]) * network.getDegree(graphIndex[j])) / (4.0 * Math.pow(edgeCount, 2.0))) * 2.0;
                deltaQMx.setQuick(i, j, deltaQ);
                if (maxDeltaQ <= deltaQ) {
                    maxDeltaQ = deltaQ;
                    maxI = i;
                    maxJ = j;
                }
                if (!(rowMax < deltaQ)) continue;
                rowMax = deltaQ;
                rowMaxColHeap.setQuick(i, (double)j);
            }
            rowMaxHeap.setQuick(i, rowMax);
        }
        if (maxI > maxJ) {
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        q = qInitial;
        while (maxDeltaQ > 0.0) {
            int i;
            int k;
            System.out.println("> " + q + " " + maxDeltaQ);
            q += maxDeltaQ;
            rowMax = -1.7976931348623157E308;
            double update = 0.0;
            for (k = 0; k < nodeCount; ++k) {
                if (k == maxJ || k == maxI) continue;
                if (deltaQMx.getQuick(maxI, k) != 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    update = deltaQMx.getQuick(maxJ, k) + deltaQMx.getQuick(maxI, k);
                    deltaQMx.setQuick(maxJ, k, update);
                    if (!(rowMax < update)) continue;
                    rowMax = update;
                    rowMaxColHeap.setQuick(maxJ, (double)k);
                    continue;
                }
                if (deltaQMx.getQuick(maxI, k) == 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    update = deltaQMx.getQuick(maxJ, k) - 2.0 * ai[maxI] * ai[k];
                    deltaQMx.setQuick(maxJ, k, update);
                    if (!(rowMax < update)) continue;
                    rowMax = update;
                    rowMaxColHeap.setQuick(maxJ, (double)k);
                    continue;
                }
                if (deltaQMx.getQuick(maxJ, k) != 0.0 || deltaQMx.getQuick(maxI, k) == 0.0) continue;
                update = deltaQMx.getQuick(maxI, k) - 2.0 * ai[maxJ] * ai[k];
                deltaQMx.setQuick(maxJ, k, update);
                if (!(rowMax < update)) continue;
                rowMax = update;
                rowMaxColHeap.setQuick(maxJ, (double)k);
            }
            rowMaxHeap.setQuick(maxJ, rowMax);
            rowMaxHeap.setQuick(maxI, 0.0);
            for (k = 0; k < nodeCount; ++k) {
                update = deltaQMx.getQuick(maxJ, k);
                deltaQMx.setQuick(k, maxJ, update);
                if (update >= rowMaxHeap.getQuick(k)) {
                    rowMaxHeap.setQuick(k, update);
                    rowMaxColHeap.setQuick(k, (double)maxJ);
                } else if (update < rowMaxHeap.getQuick(k) && (int)rowMaxColHeap.getQuick(k) == maxJ) {
                    update = -1.7976931348623157E308;
                    for (int i2 = 0; i2 < nodeCount; ++i2) {
                        if (!(update < rowMaxHeap.getQuick(i2))) continue;
                        update = rowMaxHeap.getQuick(i2);
                        rowMaxColHeap.setQuick(k, (double)i2);
                    }
                    rowMaxHeap.setQuick(k, update);
                }
                deltaQMx.setQuick(maxI, k, 0.0);
                deltaQMx.setQuick(k, maxI, 0.0);
            }
            ai[maxJ] = ai[maxI] + ai[maxJ];
            ai[maxI] = 0.0;
            int membershipI = membership[maxI];
            int membershipJ = membership[maxJ];
            for (i = 0; i < nodeCount; ++i) {
                if (membership[i] != membershipI) continue;
                membership[i] = membershipJ;
            }
            deltaQMx.trimToSize();
            maxDeltaQ = 0.0;
            maxI = 0;
            maxJ = 0;
            for (i = 0; i < activeRows.size(); ++i) {
                if (!(maxDeltaQ < rowMaxHeap.get(((Integer)activeRows.get(i)).intValue()))) continue;
                maxDeltaQ = rowMaxHeap.get(((Integer)activeRows.get(i)).intValue());
                maxI = (Integer)activeRows.get(i);
                maxJ = (int)rowMaxColHeap.getQuick(i);
            }
            if (maxI <= maxJ) continue;
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        System.out.println(q);
    }

    public void run_sm(CyNetwork network) {
        int i;
        this.progress = 0;
        int nodeCount = network.getNodeCount();
        int edgeCount = network.getEdgeCount();
        int[] graphIndex = new int[nodeCount];
        int[] membership = new int[nodeCount];
        double[] ai = new double[nodeCount];
        String[] graphNodeName = new String[nodeCount];
        int counter = 0;
        double qInitial = 0.0;
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            graphIndex[counter] = node.getRootGraphIndex();
            graphNodeName[counter] = node.getIdentifier();
            membership[counter] = counter;
            ai[counter] = (double)network.getDegree(graphIndex[counter]) / (2.0 * (double)edgeCount);
            qInitial -= ai[counter] * ai[counter];
            ++counter;
        }
        SparseDoubleMatrix2D deltaQMx = new SparseDoubleMatrix2D(nodeCount, nodeCount);
        Fun func = new Fun(ai);
        double maxDeltaQ = 0.0;
        double q = 0.0;
        int maxI = 0;
        int maxJ = 0;
        double deltaQ = 0.0;
        for (int i2 = 0; i2 < nodeCount; ++i2) {
            for (int j = 0; j < nodeCount; ++j) {
                if (i2 == j || network.getEdgeCount(network.getNode(graphIndex[i2]), network.getNode(graphIndex[j]), false) <= 0 && network.getEdgeCount(network.getNode(graphIndex[j]), network.getNode(graphIndex[i2]), false) <= 0) continue;
                deltaQ = (1.0 / (double)(2 * edgeCount) - (double)(network.getDegree(graphIndex[i2]) * network.getDegree(graphIndex[j])) / (4.0 * Math.pow(edgeCount, 2.0))) * 2.0;
                deltaQMx.setQuick(i2, j, deltaQ);
                if (!(maxDeltaQ <= deltaQ)) continue;
                maxDeltaQ = deltaQ;
                maxI = i2;
                maxJ = j;
            }
        }
        if (maxI > maxJ) {
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        q = qInitial;
        counter = 0;
        while (maxDeltaQ > 0.0) {
            this.progress = (int)(100.0 * (double)(++counter) / (double)nodeCount);
            q += maxDeltaQ;
            for (int k = 0; k < nodeCount; ++k) {
                if (k == maxJ || k == maxI) continue;
                if (deltaQMx.getQuick(maxI, k) != 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) + deltaQMx.getQuick(maxI, k));
                    continue;
                }
                if (deltaQMx.getQuick(maxI, k) == 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) - 2.0 * ai[maxI] * ai[k]);
                    continue;
                }
                if (deltaQMx.getQuick(maxJ, k) != 0.0 || deltaQMx.getQuick(maxI, k) == 0.0) continue;
                deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxI, k) - 2.0 * ai[maxJ] * ai[k]);
            }
            int membershipI = membership[maxI];
            int membershipJ = membership[maxJ];
            for (int k = 0; k < nodeCount; ++k) {
                deltaQMx.setQuick(k, maxJ, deltaQMx.getQuick(maxJ, k));
                deltaQMx.setQuick(maxI, k, 0.0);
                deltaQMx.setQuick(k, maxI, 0.0);
                if (membership[k] != membershipI) continue;
                membership[k] = membershipJ;
            }
            ai[maxJ] = ai[maxI] + ai[maxJ];
            ai[maxI] = 0.0;
            deltaQMx.trimToSize();
            maxDeltaQ = 0.0;
            maxI = 0;
            maxJ = 0;
            func.reset(ai);
            deltaQMx.forEachNonZero((IntIntDoubleFunction)func);
            maxDeltaQ = func.max;
            maxI = func.row;
            maxJ = func.column;
            if (maxI <= maxJ) continue;
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        HashMap<Integer, Integer> membershipMapping = new HashMap<Integer, Integer>();
        int index = 0;
        for (i = 0; i < membership.length; ++i) {
            if (membershipMapping.containsKey(new Integer(membership[i]))) continue;
            membershipMapping.put(new Integer(membership[i]), new Integer(index));
            ++index;
        }
        for (i = 0; i < membership.length; ++i) {
            membership[i] = membershipMapping.get(new Integer(membership[i]));
        }
        FastGreedy.assignMembership(network, graphIndex, membership, membershipMapping);
        System.out.println(q);
        this.progress = 100;
    }

    public static void run_1(CyNetwork network) {
        int i;
        int nodeCount = network.getNodeCount();
        int edgeCount = network.getEdgeCount();
        int[] graphIndex = new int[nodeCount];
        int[] membership = new int[nodeCount];
        String[] graphNodeName = new String[nodeCount];
        int counter = 0;
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            graphIndex[counter] = node.getRootGraphIndex();
            graphNodeName[counter] = node.getIdentifier();
            membership[counter] = counter;
            ++counter;
        }
        double[] ai = new double[nodeCount];
        for (int i2 = 0; i2 < nodeCount; ++i2) {
            ai[i2] = (double)network.getDegree(graphIndex[i2]) / (2.0 * (double)edgeCount);
        }
        double qInitial = 0.0;
        for (int i3 = 0; i3 < nodeCount; ++i3) {
            qInitial -= ai[i3] * ai[i3];
        }
        SparseDoubleMatrix2D deltaQMx = new SparseDoubleMatrix2D(nodeCount, nodeCount);
        double maxDeltaQ = 0.0;
        double q = 0.0;
        int maxI = 0;
        int maxJ = 0;
        double deltaQ = 0.0;
        for (int i4 = 0; i4 < nodeCount; ++i4) {
            for (int j = 0; j < nodeCount; ++j) {
                if (i4 == j || network.getEdgeCount(network.getNode(graphIndex[i4]), network.getNode(graphIndex[j]), false) <= 0 && network.getEdgeCount(network.getNode(graphIndex[j]), network.getNode(graphIndex[i4]), false) <= 0) continue;
                deltaQ = (1.0 / (double)(2 * edgeCount) - (double)(network.getDegree(graphIndex[i4]) * network.getDegree(graphIndex[j])) / (4.0 * Math.pow(edgeCount, 2.0))) * 2.0;
                deltaQMx.setQuick(i4, j, deltaQ);
                if (!(maxDeltaQ <= deltaQ)) continue;
                maxDeltaQ = deltaQ;
                maxI = i4;
                maxJ = j;
            }
        }
        if (maxI > maxJ) {
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        q = qInitial;
        while (maxDeltaQ > 0.0) {
            int k;
            q += maxDeltaQ;
            for (k = 0; k < nodeCount; ++k) {
                if (k == maxJ || k == maxI) continue;
                if (deltaQMx.getQuick(maxI, k) != 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) + deltaQMx.getQuick(maxI, k));
                    continue;
                }
                if (deltaQMx.getQuick(maxI, k) == 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) - 2.0 * ai[maxI] * ai[k]);
                    continue;
                }
                if (deltaQMx.getQuick(maxJ, k) != 0.0 || deltaQMx.getQuick(maxI, k) == 0.0) continue;
                deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxI, k) - 2.0 * ai[maxJ] * ai[k]);
            }
            for (k = 0; k < nodeCount; ++k) {
                deltaQMx.setQuick(k, maxJ, deltaQMx.getQuick(maxJ, k));
            }
            for (k = 0; k < nodeCount; ++k) {
                deltaQMx.setQuick(maxI, k, 0.0);
                deltaQMx.setQuick(k, maxI, 0.0);
            }
            ai[maxJ] = ai[maxI] + ai[maxJ];
            ai[maxI] = 0.0;
            int membershipI = membership[maxI];
            int membershipJ = membership[maxJ];
            for (i = 0; i < nodeCount; ++i) {
                if (membership[i] != membershipI) continue;
                membership[i] = membershipJ;
            }
            deltaQMx.trimToSize();
            maxDeltaQ = 0.0;
            maxI = 0;
            maxJ = 0;
            for (i = 0; i < nodeCount; ++i) {
                for (int j = 0; j < nodeCount; ++j) {
                    if (!(maxDeltaQ <= deltaQMx.getQuick(i, j))) continue;
                    maxDeltaQ = deltaQMx.getQuick(i, j);
                    maxI = i;
                    maxJ = j;
                }
            }
            if (maxI > maxJ) {
                int temp = maxI;
                maxI = maxJ;
                maxJ = temp;
            }
            System.out.println(q + " " + maxDeltaQ);
        }
        HashMap<Integer, Integer> membershipMapping = new HashMap<Integer, Integer>();
        int index = 0;
        for (i = 0; i < membership.length; ++i) {
            if (membershipMapping.containsKey(new Integer(membership[i]))) continue;
            membershipMapping.put(new Integer(membership[i]), new Integer(index));
            ++index;
        }
        for (i = 0; i < membership.length; ++i) {
            membership[i] = membershipMapping.get(new Integer(membership[i]));
        }
        FastGreedy.assignMembership(network, graphIndex, membership, membershipMapping);
        System.out.println(q);
    }

    private static void assignMembership(CyNetwork network, int[] graphIndex, int[] membership, HashMap<Integer, Integer> membershipMapping) {
        int i;
        int i2;
        CyAttributes attrN = Cytoscape.getNodeAttributes();
        CyAttributes attrE = Cytoscape.getEdgeAttributes();
        ArrayList nodeList = new ArrayList();
        for (i2 = 0; i2 < membershipMapping.size(); ++i2) {
            nodeList.add(new ArrayList());
        }
        for (i2 = 0; i2 < network.getNodeCount(); ++i2) {
            attrN.setAttribute(network.getNode(graphIndex[i2]).getIdentifier(), "membership", Integer.valueOf(membership[i2]));
            ((List)nodeList.get(membership[i2])).add(network.getNode(graphIndex[i2]));
        }
        MetaNode.expandAll();
        List grpList = CyGroupManager.getGroupList();
        for (i = 0; i < grpList.size(); ++i) {
            CyGroup grp = (CyGroup)grpList.get(i);
            if (!grp.getGroupName().startsWith(network.getIdentifier())) continue;
            CyGroupManager.removeGroup((CyGroup)grp);
        }
        for (i = 0; i < nodeList.size(); ++i) {
            CyGroup group = CyGroupManager.createGroup((String)(network.getIdentifier() + "_" + i), (List)((List)nodeList.get(i)), null);
            CyGroupManager.setGroupViewer((CyGroup)group, (String)"metaNode", (CyNetworkView)Cytoscape.getCurrentNetworkView(), (boolean)true);
        }
        int intraEdge = 0;
        int interEdge = 0;
        boolean totalEdge = false;
        Iterator it = network.edgesIterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (attrN.getIntegerAttribute(e.getSource().getIdentifier(), "membership") == attrN.getIntegerAttribute(e.getTarget().getIdentifier(), "membership")) {
                attrE.setAttribute(e.getIdentifier(), "class", Integer.valueOf(0));
                ++intraEdge;
                continue;
            }
            attrE.setAttribute(e.getIdentifier(), "class", Integer.valueOf(1));
            ++interEdge;
        }
    }

    private static void community(CyNetwork network) {
        int i;
        int i2;
        int nodeCount = network.getNodeCount();
        int edgeCount = network.getEdgeCount();
        int[] graphIndex = new int[nodeCount];
        int counter = 0;
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            graphIndex[counter] = node.getRootGraphIndex();
            ++counter;
        }
        SparseDoubleMatrix2D deltaQMx = new SparseDoubleMatrix2D(nodeCount, nodeCount);
        double[] ai = new double[nodeCount];
        double maxDeltaQ = 0.0;
        int maxI = 0;
        int maxJ = 0;
        double deltaQ = 0.0;
        double q = 0.0;
        for (i2 = 0; i2 < nodeCount; ++i2) {
            for (int j = 0; j < nodeCount; ++j) {
                if (i2 == j || network.getEdgeCount(network.getNode(graphIndex[i2]), network.getNode(graphIndex[j]), false) <= 0 && network.getEdgeCount(network.getNode(graphIndex[j]), network.getNode(graphIndex[i2]), false) <= 0) continue;
                deltaQ = 1.0 / (double)(2 * edgeCount) - (double)(network.getDegree(graphIndex[i2]) * network.getDegree(graphIndex[j])) / (4.0 * Math.pow(edgeCount, 2.0));
                q += deltaQ;
                deltaQMx.setQuick(i2, j, deltaQ);
                if (!(maxDeltaQ <= deltaQ)) continue;
                maxDeltaQ = deltaQ;
                maxI = i2;
                maxJ = j;
            }
        }
        System.out.println("The total initial Q:" + q);
        if (maxI > maxJ) {
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        for (i2 = 0; i2 < nodeCount; ++i2) {
            ai[i2] = (double)network.getDegree(graphIndex[i2]) / (2.0 * (double)edgeCount);
        }
        double qInitial = 0.0;
        for (i = 0; i < nodeCount; ++i) {
            qInitial -= ai[i] * ai[i];
        }
        System.out.println("The initial q is:" + qInitial);
        System.out.println(maxDeltaQ + " " + maxI + " " + maxJ);
        for (i = 0; i < nodeCount; ++i) {
            for (int j = 0; j < nodeCount; ++j) {
                System.out.printf("%2.3f ", deltaQMx.getQuick(i, j));
            }
            System.out.println("");
        }
        double totalQ = 0.0;
        int mergeCount = 0;
        while (maxDeltaQ > 0.0) {
            int k;
            for (k = 0; k < nodeCount; ++k) {
                if (k == maxJ || k == maxI) continue;
                if (deltaQMx.getQuick(maxI, k) != 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) + deltaQMx.getQuick(maxI, k));
                    System.out.println("added");
                    continue;
                }
                if (deltaQMx.getQuick(maxI, k) == 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) - 2.0 * ai[maxI] * ai[k]);
                    continue;
                }
                if (deltaQMx.getQuick(maxJ, k) != 0.0 || deltaQMx.getQuick(maxI, k) == 0.0) continue;
                deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxI, k) - 2.0 * ai[maxJ] * ai[k]);
            }
            for (k = 0; k < nodeCount; ++k) {
                deltaQMx.setQuick(k, maxJ, deltaQMx.getQuick(maxJ, k));
            }
            ai[maxJ] = ai[maxI] + ai[maxJ];
            ai[maxI] = 0.0;
            for (k = 0; k < nodeCount; ++k) {
                deltaQMx.setQuick(maxI, k, 0.0);
                deltaQMx.setQuick(k, maxI, 0.0);
            }
            deltaQMx.trimToSize();
            maxDeltaQ = 0.0;
            maxI = 0;
            maxJ = 0;
            for (int i3 = 0; i3 < nodeCount; ++i3) {
                for (int j = 0; j < nodeCount; ++j) {
                    if (!(maxDeltaQ <= deltaQMx.getQuick(i3, j))) continue;
                    maxDeltaQ = deltaQMx.getQuick(i3, j);
                    maxI = i3;
                    maxJ = j;
                }
            }
            if (maxI > maxJ) {
                int temp = maxI;
                maxI = maxJ;
                maxJ = temp;
            }
            System.out.println(maxDeltaQ + " " + maxI + " " + maxJ);
            System.out.println("Total Q at this round:" + ((totalQ += maxDeltaQ) + qInitial));
            ++mergeCount;
        }
        System.out.println("Total increased Q:" + totalQ);
        System.out.println("Total Q at the end:" + (totalQ + qInitial));
        System.out.println("Merge Count:" + mergeCount);
    }
}

