/*
 * Decompiled with CFR 0.152.
 */
package glay;

import csplugins.layout.algorithms.force.ForceDirectedLayout;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.actions.GinyUtils;
import cytoscape.data.CyAttributes;
import cytoscape.ding.DingNetworkView;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.algorithms.GridNodeLayout;
import cytoscape.view.CyNetworkView;
import cytoscape.view.cytopanels.CytoPanelImp;
import cytoscape.visual.VisualStyle;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import glay.util.FastGreedy2;
import glay.util.GLayVisualStyle;
import glay.util.RandomClusterModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import metaNodePlugin2.model.MetaNode;

public class GLayMainPanel
extends JPanel
implements PropertyChangeListener {
    private DefaultListModel clusterListModel = new DefaultListModel();
    private Task task;
    private JTabbedPane bodyPane;
    private JList clusterList;
    private JTextField clusterNumField;
    private JComboBox clusterSizeDistCombo;
    private JTextField clusterSizeField;
    private JComboBox comboAlgorithm;
    private JComboBox comboLayout;
    private JLabel edgeNumLabel;
    private JButton executeButton;
    private JButton generateButton;
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel messageLabel;
    private JLabel nodeNumLabel;
    private JTextField pInField;
    private JTextField pRatioField;
    private JProgressBar progressBar;
    private JPanel randGraphPanel;
    private JCheckBox resetCheck;
    private JLabel statusMsg;

    private void listDeSelected(int index) {
    }

    private void listSelected(int[] indices) {
        System.out.println("Select:" + indices.length);
        CyAttributes attrN = Cytoscape.getNodeAttributes();
        List grpList = CyGroupManager.getGroupList();
        CyNetwork network = Cytoscape.getCurrentNetwork();
        String id = network.getIdentifier();
        if (indices.length == 0) {
            for (CyGroup grp : grpList) {
                List nodeList = grp.getNodes();
                for (CyNode node : nodeList) {
                    attrN.setAttribute(node.getIdentifier(), "listActive", Integer.valueOf(1));
                    attrN.setAttribute(node.getIdentifier(), "type", Integer.valueOf(0));
                }
            }
        } else {
            for (CyGroup grp : grpList) {
                boolean selected = false;
                for (int index : indices) {
                    if (!grp.getGroupName().startsWith(id + "_" + index + "[")) continue;
                    List nodeList = grp.getNodes();
                    for (CyNode node : nodeList) {
                        attrN.setAttribute(node.getIdentifier(), "listActive", Integer.valueOf(1));
                        attrN.setAttribute(node.getIdentifier(), "type", Integer.valueOf(2));
                    }
                    selected = true;
                    break;
                }
                if (selected) continue;
                List nodeList = grp.getNodes();
                for (CyNode node : nodeList) {
                    attrN.setAttribute(node.getIdentifier(), "listActive", Integer.valueOf(0));
                    attrN.setAttribute(node.getIdentifier(), "type", Integer.valueOf(0));
                }
            }
        }
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    public void UIstatus(boolean status) {
        this.executeButton.setEnabled(status);
        this.jButton1.setEnabled(status);
        this.jButton3.setEnabled(status);
        this.comboAlgorithm.setEnabled(status);
        this.comboLayout.setEnabled(status);
        this.resetCheck.setEnabled(status);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    public GLayMainPanel() {
        this.initComponents();
    }

    public JTabbedPane getTabbedPane() {
        return this.bodyPane;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.bodyPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.comboAlgorithm = new JComboBox();
        this.jLabel2 = new JLabel();
        this.comboLayout = new JComboBox();
        this.executeButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.progressBar = new JProgressBar();
        this.resetCheck = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel5 = new JPanel();
        this.statusMsg = new JLabel();
        this.jPanel6 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.clusterList = new JList();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.randGraphPanel = new JPanel();
        this.jPanel7 = new JPanel();
        this.clusterNumField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.clusterSizeField = new JTextField();
        this.pInField = new JTextField();
        this.pRatioField = new JTextField();
        this.clusterSizeDistCombo = new JComboBox();
        this.generateButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jPanel8 = new JPanel();
        this.messageLabel = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.nodeNumLabel = new JLabel();
        this.edgeNumLabel = new JLabel();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jLabel1.setText("Algorithm");
        this.comboAlgorithm.setModel(new DefaultComboBoxModel<String>(new String[]{"Fast Greedy", "Fast Greedy(KW)"}));
        this.jLabel2.setText("Layout");
        this.comboLayout.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "Hierarchical"}));
        this.executeButton.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/control_fastforward_blue.png")));
        this.executeButton.setToolTipText("Start Clustering");
        this.executeButton.setHorizontalAlignment(2);
        this.executeButton.setHorizontalTextPosition(2);
        this.executeButton.setLabel("Execute");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.executeButtonActionPerformed(evt);
            }
        });
        this.progressBar.setVisible(false);
        this.resetCheck.setText("Reset");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 217, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.comboLayout, 0, -1, Short.MAX_VALUE).addComponent(this.comboAlgorithm, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resetCheck)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.progressBar, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.executeButton, -2, 93, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboAlgorithm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboLayout, -2, -1, -2).addComponent(this.resetCheck))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.progressBar, -1, 25, Short.MAX_VALUE).addComponent(this.executeButton)).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Global"));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/cog.png")));
        this.jButton1.setText("");
        this.jButton1.setToolTipText("Reset Default");
        this.jButton1.setBorder(null);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/control_equalizer.png")));
        this.jButton3.setText("");
        this.jButton3.setToolTipText("Remove GLay Panel");
        this.jButton3.setBorder(null);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addContainerGap(192, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jButton3)).addContainerGap(2, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusMsg.setText("Ready");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.statusMsg).addContainerGap(196, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.statusMsg).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Clusters"));
        this.clusterList.setModel(this.clusterListModel);
        this.jScrollPane1.setViewportView(this.clusterList);
        this.clusterList.setSelectionMode(2);
        this.clusterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                GLayMainPanel.this.listSelected(GLayMainPanel.this.clusterList.getSelectedIndices());
            }
        });
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/delete.png")));
        this.jButton4.setToolTipText("De-pop up all clusters");
        this.jButton4.setBorder(null);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/add.png")));
        this.jButton5.setToolTipText("Pop up clusters from selected nodes");
        this.jButton5.setBorder(null);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/zoom_in.png")));
        this.jButton6.setToolTipText("fit selected clusters");
        this.jButton6.setBorder(null);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/zoom_out.png")));
        this.jButton7.setToolTipText("Fit entire graph");
        this.jButton7.setBorder(null);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.jButton7ActionPerformed(evt);
            }
        });
        this.jButton8.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/shape_handles.png")));
        this.jButton8.setToolTipText("Select nodes in the selected clusters");
        this.jButton8.setBorder(null);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.jButton8ActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 217, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton5).addComponent(this.jButton4).addComponent(this.jButton8).addComponent(this.jButton6).addComponent(this.jButton7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 463, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.bodyPane.addTab("Community Str", this.jPanel1);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.clusterNumField.setText("4");
        this.jLabel3.setText("Number");
        this.jLabel4.setText("Size");
        this.jLabel5.setText("p-In");
        this.jLabel6.setText("p-In/Out ratio");
        this.jLabel7.setText("Size Distribution");
        this.clusterSizeField.setText("32");
        this.pInField.setText("0.2");
        this.pRatioField.setText("0.01");
        this.clusterSizeDistCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Uniform", "Poisson", "Exponential"}));
        this.generateButton.setIcon(new ImageIcon(this.getClass().getResource("/glay/extras/arrow_rotate_anticlockwise.png")));
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLayMainPanel.this.generateButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generateButton, -1, 217, Short.MAX_VALUE).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel6).addComponent(this.jLabel7)).addGap(9, 9, 9).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.clusterSizeDistCombo, 0, -1, Short.MAX_VALUE).addComponent(this.pRatioField).addComponent(this.pInField).addComponent(this.clusterSizeField).addComponent(this.clusterNumField, -1, 117, Short.MAX_VALUE))).addComponent(this.jSeparator2, -1, 217, Short.MAX_VALUE)).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.clusterNumField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.clusterSizeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.pInField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.pRatioField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.clusterSizeDistCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateButton).addContainerGap()));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.messageLabel.setText("...");
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel).addContainerGap(215, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.messageLabel).addContainerGap(20, Short.MAX_VALUE)));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder("Statistics"));
        this.jLabel8.setText("Node Num:");
        this.jLabel9.setText("Edge Num:");
        this.nodeNumLabel.setText("...");
        this.edgeNumLabel.setText("...");
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nodeNumLabel, -2, 90, -2).addComponent(this.edgeNumLabel, -1, 158, Short.MAX_VALUE)).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.nodeNumLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.edgeNumLabel)).addContainerGap(403, Short.MAX_VALUE)));
        GroupLayout randGraphPanelLayout = new GroupLayout(this.randGraphPanel);
        this.randGraphPanel.setLayout(randGraphPanelLayout);
        randGraphPanelLayout.setHorizontalGroup(randGraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, randGraphPanelLayout.createSequentialGroup().addContainerGap().addGroup(randGraphPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel9, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel8, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        randGraphPanelLayout.setVerticalGroup(randGraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(randGraphPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.bodyPane.addTab("Rand Gen", this.randGraphPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bodyPane, -1, 274, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bodyPane, -1, 823, Short.MAX_VALUE));
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        CytoPanelImp ctrlPanel = (CytoPanelImp)Cytoscape.getDesktop().getCytoPanel(7);
        int indexInCytoPanel = ctrlPanel.indexOfComponent("GLay");
        ctrlPanel.remove(indexInCytoPanel);
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.clusterList.clearSelection();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        List nodeList = Cytoscape.getCurrentNetworkView().getSelectedNodes();
        CyNetwork nw = Cytoscape.getCurrentNetwork();
        HashSet groupSet = new HashSet();
        for (NodeView node : nodeList) {
            groupSet.addAll(CyGroupManager.getGroup((CyNode)((CyNode)node.getNode())));
        }
        int nwIdLength = nw.getIdentifier().length() + 1;
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (CyGroup grp : groupSet) {
            String id = grp.getGroupName();
            if (!id.startsWith(nw.getIdentifier() + "_")) continue;
            int end = id.indexOf("[CLUSTER]");
            index.add(Integer.parseInt(id.substring(nwIdLength, end)));
        }
        int[] indices = new int[index.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)index.get(i);
        }
        this.clusterList.setSelectedIndices(indices);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        CyNetworkView nwv = Cytoscape.getCurrentNetworkView();
        CyNetwork nw = Cytoscape.getCurrentNetwork();
        int[] indices = this.clusterList.getSelectedIndices();
        if (indices.length == 0) {
            nwv.fitContent();
        } else {
            List selected = nwv.getSelectedNodes();
            GinyUtils.deselectAllNodes((GraphView)nwv);
            for (int index : indices) {
                CyGroup grp = CyGroupManager.findGroup((String)(nw.getIdentifier() + "_" + index + "[CLUSTER]"));
                List nodeList = grp.getNodes();
                nw.setSelectedNodeState((Collection)nodeList, true);
            }
            ((DingNetworkView)Cytoscape.getCurrentNetworkView()).fitSelected();
            GinyUtils.deselectAllNodes((GraphView)nwv);
            nw.setSelectedNodeState((Collection)selected, true);
            nwv.updateView();
        }
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        Cytoscape.getCurrentNetworkView().fitContent();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        CyNetwork nw = Cytoscape.getCurrentNetwork();
        CyNetworkView nwv = Cytoscape.getCurrentNetworkView();
        int[] indices = this.clusterList.getSelectedIndices();
        ArrayList nodeList = new ArrayList();
        for (int index : indices) {
            CyGroup grp = CyGroupManager.findGroup((String)(nw.getIdentifier() + "_" + index + "[CLUSTER]"));
            nodeList.addAll(grp.getNodes());
        }
        nw.setSelectedNodeState(nodeList, true);
        nwv.updateView();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        System.out.println(this.pInField.getText());
        System.out.println(this.pRatioField.getText());
        System.out.println(this.clusterNumField.getText());
        System.out.println(this.clusterSizeField.getText());
        System.out.println(this.clusterSizeDistCombo.getSelectedIndex());
        double pIn = Double.parseDouble(this.pInField.getText());
        double pRatio = Double.parseDouble(this.pRatioField.getText());
        int model = this.clusterSizeDistCombo.getSelectedIndex();
        int clusterNum = Integer.parseInt(this.clusterNumField.getText());
        int clusterSize = Integer.parseInt(this.clusterSizeField.getText());
        RandomClusterModel rcm = new RandomClusterModel(pIn, pRatio, model);
        CyNetwork network = rcm.generateModel(clusterNum, clusterSize);
        CyNetworkView nwv = Cytoscape.createNetworkView((CyNetwork)network);
        this.messageLabel.setText("Network Generation Successful");
        this.nodeNumLabel.setText(network.getNodeCount() + "");
        this.edgeNumLabel.setText(network.getEdgeCount() + "");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.clusterListModel.clear();
        this.comboAlgorithm.setSelectedIndex(0);
        this.comboLayout.setSelectedIndex(0);
        this.resetCheck.setSelected(false);
        this.statusMsg.setText("Ready");
        List grpList = CyGroupManager.getGroupList();
        for (CyGroup grp : grpList) {
            if (!grp.getGroupName().startsWith(Cytoscape.getCurrentNetwork().getIdentifier())) continue;
            CyGroupManager.removeGroup((CyGroup)grp);
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        private double blowUpCoefficient;

        Task() {
        }

        @Override
        public Void doInBackground() {
            GLayMainPanel.this.UIstatus(false);
            int progress = 0;
            this.setProgress(progress);
            GLayMainPanel.this.progressBar.setVisible(true);
            MetaNode.expandAll();
            FastGreedy2 fg = new FastGreedy2();
            if (GLayMainPanel.this.comboAlgorithm.getSelectedIndex() == 0) {
                fg.setMode(0);
            } else if (GLayMainPanel.this.comboAlgorithm.getSelectedIndex() == 1) {
                fg.setMode(1);
            }
            Thread th = new Thread(fg);
            th.start();
            while (progress < 100) {
                GLayMainPanel.this.statusMsg.setText("Processing...");
                try {
                    Thread.sleep(100L);
                    progress = fg.getCurrentProgress();
                    this.setProgress(progress);
                }
                catch (InterruptedException e) {}
            }
            GLayMainPanel.this.statusMsg.setText("Casting Layouts...");
            GLayMainPanel.this.clusterListModel.clear();
            List grpList = CyGroupManager.getGroupList();
            int metaNodeCount = 0;
            for (CyGroup grp : grpList) {
                if (!grp.getGroupName().endsWith("[CLUSTER]")) continue;
                GLayMainPanel.this.clusterListModel.add(metaNodeCount, "Cluster " + metaNodeCount);
                ++metaNodeCount;
            }
            ForceDirectedLayout alg = new ForceDirectedLayout();
            if (GLayMainPanel.this.resetCheck.isSelected()) {
                Cytoscape.getCurrentNetworkView().applyLayout((CyLayoutAlgorithm)new GridNodeLayout());
            }
            Cytoscape.getCurrentNetworkView().applyLayout((CyLayoutAlgorithm)alg);
            if (GLayMainPanel.this.comboLayout.getSelectedIndex() != 0 && GLayMainPanel.this.comboLayout.getSelectedIndex() == 1) {
                NodeView nv;
                this.blowUpCoefficient = (double)Cytoscape.getCurrentNetwork().getNodeCount() / 45.0;
                System.out.println(this.blowUpCoefficient);
                MetaNode.collapseAll();
                Cytoscape.getCurrentNetworkView().applyLayout((CyLayoutAlgorithm)alg);
                double x = 0.0;
                double y = 0.0;
                int total = 0;
                grpList = CyGroupManager.getGroupList();
                for (CyGroup grp : grpList) {
                    if (!grp.getGroupName().startsWith(Cytoscape.getCurrentNetwork().getIdentifier())) continue;
                    nv = Cytoscape.getCurrentNetworkView().getNodeView((Node)grp.getGroupNode());
                    x += nv.getXPosition();
                    y += nv.getYPosition();
                    ++total;
                }
                x /= (double)total;
                y /= (double)total;
                for (CyGroup grp : grpList) {
                    if (grp.getGroupName().startsWith(Cytoscape.getCurrentNetwork().getIdentifier())) {
                        nv = Cytoscape.getCurrentNetworkView().getNodeView((Node)grp.getGroupNode());
                        nv.setXPosition(nv.getXPosition() + (nv.getXPosition() - x) * this.blowUpCoefficient, false);
                        nv.setYPosition(nv.getYPosition() + (nv.getYPosition() - y) * this.blowUpCoefficient, false);
                        continue;
                    }
                    System.out.println("There's another group");
                }
                MetaNode.expandAll();
                Cytoscape.getCurrentNetworkView().fitContent();
            }
            VisualStyle vs = GLayVisualStyle.createClusterVisualStyle(Cytoscape.getCurrentNetwork());
            Cytoscape.getVisualMappingManager().setVisualStyle("GLay");
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(3);
            GLayMainPanel.this.statusMsg.setText("Modularity: " + nf.format(fg.getModularity()));
            return null;
        }

        @Override
        public void done() {
            GLayMainPanel.this.progressBar.setVisible(false);
            GLayMainPanel.this.progressBar.setValue(0);
            GLayMainPanel.this.UIstatus(true);
        }
    }
}

