/*
 * Decompiled with CFR 0.152.
 */
package glay;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.AbstractLayout;
import giny.view.NodeView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class GLayClusterModel
extends AbstractLayout {
    public String toString() {
        return "GLay.RandomClusterModel";
    }

    public String getName() {
        return "GRCM";
    }

    public void construct() {
        CyAttributes attrN = Cytoscape.getNodeAttributes();
        CyAttributes attrE = Cytoscape.getEdgeAttributes();
        Iterator nVI = this.networkView.getNodeViewsIterator();
        HashSet<Integer> hs = new HashSet<Integer>();
        while (nVI.hasNext()) {
            NodeView nv = (NodeView)nVI.next();
            int membership = attrN.getIntegerAttribute(nv.getNode().getIdentifier(), "membership");
            hs.add(membership);
        }
        System.out.println("Number of Clusters in the data:" + hs.size());
        int clusterCount = hs.size();
        int[][] clusterCoord = new int[2][clusterCount];
        Random gen = new Random();
        int spacing = 1000;
        for (int i = 0; i < clusterCount; ++i) {
            clusterCoord[0][i] = (int)Math.round((double)(spacing + gen.nextInt(500)) * Math.sin(gen.nextDouble() * 2.0 * Math.PI));
            clusterCoord[1][i] = (int)Math.round((double)(spacing + gen.nextInt(500)) * Math.cos(gen.nextDouble() * 2.0 * Math.PI));
        }
        int spacingCluster = 200;
        nVI = this.networkView.getNodeViewsIterator();
        while (nVI.hasNext()) {
            NodeView nV = (NodeView)nVI.next();
            int membership = attrN.getIntegerAttribute(nV.getNode().getIdentifier(), "membership");
            int xCoord = clusterCoord[0][membership] + (int)Math.round((double)spacingCluster * Math.sin(gen.nextDouble() * 2.0 * Math.PI));
            int yCoord = clusterCoord[1][membership] + (int)Math.round((double)spacingCluster * Math.sin(gen.nextDouble() * 2.0 * Math.PI));
            nV.setXPosition((double)xCoord, false);
            nV.setYPosition((double)yCoord, false);
        }
        this.networkView.updateView();
    }
}

