/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectingJListSample {
    public static void main(String[] args) {
        String[] labels = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
        JFrame frame = new JFrame("Selecting JList");
        frame.setDefaultCloseOperation(3);
        JList<String> jlist = new JList<String>(labels);
        JScrollPane scrollPane1 = new JScrollPane(jlist);
        frame.add((Component)scrollPane1, "Center");
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                System.out.println("First index: " + listSelectionEvent.getFirstIndex());
                System.out.println(", Last index: " + listSelectionEvent.getLastIndex());
                boolean adjust = listSelectionEvent.getValueIsAdjusting();
                System.out.println(", Adjusting? " + adjust);
                if (!adjust) {
                    JList list = (JList)listSelectionEvent.getSource();
                    int[] selections = list.getSelectedIndices();
                    Object[] selectionValues = list.getSelectedValues();
                    int n = selections.length;
                    for (int i = 0; i < n; ++i) {
                        if (i == 0) {
                            System.out.println(" Selections: ");
                        }
                        System.out.println(selections[i] + "/" + selectionValues[i] + " ");
                    }
                }
            }
        };
        jlist.addListSelectionListener(listSelectionListener);
        frame.setSize(350, 200);
        frame.setVisible(true);
    }
}

