/*
 * Decompiled with CFR 0.152.
 */
package metaNodePlugin2;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.groups.CyGroupViewer;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.view.CyNetworkView;
import ding.view.NodeContextMenuListener;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import metaNodePlugin2.model.MetaNode;

public class MetaNodePlugin2
extends CytoscapePlugin
implements CyGroupViewer,
NodeContextMenuListener,
PropertyChangeListener {
    public static final String viewerName = "metaNode";
    public static final double VERSION = 1.01;
    public static boolean multipleEdges = false;
    public static boolean recursive = true;
    public static final int EXPANDED = 1;
    public static final int COLLAPSED = 2;
    private static CyGroupViewer groupViewer = null;
    private static boolean registeredWithGroupPanel = false;
    private Method updateMethod = null;
    private CyGroupViewer namedSelectionViewer = null;
    protected int descendents = 0;

    public MetaNodePlugin2() {
        try {
            Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener("NETWORK_VIEW_CREATED", this);
            Cytoscape.getCurrentNetworkView().addNodeContextMenuListener((NodeContextMenuListener)this);
        }
        catch (ClassCastException e) {
            System.out.println(e.getMessage());
        }
        JMenu menu = new JMenu("MetaNode Operations");
        menu.addMenuListener(new MetanodeMenuListener(null));
        JMenu pluginMenu = Cytoscape.getDesktop().getCyMenus().getMenuBar().getMenu("Plugins");
        pluginMenu.add(menu);
        CyGroupManager.registerGroupViewer((CyGroupViewer)this);
        groupViewer = this;
        this.registerWithGroupPanel();
        System.out.println("metaNodePlugin2 1.01 initialized");
    }

    public String getViewerName() {
        return viewerName;
    }

    public void groupCreated(CyGroup group) {
        if (MetaNode.getMetaNode(group) == null) {
            MetaNode metaNode = new MetaNode(group);
        }
        this.registerWithGroupPanel();
    }

    public void groupCreated(CyGroup group, CyNetworkView myview) {
        if (MetaNode.getMetaNode(group) == null) {
            MetaNode newNode = new MetaNode(group);
            if (group.getState() == 2) {
                newNode.recollapse(recursive, multipleEdges, myview);
            } else {
                CyNetwork network = myview.getNetwork();
                network.hideNode((Node)group.getGroupNode());
            }
        }
        this.registerWithGroupPanel();
    }

    public void groupWillBeRemoved(CyGroup group) {
        MetaNode mn = MetaNode.getMetaNode(group);
        if (group.getState() == 2) {
            mn.expand(true, null, true);
        }
        MetaNode.removeMetaNode(mn);
    }

    public void groupChanged(CyGroup group, CyNode node, CyGroupViewer.ChangeType change) {
        MetaNode mn = MetaNode.getMetaNode(group);
        if (mn == null) {
            return;
        }
        if (change == CyGroupViewer.ChangeType.NODE_ADDED) {
            mn.nodeAdded(node);
        } else if (change == CyGroupViewer.ChangeType.NODE_REMOVED) {
            mn.nodeRemoved(node);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "NETWORK_VIEW_CREATED") {
            ((CyNetworkView)e.getNewValue()).addNodeContextMenuListener((NodeContextMenuListener)this);
        }
    }

    public void addNodeContextMenuItems(NodeView nodeView, JPopupMenu menu) {
        if (menu == null) {
            menu = new JPopupMenu();
        }
        menu.add(this.getNodePopupMenu(nodeView));
    }

    private JMenu getNodePopupMenu(NodeView nodeView) {
        JMenu menu = new JMenu("Metanode operations");
        menu.addMenuListener(new MetanodeMenuListener(nodeView));
        return menu;
    }

    private void registerWithGroupPanel() {
        if (registeredWithGroupPanel) {
            try {
                this.updateMethod.invoke((Object)this.namedSelectionViewer, new Object[0]);
            }
            catch (Exception e) {
                System.err.println(e);
            }
            return;
        }
        this.namedSelectionViewer = CyGroupManager.getGroupViewer((String)"namedSelection");
        if (this.namedSelectionViewer == null) {
            return;
        }
        if (this.namedSelectionViewer.getClass().getName().equals("namedSelection.NamedSelection")) {
            try {
                this.updateMethod = this.namedSelectionViewer.getClass().getMethod("updateGroupPanel", new Class[0]);
                Method regMethod = this.namedSelectionViewer.getClass().getMethod("addViewerToGroupPanel", CyGroupViewer.class);
                regMethod.invoke((Object)this.namedSelectionViewer, this);
                registeredWithGroupPanel = true;
            }
            catch (Exception e) {
                System.err.println(e);
                return;
            }
        }
    }

    private class MetanodeCommandListener
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private Command command;
        private CyGroup group = null;
        private CyNode node = null;

        MetanodeCommandListener(Command command, CyGroup group, CyNode node) {
            this.command = command;
            this.group = group;
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MetaNodePlugin2.this.registerWithGroupPanel();
            String label = ae.getActionCommand();
            if (this.command == Command.COLLAPSE) {
                this.collapse();
            } else if (this.command == Command.EXPAND) {
                this.expand();
            } else if (this.command == Command.EXPANDNEW) {
                this.createNetworkFromGroup();
            } else if (this.command == Command.NEW) {
                this.newGroup();
            } else if (this.command == Command.REMOVE) {
                this.removeGroup();
            } else if (this.command == Command.ADD) {
                this.addToGroup(this.node);
            } else if (this.command == Command.DELETE) {
                this.removeFromGroup(this.node);
            } else if (this.command == Command.EXPANDALL) {
                this.expandAll();
            } else if (this.command == Command.COLLAPSEALL) {
                this.collapseAll();
            }
        }

        private void newGroup() {
            CyNetwork network = Cytoscape.getCurrentNetwork();
            ArrayList currentNodes = new ArrayList(network.getSelectedNodes());
            List groupList = CyGroupManager.getGroupList();
            String groupName = JOptionPane.showInputDialog("Please enter a name for this metanode");
            if (groupName == null) {
                return;
            }
            CyGroup group = CyGroupManager.createGroup((String)groupName, currentNodes, (String)MetaNodePlugin2.viewerName);
            if (group == null) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "There is already a group named " + groupName, "GroupError", 0);
                return;
            }
            MetaNode newNode = new MetaNode(group);
            MetaNodePlugin2.this.groupCreated(group);
            newNode.collapse(recursive, multipleEdges, true, null);
        }

        private void removeGroup() {
            this.expand();
            CyGroupManager.removeGroup((CyGroup)this.group);
        }

        private void addToGroup(CyNode node) {
            if (node != null) {
                node.addToGroup(this.group);
            } else {
                CyNetwork network = Cytoscape.getCurrentNetwork();
                ArrayList currentNodes = new ArrayList(network.getSelectedNodes());
                for (CyNode selNode : currentNodes) {
                    selNode.addToGroup(this.group);
                }
            }
        }

        private void removeFromGroup(CyNode node) {
            if (node != null) {
                if (this.group.contains(node)) {
                    node.removeFromGroup(this.group);
                }
            } else {
                CyNetwork network = Cytoscape.getCurrentNetwork();
                ArrayList currentNodes = new ArrayList(network.getSelectedNodes());
                for (CyNode selNode : currentNodes) {
                    if (!this.group.contains(selNode)) continue;
                    selNode.removeFromGroup(this.group);
                }
            }
        }

        private void collapse() {
            MetaNode mNode = MetaNode.getMetaNode(this.group);
            mNode.collapse(recursive, multipleEdges, true, null);
        }

        private void expand() {
            MetaNode mNode = MetaNode.getMetaNode(this.group);
            mNode.expand(recursive, null, true);
        }

        private void createNetworkFromGroup() {
            MetaNode mNode = MetaNode.getMetaNode(this.group);
            mNode.createNetworkFromGroup();
        }

        private void expandAll() {
            MetaNode.expandAll();
        }

        private void collapseAll() {
            MetaNode.collapseAll();
        }
    }

    public class MetanodeMenuListener
    implements MenuListener {
        private MetanodeCommandListener staticHandle;
        private NodeView overNode = null;
        private CyNode contextNode = null;

        MetanodeMenuListener(NodeView nv) {
            this.staticHandle = new MetanodeCommandListener(Command.NONE, null, null);
            this.overNode = nv;
            if (nv != null) {
                this.contextNode = (CyNode)this.overNode.getNode();
            }
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            Component[] subMenus = m.getMenuComponents();
            for (int i = 0; i < subMenus.length; ++i) {
                m.remove(subMenus[i]);
            }
            CyNetwork network = Cytoscape.getCurrentNetwork();
            Set currentNodes = network.getSelectedNodes();
            List groupList = CyGroupManager.getGroupList((CyGroupViewer)groupViewer);
            List nodeGroups = null;
            if (this.contextNode != null) {
                nodeGroups = this.contextNode.getGroups();
            }
            JMenuItem item = new JMenuItem("Create new metanode");
            MetanodeCommandListener l = new MetanodeCommandListener(Command.NEW, null, null);
            item.addActionListener(l);
            if (currentNodes.size() > 0) {
                item.setEnabled(true);
            } else {
                item.setEnabled(false);
            }
            m.add(item);
            this.addMenuItem(m, Command.EXPAND, groupList, this.contextNode, "Expand metanode");
            this.addMenuItem(m, Command.COLLAPSE, groupList, this.contextNode, "Collapse metanode");
            this.addMenuItem(m, Command.EXPANDNEW, groupList, this.contextNode, "Expand metanode");
            this.addMenuItem(m, Command.REMOVE, groupList, this.contextNode, "Remove metanode");
            this.addMenuItem(m, Command.ADD, groupList, this.contextNode, "Add node to metanode");
            this.addMenuItem(m, Command.DELETE, groupList, this.contextNode, "Remove node from metanode");
            this.addMenuItem(m, Command.EXPANDALL, groupList, null, "Expand all metanodes");
            this.addMenuItem(m, Command.COLLAPSEALL, groupList, null, "Collapse all metanodes");
        }

        private void addMenuItem(JMenu menu, Command command, List<CyGroup> groupList, CyNode contextNode, String label) {
            List nodeGroups;
            if (groupList == null || groupList.size() == 0) {
                if (contextNode == null) {
                    JMenuItem item = new JMenuItem(label);
                    item.setEnabled(false);
                    menu.add(item);
                }
            } else if (contextNode == null) {
                JMenu item;
                if (command == Command.EXPANDALL || command == Command.COLLAPSEALL) {
                    this.addSubMenu(menu, label, command, null, null);
                } else if (command == Command.EXPANDNEW) {
                    JMenu item2 = new JMenu(label + "(s) into new network");
                    if (this.addGroupMenu(item2, command, groupList, contextNode)) {
                        menu.add(item2);
                    }
                } else if (command != Command.ADD && command != Command.DELETE) {
                    JMenu item3 = new JMenu(label);
                    if (this.addGroupMenu(item3, command, groupList, contextNode)) {
                        menu.add(item3);
                    }
                } else if (command == Command.ADD) {
                    JMenu item4 = new JMenu("Add node(s) to metanode");
                    if (this.addGroupMenu(item4, command, groupList, null)) {
                        menu.add(item4);
                    }
                } else if (command == Command.DELETE && this.addGroupMenu(item = new JMenu("Remove node(s) from metanode"), command, groupList, null)) {
                    menu.add(item);
                }
            } else if (contextNode.isaGroup() && command == Command.EXPAND) {
                CyGroup group = CyGroupManager.findGroup((String)contextNode.getIdentifier());
                if (group.getState() == 2) {
                    this.addSubMenu(menu, label + " " + group.getGroupName(), command, group, contextNode);
                }
            } else if (CyGroupManager.isaGroup((CyNode)contextNode) && command == Command.EXPANDNEW) {
                CyGroup group = CyGroupManager.findGroup((String)contextNode.getIdentifier());
                if (group.getState() == 2) {
                    this.addSubMenu(menu, label + " " + group.getGroupName() + " into new network", command, group, contextNode);
                }
            } else if (command == Command.COLLAPSE) {
                List nodeGroups2 = contextNode.getGroups();
                if (nodeGroups2 != null && nodeGroups2.size() > 0) {
                    if (nodeGroups2.size() == 1) {
                        CyGroup group = (CyGroup)nodeGroups2.get(0);
                        this.addSubMenu(menu, label + " " + group.getGroupName(), command, group, contextNode);
                    } else {
                        JMenu item = new JMenu(label);
                        if (this.addGroupMenu(item, command, nodeGroups2, contextNode)) {
                            menu.add(item);
                        }
                    }
                }
            } else if (command == Command.ADD) {
                if (groupList.size() == 1 && !groupList.get(0).getGroupName().equals(contextNode.getIdentifier())) {
                    CyGroup group = groupList.get(0);
                    List nodeGroups3 = contextNode.getGroups();
                    if (nodeGroups3 == null || !nodeGroups3.contains(group)) {
                        this.addSubMenu(menu, label + " " + group.getGroupName(), command, group, contextNode);
                    }
                } else {
                    JMenu item = new JMenu(label);
                    if (this.addGroupMenu(item, command, groupList, contextNode)) {
                        menu.add(item);
                    }
                }
            } else if (command == Command.DELETE && (nodeGroups = contextNode.getGroups()) != null && nodeGroups.size() > 0) {
                if (nodeGroups.size() == 1) {
                    CyGroup group = (CyGroup)nodeGroups.get(0);
                    this.addSubMenu(menu, label + " " + group.getGroupName(), command, group, contextNode);
                } else {
                    JMenu item = new JMenu(label);
                    if (this.addGroupMenu(item, command, nodeGroups, contextNode)) {
                        menu.add(item);
                    }
                }
            }
        }

        private boolean addGroupMenu(JMenu menu, Command command, List<CyGroup> groupList, CyNode node) {
            List nodeGroups = null;
            boolean foundItem = false;
            if (groupList == null) {
                return false;
            }
            if (command == Command.ADD && node != null) {
                nodeGroups = node.getGroups();
            }
            for (CyGroup group : groupList) {
                CyNode groupNode = group.getGroupNode();
                List parents = groupNode.getGroups();
                if (group.getViewer() == null || !group.getViewer().equals(groupViewer.getViewerName()) || command == Command.COLLAPSE && group.getState() == 2 || command == Command.EXPAND && group.getState() == 1) continue;
                if (command == Command.EXPAND && parents != null && parents.size() > 0) {
                    boolean parentCollapsed = false;
                    for (CyGroup parent : parents) {
                        if (!groupList.contains(parent) || parent.getState() != 2) continue;
                        parentCollapsed = true;
                        break;
                    }
                    if (parentCollapsed) continue;
                }
                if (command == Command.ADD) {
                    MetaNode metaNode = null;
                    if (nodeGroups != null && nodeGroups.contains(group) || (metaNode = MetaNode.getMetaNode(node)) != null && metaNode.getCyGroup() == group) continue;
                }
                foundItem = true;
                this.addSubMenu(menu, group.getGroupName(), command, group, node);
            }
            return foundItem;
        }

        private void addSubMenu(JMenu menu, String label, Command command, CyGroup group, CyNode node) {
            JMenuItem item = new JMenuItem(label);
            MetanodeCommandListener l = new MetanodeCommandListener(command, group, node);
            item.addActionListener(l);
            menu.add(item);
        }
    }

    public static enum Command {
        NONE("none"),
        COLLAPSE("collapse"),
        EXPAND("expand"),
        NEW("new"),
        REMOVE("remove"),
        ADD("add"),
        DELETE("delete"),
        EXPANDALL("expandAll"),
        COLLAPSEALL("collapseAll"),
        EXPANDNEW("expandNew");

        private String name;

        private Command(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

